#ifndef QACCESSIBLETEXTINTERFACE_IMPL_SHELL_H
#define QACCESSIBLETEXTINTERFACE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qaccessible.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qpoint.h>
#include <QtCore/qrect.h>
#include <QtGui/qaccessible_base.h>
#include <QtJambi/RegistryAPI>


class QAccessibleTextInterface_shell : public QAccessibleTextInterface, public QtJambiShellInterface
{
public:
    QAccessibleTextInterface_shell();
    ~QAccessibleTextInterface_shell() override;

    void addSelection(int startOffset0, int endOffset1) override;
    QString attributes(int offset0, int* startOffset1, int* endOffset2) const override;
    int characterCount() const override;
    QRect characterRect(int offset0) const override;
    int cursorPosition() const override;
    int offsetAtPoint(const QPoint& point0) const override;
    void removeSelection(int selectionIndex0) override;
    void scrollToSubstring(int startIndex0, int endIndex1) override;
    void selection(int selectionIndex0, int* startOffset1, int* endOffset2) const override;
    int selectionCount() const override;
    void setCursorPosition(int position0) override;
    void setSelection(int selectionIndex0, int startOffset1, int endOffset2) override;
    QString text(int startOffset0, int endOffset1) const override;
    QString textAfterOffset(int offset0, QAccessible::TextBoundaryType boundaryType1, int* startOffset2, int* endOffset3) const override;
    QString textAtOffset(int offset0, QAccessible::TextBoundaryType boundaryType1, int* startOffset2, int* endOffset3) const override;
    QString textBeforeOffset(int offset0, QAccessible::TextBoundaryType boundaryType1, int* startOffset2, int* endOffset3) const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QAccessibleTextInterface_access : public QAccessibleTextInterface
{
    void __qt_addSelection_int_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint startOffset0, jint endOffset1);
    jstring __qt_attributes_int_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jintArray startOffset1, jintArray endOffset2) const;
    jint __qt_characterCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_characterRect_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0) const;
    jint __qt_cursorPosition_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_offsetAtPoint_cref_QPoint_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID point0) const;
    void __qt_removeSelection_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint selectionIndex0);
    void __qt_scrollToSubstring_int_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint startIndex0, jint endIndex1);
    void __qt_selection_int_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint selectionIndex0, jintArray startOffset1, jintArray endOffset2) const;
    jint __qt_selectionCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_setCursorPosition_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint position0);
    void __qt_setSelection_int_int_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint selectionIndex0, jint startOffset1, jint endOffset2);
    jstring __qt_text_int_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint startOffset0, jint endOffset1) const;
    jstring __qt_textAfterOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jint boundaryType1, jintArray startOffset2, jintArray endOffset3) const;
    jstring __qt_textAtOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jint boundaryType1, jintArray startOffset2, jintArray endOffset3) const;
    jstring __qt_textBeforeOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jint boundaryType1, jintArray startOffset2, jintArray endOffset3) const;
};

#endif // QACCESSIBLETEXTINTERFACE_IMPL_SHELL_H
