#ifndef QACCESSIBLEVALUEINTERFACE_IMPL_SHELL_H
#define QACCESSIBLEVALUEINTERFACE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qaccessible.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtJambi/RegistryAPI>


class QAccessibleValueInterface_shell : public QAccessibleValueInterface, public QtJambiShellInterface
{
public:
    QAccessibleValueInterface_shell();
    ~QAccessibleValueInterface_shell() override;

    QVariant currentValue() const override;
    QVariant maximumValue() const override;
    QVariant minimumStepSize() const override;
    QVariant minimumValue() const override;
    void setCurrentValue(const QVariant& value0) override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QAccessibleValueInterface_access : public QAccessibleValueInterface
{
    jobject __qt_currentValue_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_maximumValue_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_minimumStepSize_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_minimumValue_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_setCurrentValue_cref_QVariant(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject value0);
};

#endif // QACCESSIBLEVALUEINTERFACE_IMPL_SHELL_H
