#include "QPaintDevice_shell.h"
#include <QtJambi/Cast>

void deleter_QPaintDevice(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QPaintDevice")
    QPaintDevice *_ptr = reinterpret_cast<QPaintDevice *>(ptr);
    if(!isShell){
        struct PaintDeviceAccess : QPaintDevice{
            inline QPainter* getSharedPainter() const { return sharedPainter(); }
        };
        if(QPainter* painter = reinterpret_cast<PaintDeviceAccess*>(dynamic_cast<QPaintDevice*>(_ptr))->getSharedPainter()){
            if(painter->isActive()){
                painter->end();
            }
        }
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QPaintDevice_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QPaintDevice_shell) ); }

jmethodID QPaintDevice_shell::__shell_javaMethod(int pos) const { return QPaintDevice_shell::__shell()->javaMethod(typeid(QPaintDevice), pos); }

// emitting (writeShellConstructor)
QPaintDevice_shell::QPaintDevice_shell()
    : QPaintDevice()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QPaintDevice::QPaintDevice_shell()", QPaintDevice_shell::__shell())
    QPaintDevice_shell::__shell()->constructed(typeid(QPaintDevice));
}

// emitting (writeShellDestructor)
QPaintDevice_shell::~QPaintDevice_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QPaintDevice::~QPaintDevice()", QPaintDevice_shell::__shell())
    if(QPainter* painter = QPaintDevice_shell::sharedPainter()){
        if(painter->isActive()){
            painter->end();
        }
    }
    QPaintDevice_shell::__shell()->destructed(typeid(QPaintDevice));
}

void QPaintDevice_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QPaintDevice_shell*>(ptr)->QPaintDevice_shell::__shell()->tryDeleteShell(typeid(QPaintDevice));
}

// emitting Virtual overrides (virtualFunctions)
void QPaintDevice_shell::initPainter(QPainter* painter0) const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QPaintDevice::", QPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_painter0 = qtjambi_cast<jobject>(__jni_env, painter0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_painter0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_painter0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QPaintDevice_shell::__shell()->warnForMethod("QPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPaintDevice::");
            } QTJAMBI_TRY_END
        }else{
            QPaintDevice::initPainter(painter0);
        }
    }else{
        QPaintDevice::initPainter(painter0);
    }
}

int QPaintDevice_shell::metric(QPaintDevice::PaintDeviceMetric metric0) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QPaintDevice::", QPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_metric0 = qtjambi_cast<jobject>(__jni_env, metric0);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_metric0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QPaintDevice_shell::__shell()->warnForMethod("QPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPaintDevice::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::metric(QPaintDevice::PaintDeviceMetric(metric0));
        }
    }else{
        return QPaintDevice::metric(QPaintDevice::PaintDeviceMetric(metric0));
    }
}

QPaintEngine* QPaintDevice_shell::paintEngine() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QPaintDevice::", QPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintEngine*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintEngine* >(__jni_env, __java_return_value);
                } else {
                    QPaintDevice_shell::__shell()->warnForMethod("QPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPaintDevice::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QPaintDevice* QPaintDevice_shell::redirected(QPoint* offset0) const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QPaintDevice::", QPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintDevice*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_offset0 = qtjambi_cast<jobject>(__jni_env, offset0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_offset0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_offset0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintDevice* >(__jni_env, __java_return_value);
                } else {
                    QPaintDevice_shell::__shell()->warnForMethod("QPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPaintDevice::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::redirected(offset0);
        }
    }else{
        return QPaintDevice::redirected(offset0);
    }
}

QPainter* QPaintDevice_shell::sharedPainter() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QPaintDevice::", QPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPainter*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPainter* >(__jni_env, __java_return_value);
                } else {
                    QPaintDevice_shell::__shell()->warnForMethod("QPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPaintDevice::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::sharedPainter();
        }
    }else{
        return QPaintDevice::sharedPainter();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
void QPaintDevice_access::__qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice::initPainter(__qt_painter0);
    } else {
        initPainter(__qt_painter0);
    }
}

jint QPaintDevice_access::__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPaintDevice::PaintDeviceMetric __qt_metric0 = qtjambi_cast<QPaintDevice::PaintDeviceMetric>(__jni_env, metric0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QPaintDevice::metric(__qt_metric0);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = metric(__qt_metric0);
        return jint(__qt_return_value);
    }
}

jobject QPaintDevice_access::__qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QPaintDevice::paintEngine() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QPaintDevice::paintEngine() const.";
    } else {
        QPaintEngine* __qt_return_value = paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QPaintDevice_access::__qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPoint* __qt_offset0 = QtJambiAPI::objectFromNativeId<QPoint>(offset0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice* __qt_return_value = QPaintDevice::redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintDevice* __qt_return_value = redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QPaintDevice_access::__qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPainter* __qt_return_value = QPaintDevice::sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPainter* __qt_return_value = sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QPaintDevice()
void __qt_construct_QPaintDevice(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPaintDevice()")
    Q_UNUSED(__java_arguments)
    QPaintDevice *__qt_this = new(__qtjambi_ptr) QPaintDevice_shell();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QPaintDevice::QPaintDevice()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_initialize_1native__Lio_qt_gui_QPaintDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPaintDevice::QPaintDevice()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPaintDevice, sizeof(QPaintDevice_shell), typeid(QPaintDevice), true, &deleter_QPaintDevice, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QPaintDevice_shell
void __qt_destruct_QPaintDevice(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QPaintDevice")
    reinterpret_cast<QPaintDevice_shell*>(ptr)->~QPaintDevice_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QPaintDevice::colorCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_colorCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::colorCount()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::colorCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::depth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_depth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::depth()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::depth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::devicePixelRatio()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_devicePixelRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::devicePixelRatio()const", __qt_this)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatio();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::devicePixelRatioF()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_devicePixelRatioF_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::devicePixelRatioF()const", __qt_this)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatioF();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::height()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::heightMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_heightMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::heightMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::heightMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::logicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_logicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::logicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::logicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_logicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::logicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::paintingActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_paintingActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::paintingActive()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::paintingActive();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::physicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_physicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::physicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::physicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_physicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::physicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::width()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::widthMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_widthMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::widthMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::widthMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::initPainter(QPainter*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_initPainter_1native_1QPainter_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0)
{
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::initPainter(QPainter*)const", __qt_this)
        static_cast<const QPaintDevice_access*>(__qt_this)->__qt_initPainter_QPainter_ptr_constfct(__jni_env, __this_nativeId, painter0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_metric_1native_1QPaintDevice_1PaintDeviceMetric_1constfct__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint metric0)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const", __qt_this)
        __java_return_value = static_cast<const QPaintDevice_access*>(__qt_this)->__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(__jni_env, __this_nativeId, metric0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::paintEngine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_00024ConcreteWrapper_paintEngine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::paintEngine()const", __qt_this)
        __java_return_value = static_cast<const QPaintDevice_access*>(__qt_this)->__qt_paintEngine_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::redirected(QPoint*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_redirected_1native_1QPoint_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID offset0)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::redirected(QPoint*)const", __qt_this)
        __java_return_value = static_cast<const QPaintDevice_access*>(__qt_this)->__qt_redirected_QPoint_ptr_constfct(__jni_env, __this_nativeId, offset0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::sharedPainter()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_sharedPainter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice *__qt_this = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintDevice::sharedPainter()const", __qt_this)
        __java_return_value = static_cast<const QPaintDevice_access*>(__qt_this)->__qt_sharedPainter_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::devicePixelRatioFScale()
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_devicePixelRatioFScale__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPaintDevice::devicePixelRatioFScale()")
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        qreal __qt_return_value = QPaintDevice::devicePixelRatioFScale();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintDevice::qt_paint_device_metric(const QPaintDevice*,QPaintDevice::PaintDeviceMetric)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintDevice_00024Impl_qt_1paint_1device_1metric_1native_1const_1QPaintDevice_1ptr_1QPaintDevice_1PaintDeviceMetric__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID device0,
 jint metric1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPaintDevice::qt_paint_device_metric(const QPaintDevice*,QPaintDevice::PaintDeviceMetric)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintDevice* __qt_device0 = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(device0);
        QPaintDevice::PaintDeviceMetric __qt_metric1 = qtjambi_cast<QPaintDevice::PaintDeviceMetric>(__jni_env, metric1);
        __java_return_value = qt_paint_device_metric(__qt_device0, QPaintDevice::PaintDeviceMetric(__qt_metric1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QPaintDevice(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerInterfaceTypeInfo<QPaintDevice>("QPaintDevice", "io/qt/gui/QPaintDevice");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/* 0 */ "initPainter", "(Lio/qt/gui/QPainter;)V"),
        FunctionInfo(/* 1 */ "metric", "(Lio/qt/gui/QPaintDevice$PaintDeviceMetric;)I"),
        FunctionInfo(/* 2 */ "paintEngine", "()Lio/qt/gui/QPaintEngine;", FunctionInfo::Abstract),
        FunctionInfo(/* 3 */ "redirected", "(Lio/qt/core/QPoint;)Lio/qt/gui/QPaintDevice;"),
        FunctionInfo(/* 4 */ "sharedPainter", "()Lio/qt/gui/QPainter;")});
    registerConstructorInfos(typeId, &__qt_destruct_QPaintDevice, {
        ConstructorInfo(&__qt_construct_QPaintDevice, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QPaintDevice);
    registerSizeOfShell(typeId, sizeof(QPaintDevice_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QObject), typeId, [](void *ptr, qintptr& offset) -> bool {
            QObject *object = reinterpret_cast<QObject *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QPaintDevice* _object = dynamic_cast<QPaintDevice*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerPolymorphyHandler(typeId, typeid(QObject), [](void *ptr, qintptr& offset) -> bool {
            QPaintDevice *object = reinterpret_cast<QPaintDevice *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QObject* _object = dynamic_cast<QObject*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerOwnerFunction(typeId, [](const void *ptr)->const QObject*{
        const QPaintDevice *object = reinterpret_cast<const QPaintDevice *>(ptr);
        const QObject* _result = nullptr;
        QTJAMBI_TRY_ANY {
            _result = dynamic_cast<const QObject*>(object);
        } QTJAMBI_CATCH_ANY{
        } QTJAMBI_TRY_END
        return _result;
    });
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QPaintDevice::PaintDeviceMetric>("QPaintDevice::PaintDeviceMetric", "io/qt/gui/QPaintDevice$PaintDeviceMetric");
// END: enums and flags
}
