#ifndef QPAINTDEVICE_IMPL_SHELL_H
#define QPAINTDEVICE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qpaintdevice.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qpoint.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainter.h>
#include "utils_p.h"
#include <QtJambi/RegistryAPI>


class QPaintDevice_shell : public QPaintDevice, public QtJambiShellInterface
{
public:
    QPaintDevice_shell();
    ~QPaintDevice_shell() override;

    void initPainter(QPainter* painter0) const override;
    int metric(QPaintDevice::PaintDeviceMetric metric0) const override;
    QPaintEngine* paintEngine() const override;
    QPaintDevice* redirected(QPoint* offset0) const override;
    QPainter* sharedPainter() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QPaintDevice_access : public QPaintDevice
{
    void __qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const;
    jint __qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const;
    jobject __qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const;
    jobject __qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QPAINTDEVICE_IMPL_SHELL_H
