#ifndef QRHIBUFFER_SHELL_H
#define QRHIBUFFER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtJambi/JavaAPI>
#include <QtJambi/RegistryAPI>


class QRhiBuffer_shell : public QRhiBuffer, public QtJambiShellInterface
{
public:
    ~QRhiBuffer_shell() override;

    char* beginFullDynamicBufferUpdateForCurrentFrame() override;
    bool create() override;
    void destroy() override;
    void endFullDynamicBufferUpdateForCurrentFrame() override;
    QRhiBuffer::NativeBuffer nativeBuffer() override;
    QRhiResource::Type resourceType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiBuffer_access : public QRhiBuffer
{
    jobject __qt_beginFullDynamicBufferUpdateForCurrentFrame(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_create(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_endFullDynamicBufferUpdateForCurrentFrame(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_nativeBuffer(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHIBUFFER_SHELL_H
