#ifndef QRHISWAPCHAINRENDERTARGET_SHELL_H
#define QRHISWAPCHAINRENDERTARGET_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qsize.h>
#include <QtJambi/RegistryAPI>


class QRhiSwapChainRenderTarget_shell : public QRhiSwapChainRenderTarget, public QtJambiShellInterface
{
public:
    ~QRhiSwapChainRenderTarget_shell() override;

    void destroy() override;
    float devicePixelRatio() const override;
    QSize pixelSize() const override;
    QRhiResource::Type resourceType() const override;
    int sampleCount() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiSwapChainRenderTarget_access : public QRhiSwapChainRenderTarget
{
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jfloat __qt_devicePixelRatio_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_pixelSize_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_sampleCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHISWAPCHAINRENDERTARGET_SHELL_H
