#ifndef QRHISWAPCHAIN_SHELL_H
#define QRHISWAPCHAIN_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qsize.h>
#include <QtGui/qwindow.h>
#include <QtJambi/RegistryAPI>


class QRhiSwapChain_shell : public QRhiSwapChain, public QtJambiShellInterface
{
public:
    ~QRhiSwapChain_shell() override;

    bool createOrResize() override;
    QRhiCommandBuffer* currentFrameCommandBuffer() override;
    QRhiRenderTarget* currentFrameRenderTarget() override;
    QRhiRenderTarget* currentFrameRenderTarget(QRhiSwapChain::StereoTargetBuffer targetBuffer0) override;
    void destroy() override;
    QRhiSwapChainHdrInfo hdrInfo() override;
    bool isFormatSupported(QRhiSwapChain::Format f0) override;
    QRhiRenderPassDescriptor* newCompatibleRenderPassDescriptor() override;
    QRhiResource::Type resourceType() const override;
    QSize surfacePixelSize() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiSwapChain_access : public QRhiSwapChain
{
    jboolean __qt_createOrResize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_currentFrameCommandBuffer(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_currentFrameRenderTarget(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_currentFrameRenderTarget_QRhiSwapChain_StereoTargetBuffer(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint targetBuffer0);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_hdrInfo(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_isFormatSupported_QRhiSwapChain_Format(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint f0);
    jobject __qt_newCompatibleRenderPassDescriptor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_surfacePixelSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
};

#endif // QRHISWAPCHAIN_SHELL_H
