#ifndef QGRAPHICSANCHORLAYOUT_SHELL_H
#define QGRAPHICSANCHORLAYOUT_SHELL_H

#include <QtCore/QtGlobal>
#include <qtwidgets-config.h>
#if QT_CONFIG(graphicsview)
#include <QtWidgets/qgraphicsanchorlayout.h>
#endif //QT_CONFIG(graphicsview)
#include <QtJambi/QtJambiAPI>
#include <QGraphicsObject>
#include <QGraphicsWidget>
#include <QObject>
#include <QtCore/QVariant>
#include <QtCore/qcoreevent.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#if QT_CONFIG(graphicsview)
#include <QtWidgets/qgraphicsitem.h>
#endif //QT_CONFIG(graphicsview)
#if QT_CONFIG(graphicsview)
#include <QtWidgets/qgraphicslayoutitem.h>
#endif //QT_CONFIG(graphicsview)
#include <QtWidgets/qsizepolicy.h>
#include "utils_p.h"
#include <QtJambi/RegistryAPI>


#if QT_CONFIG(graphicsview)

class QGraphicsAnchorLayout_shell : public QGraphicsAnchorLayout, public QtJambiShellInterface
{
public:
    QGraphicsAnchorLayout_shell(QGraphicsLayoutItem* parent0 = nullptr);
    ~QGraphicsAnchorLayout_shell() override;

    int count() const override;
    void getContentsMargins(qreal* left0, qreal* top1, qreal* right2, qreal* bottom3) const override;
    void invalidate() override;
    bool isEmpty() const override;
    QGraphicsLayoutItem* itemAt(int index0) const override;
    void removeAt(int index0) override;
    void setGeometry(const QRectF& rect0) override;
    QSizeF sizeHint(Qt::SizeHint which0, const QSizeF& constraint1) const override;
    void updateGeometry() override;
    void widgetEvent(QEvent* e0) override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QGraphicsAnchorLayout_access : public QGraphicsAnchorLayout
{
    jint __qt_count_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_invalidate(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_itemAt_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint index0) const;
    void __qt_removeAt_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint index0);
    void __qt_setGeometry_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID rect0);
    jobject __qt_sizeHint_Qt_SizeHint_cref_QSizeF_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint which0, QtJambiNativeID constraint1) const;
};

#endif // QT_CONFIG(graphicsview)
#endif // QGRAPHICSANCHORLAYOUT_SHELL_H
