package io.qt.qml;


/**
 * <p>Acts as a container for Qt/JavaScript data types</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qjsvalue.html">QJSValue</a></p>
 */
public class QJSValue extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qjsvalue.html#ErrorType-enum">QJSValue::ErrorType</a></p>
     */
    public enum ErrorType implements io.qt.QtEnumerator {
        NoError(0),
        GenericError(1),
        EvalError(2),
        RangeError(3),
        ReferenceError(4),
        SyntaxError(5),
        TypeError(6),
        URIError(7);

        private ErrorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ErrorType resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return GenericError;
            case 2: return EvalError;
            case 3: return RangeError;
            case 4: return ReferenceError;
            case 5: return SyntaxError;
            case 6: return TypeError;
            case 7: return URIError;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qjsvalue.html#SpecialValue-enum">QJSValue::SpecialValue</a></p>
     */
    public enum SpecialValue implements io.qt.QtEnumerator {
        NullValue(0),
        UndefinedValue(1);

        private SpecialValue(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SpecialValue resolve(int value) {
            switch (value) {
            case 0: return NullValue;
            case 1: return UndefinedValue;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QJSValue(io.qt.qml.QJSValue.SpecialValue)}
     *  with <code>value = io.qt.qml.QJSValue.SpecialValue.UndefinedValue</code>.</p>
     */
    public QJSValue() {
        this(io.qt.qml.QJSValue.SpecialValue.UndefinedValue);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#QJSValue">QJSValue::QJSValue(QJSValue::SpecialValue)</a></p>
     */
    public QJSValue(io.qt.qml.QJSValue.SpecialValue value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSValue instance, io.qt.qml.QJSValue.SpecialValue value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#QJSValue-3">QJSValue::QJSValue(bool)</a></p>
     */
    public QJSValue(boolean value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSValue instance, boolean value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#QJSValue-1">QJSValue::QJSValue(QJSValue)</a></p>
     */
    public QJSValue(io.qt.qml.QJSValue other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QJSValue instance, io.qt.qml.QJSValue other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#QJSValue-7">QJSValue::QJSValue(QString)</a></p>
     */
    public QJSValue(java.lang.String value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSValue instance, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#QJSValue-6">QJSValue::QJSValue(double)</a></p>
     */
    public QJSValue(double value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSValue instance, double value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#QJSValue-4">QJSValue::QJSValue(int)</a></p>
     */
    public QJSValue(int value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSValue instance, int value);
    
    /**
     * <p>Overloaded function for {@link #call(java.util.Collection)}
     *  with <code>args = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue call() {
        return call(java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#call">QJSValue::call(QJSValueList)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue call(java.util.Collection<QJSValue> args){
        return call_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), args);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue call_native_cref_QList(long __this__nativeId, java.util.Collection<QJSValue> args);
    
    /**
     * <p>Overloaded function for {@link #callAsConstructor(java.util.Collection)}
     *  with <code>args = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callAsConstructor() {
        return callAsConstructor(java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#callAsConstructor">QJSValue::callAsConstructor(QJSValueList)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callAsConstructor(java.util.Collection<QJSValue> args){
        return callAsConstructor_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), args);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue callAsConstructor_native_cref_QList(long __this__nativeId, java.util.Collection<QJSValue> args);
    
    /**
     * <p>Overloaded function for {@link #callWithInstance(io.qt.qml.QJSValue, java.util.Collection)}
     *  with <code>args = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callWithInstance(io.qt.qml.QJSValue instance) {
        return callWithInstance(instance, java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#callWithInstance">QJSValue::callWithInstance(QJSValue,QJSValueList)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callWithInstance(io.qt.qml.QJSValue instance, java.util.Collection<QJSValue> args){
        return callWithInstance_native_cref_QJSValue_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(instance), args);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue callWithInstance_native_cref_QJSValue_cref_QList(long __this__nativeId, long instance, java.util.Collection<QJSValue> args);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#deleteProperty">QJSValue::deleteProperty(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean deleteProperty(java.lang.String name){
        return deleteProperty_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean deleteProperty_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue-obsolete.html#engine">QJSValue::engine()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#equals">QJSValue::equals(QJSValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean equals(io.qt.qml.QJSValue other){
        return equals_native_cref_QJSValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean equals_native_cref_QJSValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#errorType">QJSValue::errorType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue.ErrorType errorType(){
        return io.qt.qml.QJSValue.ErrorType.resolve(errorType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int errorType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#hasOwnProperty">QJSValue::hasOwnProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasOwnProperty(java.lang.String name){
        return hasOwnProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasOwnProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#hasProperty">QJSValue::hasProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasProperty(java.lang.String name){
        return hasProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isArray">QJSValue::isArray()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isArray(){
        return isArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isBool">QJSValue::isBool()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isBoolean(){
        return isBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isCallable">QJSValue::isCallable()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCallable(){
        return isCallable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCallable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isDate">QJSValue::isDate()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDate(){
        return isDate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isError">QJSValue::isError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isNull">QJSValue::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isNumber">QJSValue::isNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNumber(){
        return isNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isObject">QJSValue::isObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isObject(){
        return isObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isQMetaObject">QJSValue::isQMetaObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isQMetaObject(){
        return isQMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isQMetaObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isQObject">QJSValue::isQObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isQObject(){
        return isQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isRegExp">QJSValue::isRegExp()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isRegExp(){
        return isRegExp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRegExp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isString">QJSValue::isString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isString(){
        return isString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#isUndefined">QJSValue::isUndefined()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isUndefined(){
        return isUndefined_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUndefined_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#property">QJSValue::property(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue property(java.lang.String name){
        return property_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue property_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#property-1">QJSValue::property(quint32)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue property(int arrayIndex){
        return property_native_unsigned_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue property_native_unsigned_int_constfct(long __this__nativeId, int arrayIndex);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#prototype">QJSValue::prototype()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue prototype(){
        return prototype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue prototype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#setProperty">QJSValue::setProperty(QString,QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, io.qt.qml.QJSValue value){
        setProperty_native_cref_QString_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_cref_QString_cref_QJSValue(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#setProperty-1">QJSValue::setProperty(quint32,QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.qml.QJSValue value){
        setProperty_native_unsigned_int_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_unsigned_int_cref_QJSValue(long __this__nativeId, int arrayIndex, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#setPrototype">QJSValue::setPrototype(QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrototype(io.qt.qml.QJSValue prototype){
        setPrototype_native_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(prototype));
    }
    
    @io.qt.QtUninvokable
    private native void setPrototype_native_cref_QJSValue(long __this__nativeId, long prototype);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#strictlyEquals">QJSValue::strictlyEquals(QJSValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean strictlyEquals(io.qt.qml.QJSValue other){
        return strictlyEquals_native_cref_QJSValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean strictlyEquals_native_cref_QJSValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toBool">QJSValue::toBool()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean toBoolean(){
        return toBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean toBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toDateTime">QJSValue::toDateTime()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QDateTime toDateTime(){
        return toDateTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QDateTime toDateTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toInt">QJSValue::toInt()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int toInt(){
        return toInt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int toInt_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toNumber">QJSValue::toNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double toDouble(){
        return toDouble_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double toDouble_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toQObject">QJSValue::toQObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject toQObject(){
        return toQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject toQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toString">QJSValue::toString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qjsvalue.html#toVariant">QJSValue::toVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object toObject(){
        return toObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object toObject_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QJSValue(QPrivateConstructor p) { super(p); } 
    
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, String value)    {
        setProperty(name, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, boolean value)    {
        setProperty(name, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, double value)    {
        setProperty(name, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, int value)    {
        setProperty(name, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, QJSValue.SpecialValue value)    {
        setProperty(name, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, String value)    {
        setProperty(arrayIndex, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, boolean value)    {
        setProperty(arrayIndex, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, double value)    {
        setProperty(arrayIndex, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, int value)    {
        setProperty(arrayIndex, new QJSValue(value));
    }
    
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, QJSValue.SpecialValue value)    {
        setProperty(arrayIndex, new QJSValue(value));
    }
    
    @Override
    public QJSValue clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QJSValue clone_native(long __this_nativeId);
}
