package io.qt.qml;


/**
 * <p>Convenient way to load an application from a single QML file</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html">QQmlApplicationEngine</a></p>
 */
public class QQmlApplicationEngine extends io.qt.qml.QQmlEngine
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlApplicationEngine.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#objectCreated">QQmlApplicationEngine::objectCreated(QObject*,QUrl)</a></p>
     */
    public final Signal2<io.qt.core.QObject, io.qt.core.QUrl> objectCreated = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #QQmlApplicationEngine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlApplicationEngine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#QQmlApplicationEngine">QQmlApplicationEngine::QQmlApplicationEngine(QObject*)</a></p>
     */
    public QQmlApplicationEngine(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQmlApplicationEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlApplicationEngine(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlApplicationEngine(java.lang.String filePath) {
        this(filePath, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#QQmlApplicationEngine-2">QQmlApplicationEngine::QQmlApplicationEngine(QString,QObject*)</a></p>
     */
    public QQmlApplicationEngine(java.lang.String filePath, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, filePath, parent);
    }
    
    private native static void initialize_native(QQmlApplicationEngine instance, java.lang.String filePath, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlApplicationEngine(io.qt.core.QUrl, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlApplicationEngine(io.qt.core.QUrl url) {
        this(url, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#QQmlApplicationEngine-1">QQmlApplicationEngine::QQmlApplicationEngine(QUrl,QObject*)</a></p>
     */
    public QQmlApplicationEngine(io.qt.core.QUrl url, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, url, parent);
    }
    
    private native static void initialize_native(QQmlApplicationEngine instance, io.qt.core.QUrl url, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#load-1">QQmlApplicationEngine::load(QString)</a></p>
     */
    public final void load(java.lang.String filePath){
        load_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filePath);
    }
    
    private native void load_native_cref_QString(long __this__nativeId, java.lang.String filePath);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#load">QQmlApplicationEngine::load(QUrl)</a></p>
     */
    public final void load(io.qt.core.QUrl url){
        load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void load_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>Overloaded function for {@link #loadData(io.qt.core.QByteArray, io.qt.core.QUrl)}
     *  with <code>url = new io.qt.core.QUrl()</code>.</p>
     */
    public final void loadData(io.qt.core.QByteArray data) {
        loadData(data, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#loadData">QQmlApplicationEngine::loadData(QByteArray,QUrl)</a></p>
     */
    public final void loadData(io.qt.core.QByteArray data, io.qt.core.QUrl url){
        loadData_native_cref_QByteArray_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void loadData_native_cref_QByteArray_cref_QUrl(long __this__nativeId, long data, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#rootObjects">QQmlApplicationEngine::rootObjects()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QObject> rootObjects(){
        return rootObjects_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QObject> rootObjects_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlapplicationengine.html#setInitialProperties">QQmlApplicationEngine::setInitialProperties(QVariantMap)</a></p>
     */
    public final void setInitialProperties(java.util.Map<java.lang.String, java.lang.Object> initialProperties){
        setInitialProperties_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialProperties);
    }
    
    private native void setInitialProperties_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, java.lang.Object> initialProperties);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlApplicationEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQmlApplicationEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQmlApplicationEngine instance, QDeclarativeConstructor constructor);
    
}
