package io.qt.qml;


/**
 * <p>Encapsulates a QML component definition</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qqmlcomponent.html">QQmlComponent</a></p>
 */
public class QQmlComponent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlComponent.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#CompilationMode-enum">QQmlComponent::CompilationMode</a></p>
     */
    public enum CompilationMode implements io.qt.QtEnumerator {
        PreferSynchronous(0),
        Asynchronous(1);

        private CompilationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static CompilationMode resolve(int value) {
            switch (value) {
            case 0: return PreferSynchronous;
            case 1: return Asynchronous;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#Status-enum">QQmlComponent::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        Null(0),
        Ready(1),
        Loading(2),
        Error(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return Null;
            case 1: return Ready;
            case 2: return Loading;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#progressChanged">QQmlComponent::progressChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="progress")
    public final Signal1<@io.qt.QtPrimitiveType Double> progressChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#statusChanged">QQmlComponent::statusChanged(QQmlComponent::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qml.QQmlComponent.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QQmlComponent(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlComponent() {
        this((io.qt.core.QObject)null);
    }
    
    public QQmlComponent(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQmlComponent instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlComponent(io.qt.qml.QQmlEngine, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1) {
        this(arg__1, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-1">QQmlComponent::QQmlComponent(QQmlEngine*,QObject*)</a></p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, parent);
    }
    
    private native static void initialize_native(QQmlComponent instance, io.qt.qml.QQmlEngine arg__1, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlComponent(io.qt.qml.QQmlEngine, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, java.lang.String fileName) {
        this(arg__1, fileName, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-2">QQmlComponent::QQmlComponent(QQmlEngine*,QString,QObject*)</a></p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, java.lang.String fileName, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, fileName, parent);
    }
    
    private native static void initialize_native(QQmlComponent instance, io.qt.qml.QQmlEngine arg__1, java.lang.String fileName, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlComponent(io.qt.qml.QQmlEngine, java.lang.String, io.qt.qml.QQmlComponent.CompilationMode, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, java.lang.String fileName, io.qt.qml.QQmlComponent.CompilationMode mode) {
        this(arg__1, fileName, mode, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-3">QQmlComponent::QQmlComponent(QQmlEngine*,QString,QQmlComponent::CompilationMode,QObject*)</a></p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, java.lang.String fileName, io.qt.qml.QQmlComponent.CompilationMode mode, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, fileName, mode, parent);
    }
    
    private native static void initialize_native(QQmlComponent instance, io.qt.qml.QQmlEngine arg__1, java.lang.String fileName, io.qt.qml.QQmlComponent.CompilationMode mode, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlComponent(io.qt.qml.QQmlEngine, io.qt.core.QUrl, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, io.qt.core.QUrl url) {
        this(arg__1, url, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-4">QQmlComponent::QQmlComponent(QQmlEngine*,QUrl,QObject*)</a></p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, io.qt.core.QUrl url, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, url, parent);
    }
    
    private native static void initialize_native(QQmlComponent instance, io.qt.qml.QQmlEngine arg__1, io.qt.core.QUrl url, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlComponent(io.qt.qml.QQmlEngine, io.qt.core.QUrl, io.qt.qml.QQmlComponent.CompilationMode, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, io.qt.core.QUrl url, io.qt.qml.QQmlComponent.CompilationMode mode) {
        this(arg__1, url, mode, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#QQmlComponent-5">QQmlComponent::QQmlComponent(QQmlEngine*,QUrl,QQmlComponent::CompilationMode,QObject*)</a></p>
     */
    public QQmlComponent(io.qt.qml.QQmlEngine arg__1, io.qt.core.QUrl url, io.qt.qml.QQmlComponent.CompilationMode mode, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, url, mode, parent);
    }
    
    private native static void initialize_native(QQmlComponent instance, io.qt.qml.QQmlEngine arg__1, io.qt.core.QUrl url, io.qt.qml.QQmlComponent.CompilationMode mode, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded function for {@link #create(io.qt.qml.QQmlIncubator, io.qt.qml.QQmlContext, io.qt.qml.QQmlContext)}
     *  with <code>forContext = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void create(io.qt.qml.QQmlIncubator arg__1, io.qt.qml.QQmlContext context) {
        create(arg__1, context, (io.qt.qml.QQmlContext)null);
    }
    
    /**
     * <p>Overloaded function for {@link #create(io.qt.qml.QQmlIncubator, io.qt.qml.QQmlContext, io.qt.qml.QQmlContext)}</p>
     * <p>with: </p><ul>
     * <li><code>context = null</code></li>
     * <li><code>forContext = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void create(io.qt.qml.QQmlIncubator arg__1) {
        create(arg__1, (io.qt.qml.QQmlContext)null, (io.qt.qml.QQmlContext)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#create-1">QQmlComponent::create(QQmlIncubator&amp;,QQmlContext*,QQmlContext*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void create(io.qt.qml.QQmlIncubator arg__1, io.qt.qml.QQmlContext context, io.qt.qml.QQmlContext forContext){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        create_native_ref_QQmlIncubator_QQmlContext_ptr_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(context), QtJambi_LibraryUtilities.internal.checkedNativeId(forContext));
    }
    
    @io.qt.QtUninvokable
    private native void create_native_ref_QQmlIncubator_QQmlContext_ptr_QQmlContext_ptr(long __this__nativeId, long arg__1, long context, long forContext);
    
    /**
     * <p>Overloaded function for {@link #createWithInitialProperties(java.util.Map, io.qt.qml.QQmlContext)}
     *  with <code>context = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject createWithInitialProperties(java.util.Map<java.lang.String, java.lang.Object> initialProperties) {
        return createWithInitialProperties(initialProperties, (io.qt.qml.QQmlContext)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#createWithInitialProperties">QQmlComponent::createWithInitialProperties(QVariantMap,QQmlContext*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject createWithInitialProperties(java.util.Map<java.lang.String, java.lang.Object> initialProperties, io.qt.qml.QQmlContext context){
        return createWithInitialProperties_native_cref_QMap_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), initialProperties, QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject createWithInitialProperties_native_cref_QMap_QQmlContext_ptr(long __this__nativeId, java.util.Map<java.lang.String, java.lang.Object> initialProperties, long context);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#creationContext">QQmlComponent::creationContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlContext creationContext(){
        return creationContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlContext creationContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#engine">QQmlComponent::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlEngine engine_native_constfct(long __this__nativeId);
    
    public final java.lang.String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#errors">QQmlComponent::errors()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qml.QQmlError> errors(){
        return errors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qml.QQmlError> errors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#isError">QQmlComponent::isError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#isLoading">QQmlComponent::isLoading()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isLoading(){
        return isLoading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLoading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#isNull">QQmlComponent::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#isReady">QQmlComponent::isReady()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isReady(){
        return isReady_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isReady_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#loadUrl">QQmlComponent::loadUrl(QUrl)</a></p>
     */
    public final void loadUrl(io.qt.core.QUrl url){
        loadUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void loadUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#loadUrl-1">QQmlComponent::loadUrl(QUrl,QQmlComponent::CompilationMode)</a></p>
     */
    public final void loadUrl(io.qt.core.QUrl url, io.qt.qml.QQmlComponent.CompilationMode mode){
        loadUrl_native_cref_QUrl_QQmlComponent_CompilationMode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), mode.value());
    }
    
    private native void loadUrl_native_cref_QUrl_QQmlComponent_CompilationMode(long __this__nativeId, long url, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#progress-prop">QQmlComponent::progress()const</a></p>
     */
    @io.qt.QtPropertyReader(name="progress")
    @io.qt.QtUninvokable
    public final double progress(){
        return progress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double progress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#setData">QQmlComponent::setData(QByteArray,QUrl)</a></p>
     */
    public final void setData(io.qt.core.QByteArray arg__1, io.qt.core.QUrl baseUrl){
        setData_native_cref_QByteArray_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    private native void setData_native_cref_QByteArray_cref_QUrl(long __this__nativeId, long arg__1, long baseUrl);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#setInitialProperties">QQmlComponent::setInitialProperties(QObject*,QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setInitialProperties(io.qt.core.QObject component, java.util.Map<java.lang.String, java.lang.Object> properties){
        setInitialProperties_native_QObject_ptr_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(component), properties);
    }
    
    @io.qt.QtUninvokable
    private native void setInitialProperties_native_QObject_ptr_cref_QMap(long __this__nativeId, long component, java.util.Map<java.lang.String, java.lang.Object> properties);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#status-prop">QQmlComponent::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlComponent.Status status(){
        return io.qt.qml.QQmlComponent.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#url-prop">QQmlComponent::url()const</a></p>
     */
    @io.qt.QtPropertyReader(name="url")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#beginCreate">QQmlComponent::beginCreate(QQmlContext*)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QObject beginCreate(io.qt.qml.QQmlContext arg__1){
        return beginCreate_native_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject beginCreate_native_QQmlContext_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#completeCreate">QQmlComponent::completeCreate()</a></p>
     */
    @io.qt.QtUninvokable
    public void completeCreate(){
        completeCreate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void completeCreate_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #create(io.qt.qml.QQmlContext)}
     *  with <code>context = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject create() {
        return create((io.qt.qml.QQmlContext)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlcomponent.html#create">QQmlComponent::create(QQmlContext*)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QObject create(io.qt.qml.QQmlContext context){
        return create_native_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject create_native_QQmlContext_ptr(long __this__nativeId, long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlComponent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQmlComponent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQmlComponent instance, QDeclarativeConstructor constructor);
    
    @io.qt.QtUninvokable
    public final void setData(String data, io.qt.core.QUrl baseUrl)    {
        setData(new io.qt.core.QByteArray(data), baseUrl);
    }
    
    @io.qt.QtUninvokable
    public final void setData(byte[] data, io.qt.core.QUrl baseUrl)    {
        setData(new io.qt.core.QByteArray(data), baseUrl);
    }
    
    @io.qt.QtUninvokable
    public <T extends io.qt.core.QObject> T create(Class<T> type)    {
        return create(type, (io.qt.qml.QQmlContext)null);
    }
    
    @io.qt.QtUninvokable
    public <T extends io.qt.core.QObject> T create(Class<T> type, io.qt.qml.QQmlContext context)    {
        String packageName = type.getName();
        int idx = packageName.lastIndexOf('.');
        if(idx>0){
            packageName = packageName.substring(0, idx);
        }
        io.qt.QtUtilities.initializePackage(packageName);
        return type.cast(create(context));
    }
}
