package io.qt.qml;


/**
 * <p>Environment for instantiating QML components</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qqmlengine.html">QQmlEngine</a></p>
 */
public class QQmlEngine extends io.qt.qml.QJSEngine
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcUrlInterceptor = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcNetworkAccessManagerFactory = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcIncubationController = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qqmlengine.html#ObjectOwnership-enum">QQmlEngine::ObjectOwnership</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ObjectOwnership implements io.qt.QtEnumerator {
        CppOwnership(0),
        JavaScriptOwnership(1);

        private ObjectOwnership(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ObjectOwnership resolve(int value) {
            switch (value) {
            case 0: return CppOwnership;
            case 1: return JavaScriptOwnership;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#exit">QQmlEngine::exit(int)</a></p>
     */
    public final Signal1<@io.qt.QtPrimitiveType Integer> exit = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#quit">QQmlEngine::quit()</a></p>
     */
    public final Signal0 quit = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#warnings">QQmlEngine::warnings(QList&lt;QQmlError&gt;)</a></p>
     */
    public final Signal1<java.util.List<io.qt.qml.QQmlError>> warnings = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QQmlEngine(io.qt.core.QObject)}
     *  with <code>p = null</code>.</p>
     */
    public QQmlEngine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#QQmlEngine">QQmlEngine::QQmlEngine(QObject*)</a></p>
     */
    public QQmlEngine(io.qt.core.QObject p){
        super((QPrivateConstructor)null);
        initialize_native(this, p);
    }
    
    private native static void initialize_native(QQmlEngine instance, io.qt.core.QObject p);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#addImageProvider">QQmlEngine::addImageProvider(QString,QQmlImageProviderBase*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addImageProvider(java.lang.String id, io.qt.qml.QQmlImageProviderBase arg__2){
        addImageProvider_native_cref_QString_QQmlImageProviderBase_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @io.qt.QtUninvokable
    private native void addImageProvider_native_cref_QString_QQmlImageProviderBase_ptr(long __this__nativeId, java.lang.String id, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#addImportPath">QQmlEngine::addImportPath(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addImportPath(java.lang.String dir){
        addImportPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), dir);
    }
    
    @io.qt.QtUninvokable
    private native void addImportPath_native_cref_QString(long __this__nativeId, java.lang.String dir);
    
    @io.qt.QtUninvokable
    public final boolean addNamedBundle(java.lang.String name, java.lang.String fileName){
        return addNamedBundle_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name, fileName);
    }
    
    @io.qt.QtUninvokable
    private native boolean addNamedBundle_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String name, java.lang.String fileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#addPluginPath">QQmlEngine::addPluginPath(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addPluginPath(java.lang.String dir){
        addPluginPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), dir);
    }
    
    @io.qt.QtUninvokable
    private native void addPluginPath_native_cref_QString(long __this__nativeId, java.lang.String dir);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#baseUrl">QQmlEngine::baseUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl baseUrl(){
        return baseUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl baseUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#clearComponentCache">QQmlEngine::clearComponentCache()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearComponentCache(){
        clearComponentCache_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearComponentCache_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#imageProvider">QQmlEngine::imageProvider(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlImageProviderBase imageProvider(java.lang.String id){
        return imageProvider_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlImageProviderBase imageProvider_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#importPathList">QQmlEngine::importPathList()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList importPathList(){
        return importPathList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList importPathList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#importPlugin">QQmlEngine::importPlugin(QString,QString,QList&lt;QQmlError&gt;*)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean importPlugin(java.lang.String filePath, java.lang.String uri, java.util.Collection<io.qt.qml.QQmlError> errors){
        return importPlugin_native_cref_QString_cref_QString_QList_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, uri, errors);
    }
    
    @io.qt.QtUninvokable
    private native boolean importPlugin_native_cref_QString_cref_QString_QList_ptr(long __this__nativeId, java.lang.String filePath, java.lang.String uri, java.util.Collection<io.qt.qml.QQmlError> errors);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#incubationController">QQmlEngine::incubationController()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlIncubationController incubationController(){
        return incubationController_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlIncubationController incubationController_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#networkAccessManager">QQmlEngine::networkAccessManager()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.network.QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#networkAccessManagerFactory">QQmlEngine::networkAccessManagerFactory()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlNetworkAccessManagerFactory networkAccessManagerFactory(){
        return networkAccessManagerFactory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlNetworkAccessManagerFactory networkAccessManagerFactory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#offlineStorageDatabaseFilePath">QQmlEngine::offlineStorageDatabaseFilePath(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String offlineStorageDatabaseFilePath(java.lang.String databaseName){
        return offlineStorageDatabaseFilePath_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), databaseName);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String offlineStorageDatabaseFilePath_native_cref_QString_constfct(long __this__nativeId, java.lang.String databaseName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#offlineStoragePath-prop">QQmlEngine::offlineStoragePath()const</a></p>
     */
    @io.qt.QtPropertyReader(name="offlineStoragePath")
    @io.qt.QtUninvokable
    public final java.lang.String offlineStoragePath(){
        return offlineStoragePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String offlineStoragePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#outputWarningsToStandardError">QQmlEngine::outputWarningsToStandardError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean outputWarningsToStandardError(){
        return outputWarningsToStandardError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean outputWarningsToStandardError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#pluginPathList">QQmlEngine::pluginPathList()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList pluginPathList(){
        return pluginPathList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList pluginPathList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#removeImageProvider">QQmlEngine::removeImageProvider(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeImageProvider(java.lang.String id){
        removeImageProvider_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native void removeImageProvider_native_cref_QString(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#retranslate">QQmlEngine::retranslate()</a></p>
     */
    public final void retranslate(){
        retranslate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void retranslate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#rootContext">QQmlEngine::rootContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlContext rootContext(){
        return rootContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlContext rootContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setBaseUrl">QQmlEngine::setBaseUrl(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setBaseUrl(io.qt.core.QUrl arg__1){
        setBaseUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setBaseUrl_native_cref_QUrl(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setImportPathList">QQmlEngine::setImportPathList(QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setImportPathList(java.util.Collection<java.lang.String> paths){
        setImportPathList_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), paths);
    }
    
    @io.qt.QtUninvokable
    private native void setImportPathList_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> paths);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setIncubationController">QQmlEngine::setIncubationController(QQmlIncubationController*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setIncubationController(io.qt.qml.QQmlIncubationController arg__1){
        setIncubationController_native_QQmlIncubationController_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        __rcIncubationController = arg__1;
    }
    
    @io.qt.QtUninvokable
    private native void setIncubationController_native_QQmlIncubationController_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setNetworkAccessManagerFactory">QQmlEngine::setNetworkAccessManagerFactory(QQmlNetworkAccessManagerFactory*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNetworkAccessManagerFactory(io.qt.qml.QQmlNetworkAccessManagerFactory arg__1){
        setNetworkAccessManagerFactory_native_QQmlNetworkAccessManagerFactory_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        __rcNetworkAccessManagerFactory = arg__1;
    }
    
    @io.qt.QtUninvokable
    private native void setNetworkAccessManagerFactory_native_QQmlNetworkAccessManagerFactory_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#offlineStoragePath-prop">QQmlEngine::setOfflineStoragePath(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="offlineStoragePath")
    @io.qt.QtUninvokable
    public final void setOfflineStoragePath(java.lang.String dir){
        setOfflineStoragePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), dir);
    }
    
    @io.qt.QtUninvokable
    private native void setOfflineStoragePath_native_cref_QString(long __this__nativeId, java.lang.String dir);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setOutputWarningsToStandardError">QQmlEngine::setOutputWarningsToStandardError(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOutputWarningsToStandardError(boolean arg__1){
        setOutputWarningsToStandardError_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setOutputWarningsToStandardError_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setPluginPathList">QQmlEngine::setPluginPathList(QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPluginPathList(java.util.Collection<java.lang.String> paths){
        setPluginPathList_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), paths);
    }
    
    @io.qt.QtUninvokable
    private native void setPluginPathList_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> paths);
    
    @io.qt.QtUninvokable
    public final void setUrlInterceptor(io.qt.qml.QQmlAbstractUrlInterceptor urlInterceptor){
        setUrlInterceptor_native_QQmlAbstractUrlInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(urlInterceptor));
        __rcUrlInterceptor = urlInterceptor;
    }
    
    @io.qt.QtUninvokable
    private native void setUrlInterceptor_native_QQmlAbstractUrlInterceptor_ptr(long __this__nativeId, long urlInterceptor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#trimComponentCache">QQmlEngine::trimComponentCache()</a></p>
     */
    @io.qt.QtUninvokable
    public final void trimComponentCache(){
        trimComponentCache_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void trimComponentCache_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlAbstractUrlInterceptor urlInterceptor(){
        return urlInterceptor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlAbstractUrlInterceptor urlInterceptor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#contextForObject">QQmlEngine::contextForObject(const QObject*)</a></p>
     */
    public static io.qt.qml.QQmlContext contextForObject(io.qt.core.QObject arg__1){
        return contextForObject_native_const_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native static io.qt.qml.QQmlContext contextForObject_native_const_QObject_ptr(long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#objectOwnership">QQmlEngine::objectOwnership(QObject*)</a></p>
     */
    public static io.qt.qml.QQmlEngine.ObjectOwnership objectOwnership(io.qt.core.QObject arg__1){
        return io.qt.qml.QQmlEngine.ObjectOwnership.resolve(objectOwnership_native_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1)));
    }
    
    private native static int objectOwnership_native_QObject_ptr(long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setContextForObject">QQmlEngine::setContextForObject(QObject*,QQmlContext*)</a></p>
     */
    public static void setContextForObject(io.qt.core.QObject arg__1, io.qt.qml.QQmlContext arg__2){
        setContextForObject_native_QObject_ptr_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    private native static void setContextForObject_native_QObject_ptr_QQmlContext_ptr(long arg__1, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlengine.html#setObjectOwnership">QQmlEngine::setObjectOwnership(QObject*,QQmlEngine::ObjectOwnership)</a></p>
     */
    public static void setObjectOwnership(io.qt.core.QObject arg__1, io.qt.qml.QQmlEngine.ObjectOwnership arg__2){
        setObjectOwnership_native_QObject_ptr_QQmlEngine_ObjectOwnership(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2.value());
        if (arg__1 != null && arg__2 != null){
                            switch(arg__2){
                            case CppOwnership: 
                                if(arg__1.parent()==null){
                                    QtJambi_LibraryUtilities.internal.setJavaOwnership(arg__1);
                                }
                            default:
                                QtJambi_LibraryUtilities.internal.setCppOwnership(arg__1);
                            }
                        }
    }
    
    private native static void setObjectOwnership_native_QObject_ptr_QQmlEngine_ObjectOwnership(long arg__1, int arg__2);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQmlEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQmlEngine instance, QDeclarativeConstructor constructor);
    
}
