package io.qt.qml;


/**
 * <p>Abstracts accessing properties on objects created from QML</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qqmlproperty.html">QQmlProperty</a></p>
 */
public class QQmlProperty extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qqmlproperty.html#PropertyTypeCategory-enum">QQmlProperty::PropertyTypeCategory</a></p>
     */
    public enum PropertyTypeCategory implements io.qt.QtEnumerator {
        InvalidCategory(0),
        List(1),
        Object(2),
        Normal(3);

        private PropertyTypeCategory(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PropertyTypeCategory resolve(int value) {
            switch (value) {
            case 0: return InvalidCategory;
            case 1: return List;
            case 2: return Object;
            case 3: return Normal;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qqmlproperty.html#Type-enum">QQmlProperty::Type</a></p>
     */
    public enum Type implements io.qt.QtEnumerator {
        Invalid(0),
        Property(1),
        SignalProperty(2);

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 0: return Invalid;
            case 1: return Property;
            case 2: return SignalProperty;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty">QQmlProperty::QQmlProperty()</a></p>
     */
    public QQmlProperty(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQmlProperty instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-1">QQmlProperty::QQmlProperty(QObject*)</a></p>
     */
    public QQmlProperty(io.qt.core.QObject arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.core.QObject arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-2">QQmlProperty::QQmlProperty(QObject*,QQmlContext*)</a></p>
     */
    public QQmlProperty(io.qt.core.QObject arg__1, io.qt.qml.QQmlContext arg__2){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.core.QObject arg__1, io.qt.qml.QQmlContext arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-3">QQmlProperty::QQmlProperty(QObject*,QQmlEngine*)</a></p>
     */
    public QQmlProperty(io.qt.core.QObject arg__1, io.qt.qml.QQmlEngine arg__2){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.core.QObject arg__1, io.qt.qml.QQmlEngine arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-4">QQmlProperty::QQmlProperty(QObject*,QString)</a></p>
     */
    public QQmlProperty(io.qt.core.QObject arg__1, java.lang.String arg__2){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.core.QObject arg__1, java.lang.String arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-5">QQmlProperty::QQmlProperty(QObject*,QString,QQmlContext*)</a></p>
     */
    public QQmlProperty(io.qt.core.QObject arg__1, java.lang.String arg__2, io.qt.qml.QQmlContext arg__3){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2, arg__3);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.core.QObject arg__1, java.lang.String arg__2, io.qt.qml.QQmlContext arg__3);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-6">QQmlProperty::QQmlProperty(QObject*,QString,QQmlEngine*)</a></p>
     */
    public QQmlProperty(io.qt.core.QObject arg__1, java.lang.String arg__2, io.qt.qml.QQmlEngine arg__3){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2, arg__3);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.core.QObject arg__1, java.lang.String arg__2, io.qt.qml.QQmlEngine arg__3);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#QQmlProperty-7">QQmlProperty::QQmlProperty(QQmlProperty)</a></p>
     */
    public QQmlProperty(io.qt.qml.QQmlProperty arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QQmlProperty instance, io.qt.qml.QQmlProperty arg__1);
    
    @io.qt.QtUninvokable
    public final boolean connectNotifySignal(io.qt.core.QObject dest, java.lang.String slot){
        if(slot!=null && !slot.startsWith("1") && !slot.startsWith("2")) {
                            io.qt.core.QMetaMethod method = dest.metaObject().method(slot);
                            if(method!=null && method.isValid()) {
                                if(method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal)
                                    slot = "2" + method.cppMethodSignature();
                                else
                                    slot = "1" + method.cppMethodSignature();
                            }
                        }
        return connectNotifySignal_native_QObject_ptr_const_char_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dest), slot);
    }
    
    @io.qt.QtUninvokable
    private native boolean connectNotifySignal_native_QObject_ptr_const_char_ptr_constfct(long __this__nativeId, long dest, java.lang.String slot);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#connectNotifySignal-1">QQmlProperty::connectNotifySignal(QObject*,int)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean connectNotifySignal(io.qt.core.QObject dest, int method){
        return connectNotifySignal_native_QObject_ptr_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dest), method);
    }
    
    @io.qt.QtUninvokable
    private native boolean connectNotifySignal_native_QObject_ptr_int_constfct(long __this__nativeId, long dest, int method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#hasNotifySignal">QQmlProperty::hasNotifySignal()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasNotifySignal(){
        return hasNotifySignal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasNotifySignal_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#index">QQmlProperty::index()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int index(){
        return index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int index_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#isDesignable">QQmlProperty::isDesignable()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDesignable(){
        return isDesignable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDesignable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#isProperty">QQmlProperty::isProperty()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isProperty(){
        return isProperty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isProperty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#isResettable">QQmlProperty::isResettable()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isResettable(){
        return isResettable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isResettable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#isSignalProperty">QQmlProperty::isSignalProperty()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSignalProperty(){
        return isSignalProperty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSignalProperty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#isValid">QQmlProperty::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#isWritable">QQmlProperty::isWritable()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isWritable(){
        return isWritable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isWritable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#method">QQmlProperty::method()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMetaMethod method(){
        return method_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMetaMethod method_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#name">QQmlProperty::name()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#needsNotifySignal">QQmlProperty::needsNotifySignal()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean needsNotifySignal(){
        return needsNotifySignal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean needsNotifySignal_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#object">QQmlProperty::object()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject object(){
        return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject object_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#operator-eq-eq">QQmlProperty::operator==(QQmlProperty)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.qml.QQmlProperty arg__1){
        return operator_equal_native_cref_QQmlProperty_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QQmlProperty_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#property">QQmlProperty::property()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMetaProperty property(){
        return property_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMetaProperty property_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#propertyType">QQmlProperty::propertyType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int propertyType(){
        return propertyType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int propertyType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#propertyTypeCategory">QQmlProperty::propertyTypeCategory()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlProperty.PropertyTypeCategory propertyTypeCategory(){
        return io.qt.qml.QQmlProperty.PropertyTypeCategory.resolve(propertyTypeCategory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int propertyTypeCategory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#propertyTypeName">QQmlProperty::propertyTypeName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String propertyTypeName(){
        return propertyTypeName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String propertyTypeName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#read">QQmlProperty::read()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object read(){
        return read_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object read_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#reset">QQmlProperty::reset()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean reset(){
        return reset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean reset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#type">QQmlProperty::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlProperty.Type type(){
        return io.qt.qml.QQmlProperty.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#write">QQmlProperty::write(QVariant)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean write(java.lang.Object arg__1){
        return write_native_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native boolean write_native_cref_QVariant_constfct(long __this__nativeId, java.lang.Object arg__1);
    
    public static java.lang.Object read(io.qt.core.QObject arg__1, java.lang.String arg__2){
        return read_native_const_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2);
    }
    
    private native static java.lang.Object read_native_const_QObject_ptr_cref_QString(long arg__1, java.lang.String arg__2);
    
    public static java.lang.Object read(io.qt.core.QObject arg__1, java.lang.String arg__2, io.qt.qml.QQmlContext arg__3){
        return read_native_const_QObject_ptr_cref_QString_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__3));
    }
    
    private native static java.lang.Object read_native_const_QObject_ptr_cref_QString_QQmlContext_ptr(long arg__1, java.lang.String arg__2, long arg__3);
    
    public static java.lang.Object read(io.qt.core.QObject arg__1, java.lang.String arg__2, io.qt.qml.QQmlEngine arg__3){
        return read_native_const_QObject_ptr_cref_QString_QQmlEngine_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__3));
    }
    
    private native static java.lang.Object read_native_const_QObject_ptr_cref_QString_QQmlEngine_ptr(long arg__1, java.lang.String arg__2, long arg__3);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#write-1">QQmlProperty::write(QObject*,QString,QVariant)</a></p>
     */
    public static boolean write(io.qt.core.QObject arg__1, java.lang.String arg__2, java.lang.Object arg__3){
        return write_native_QObject_ptr_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, arg__3);
    }
    
    private native static boolean write_native_QObject_ptr_cref_QString_cref_QVariant(long arg__1, java.lang.String arg__2, java.lang.Object arg__3);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#write-2">QQmlProperty::write(QObject*,QString,QVariant,QQmlContext*)</a></p>
     */
    public static boolean write(io.qt.core.QObject arg__1, java.lang.String arg__2, java.lang.Object arg__3, io.qt.qml.QQmlContext arg__4){
        return write_native_QObject_ptr_cref_QString_cref_QVariant_QQmlContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, arg__3, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__4));
    }
    
    private native static boolean write_native_QObject_ptr_cref_QString_cref_QVariant_QQmlContext_ptr(long arg__1, java.lang.String arg__2, java.lang.Object arg__3, long arg__4);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlproperty.html#write-3">QQmlProperty::write(QObject*,QString,QVariant,QQmlEngine*)</a></p>
     */
    public static boolean write(io.qt.core.QObject arg__1, java.lang.String arg__2, java.lang.Object arg__3, io.qt.qml.QQmlEngine arg__4){
        return write_native_QObject_ptr_cref_QString_cref_QVariant_QQmlEngine_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, arg__3, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__4));
    }
    
    private native static boolean write_native_QObject_ptr_cref_QString_cref_QVariant_QQmlEngine_ptr(long arg__1, java.lang.String arg__2, java.lang.Object arg__3, long arg__4);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlProperty(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.qml.QQmlProperty) {
            return operator_equal((io.qt.qml.QQmlProperty) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    @io.qt.QtUninvokable
    public final boolean connectNotifySignal(io.qt.core.QMetaObject.Slot0 slot){
        io.qt.internal.QtJambiInternal.LambdaInfo lamdaInfo = io.qt.internal.QtJambiInternal.lamdaInfo(slot);
        if(lamdaInfo!=null && lamdaInfo.reflectiveMethod!=null && !lamdaInfo.isStatic && lamdaInfo.qobject!=null) {
            if(lamdaInfo.reflectiveMethod.isAnnotationPresent(io.qt.QtUninvokable.class)) {
                throw new io.qt.QUninvokableSlotException(lamdaInfo.reflectiveMethod);
            }
            io.qt.core.QMetaMethod method = io.qt.core.QMetaMethod.fromReflectedMethod(lamdaInfo.reflectiveMethod);
            if(method==null)
                throw new io.qt.QNoSuchSlotException(lamdaInfo.qobject, lamdaInfo.reflectiveMethod.getName());
            return connectNotifySignal(lamdaInfo.qobject, method.methodIndex());
        }
        return false;
    }
    
    @io.qt.QtUninvokable
    public final boolean connectNotifySignal(io.qt.core.QMetaObject.Slot1<?> slot){
        io.qt.internal.QtJambiInternal.LambdaInfo lamdaInfo = io.qt.internal.QtJambiInternal.lamdaInfo(slot);
        if(lamdaInfo!=null && lamdaInfo.reflectiveMethod!=null && !lamdaInfo.isStatic && lamdaInfo.qobject!=null) {
            if(lamdaInfo.reflectiveMethod.isAnnotationPresent(io.qt.QtUninvokable.class)) {
                throw new io.qt.QUninvokableSlotException(lamdaInfo.reflectiveMethod);
            }
            io.qt.core.QMetaMethod method = io.qt.core.QMetaMethod.fromReflectedMethod(lamdaInfo.reflectiveMethod);
            if(method==null)
                throw new io.qt.QNoSuchSlotException(lamdaInfo.qobject, lamdaInfo.reflectiveMethod.getName());
            return connectNotifySignal(lamdaInfo.qobject, method.methodIndex());
        }
        return false;
    }
    
    @Override
    public QQmlProperty clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QQmlProperty clone_native(long __this_nativeId);
}
