package io.qt.qml;

import io.qt.core.*;

/**
 * <p>Provides functions for producing logging messages for QML types</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtqml.html">QtQml</a></p>
 */
public final class QtQml
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtQml() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtQml."); }
    

    /**
     * <p>Java wrapper for Qt function pointer QtQml::ObjectCallback</p>
     */
    @FunctionalInterface
    public interface ObjectCallback extends io.qt.QtObjectInterface, java.util.function.BiFunction<io.qt.qml.QQmlEngine, io.qt.qml.QJSEngine, io.qt.core.QObject> {

        @Override
        public io.qt.core.QObject apply(io.qt.qml.QQmlEngine arg__1, io.qt.qml.QJSEngine arg__2);

        /**
         * <p>Implementor class for interface {@link ObjectCallback}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements ObjectCallback{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(ObjectCallback instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public io.qt.core.QObject apply(io.qt.qml.QQmlEngine arg__1, io.qt.qml.QJSEngine arg__2){
                    return apply_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
                }

                private native io.qt.core.QObject apply_native(long arg__1, long arg__2);
            }

        }
    }


    /**
     * <p>Java wrapper for Qt function pointer QtQml::QQmlAttachedPropertiesFunc</p>
     */
    @FunctionalInterface
    public interface QQmlAttachedPropertiesFunc extends io.qt.QtObjectInterface, java.util.function.UnaryOperator<io.qt.core.QObject> {

        @Override
        public io.qt.core.QObject apply(io.qt.core.QObject arg__1);

        /**
         * <p>Implementor class for interface {@link QQmlAttachedPropertiesFunc}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements QQmlAttachedPropertiesFunc{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(QQmlAttachedPropertiesFunc instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public io.qt.core.QObject apply(io.qt.core.QObject arg__1){
                    return apply_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
                }

                private native io.qt.core.QObject apply_native(long arg__1);
            }

        }
    }


    /**
     * <p>Java wrapper for Qt function pointer QtQml::ValueCallback</p>
     */
    @FunctionalInterface
    public interface ValueCallback extends io.qt.QtObjectInterface, java.util.function.BiFunction<io.qt.qml.QQmlEngine, io.qt.qml.QJSEngine, io.qt.qml.QJSValue> {

        @Override
        public io.qt.qml.QJSValue apply(io.qt.qml.QQmlEngine arg__1, io.qt.qml.QJSEngine arg__2);

        /**
         * <p>Implementor class for interface {@link ValueCallback}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements ValueCallback{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(ValueCallback instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public io.qt.qml.QJSValue apply(io.qt.qml.QQmlEngine arg__1, io.qt.qml.QJSEngine arg__2){
                    return apply_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
                }

                private native io.qt.qml.QJSValue apply_native(long arg__1, long arg__2);
            }

        }
    }

    
    public static io.qt.qml.QtQml.QQmlAttachedPropertiesFunc qmlAttachedPropertiesFunction(io.qt.core.QObject arg__1, io.qt.core.QMetaObject arg__2){
        return qmlAttachedPropertiesFunction_native_QObject_ptr_const_QMetaObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2);
    }
    
    private native static io.qt.qml.QtQml.QQmlAttachedPropertiesFunc qmlAttachedPropertiesFunction_native_QObject_ptr_const_QMetaObject_ptr(long arg__1, io.qt.core.QMetaObject arg__2);
    
    /**
     * <p>Overloaded function for {@link #qmlAttachedPropertiesObject(io.qt.core.QObject, io.qt.qml.QtQml.QQmlAttachedPropertiesFunc, boolean)}
     *  with <code>create = true</code>.</p>
     */
    public static io.qt.core.QObject qmlAttachedPropertiesObject(io.qt.core.QObject arg__1, io.qt.qml.QtQml.QQmlAttachedPropertiesFunc func) {
        return qmlAttachedPropertiesObject(arg__1, func, (boolean)true);
    }
    
    public static io.qt.core.QObject qmlAttachedPropertiesObject(io.qt.core.QObject arg__1, io.qt.qml.QtQml.QQmlAttachedPropertiesFunc func, boolean create){
        return qmlAttachedPropertiesObject_native_QObject_ptr_QtQml_QQmlAttachedPropertiesFunc_bool(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), func, create);
    }
    
    private native static io.qt.core.QObject qmlAttachedPropertiesObject_native_QObject_ptr_QtQml_QQmlAttachedPropertiesFunc_bool(long arg__1, io.qt.qml.QtQml.QQmlAttachedPropertiesFunc func, boolean create);
    
    /**
     * <p>Overloaded function for {@link #qmlAttachedPropertiesObjectById(int, io.qt.core.QObject, boolean)}
     *  with <code>create = true</code>.</p>
     * 
     * @deprecated Use qmlAttachedPropertiesObject(QObject *, QQmlAttachedPropertiesFunc, bool
     */
    @Deprecated
    public static io.qt.core.QObject qmlAttachedPropertiesObjectById(int arg__1, io.qt.core.QObject arg__2) {
        return qmlAttachedPropertiesObjectById(arg__1, arg__2, (boolean)true);
    }
    
    /**
     * @deprecated Use qmlAttachedPropertiesObject(QObject *, QQmlAttachedPropertiesFunc, bool
     */
    @Deprecated
    public static io.qt.core.QObject qmlAttachedPropertiesObjectById(int arg__1, io.qt.core.QObject arg__2, boolean create){
        return qmlAttachedPropertiesObjectById_native_int_const_QObject_ptr_bool(arg__1, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2), create);
    }
    
    @Deprecated
    private native static io.qt.core.QObject qmlAttachedPropertiesObjectById_native_int_const_QObject_ptr_bool(int arg__1, long arg__2, boolean create);
    
    public static io.qt.qml.QQmlContext qmlContext(io.qt.core.QObject arg__1){
        return qmlContext_native_const_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native static io.qt.qml.QQmlContext qmlContext_native_const_QObject_ptr(long arg__1);
    
    public static io.qt.qml.QQmlEngine qmlEngine(io.qt.core.QObject arg__1){
        return qmlEngine_native_const_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native static io.qt.qml.QQmlEngine qmlEngine_native_const_QObject_ptr(long arg__1);
    
    public static void qmlExecuteDeferred(io.qt.core.QObject arg__1){
        qmlExecuteDeferred_native_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native static void qmlExecuteDeferred_native_QObject_ptr(long arg__1);
    
    public static native int qmlRegisterTypeNotAvailable(String uri, int versionMajor, int versionMinor, String qmlName, String message);
    
    public static native int qmlRegisterUncreatableType(Class<? extends QObject> type, String uri, int versionMajor, int versionMinor, String qmlName, String reason);
    
    public static native int qmlRegisterUncreatableType(Class<? extends QObject> type, int metaObjectRevision, String uri, int versionMajor, int versionMinor, String qmlName, String reason);
    
    public static native int qmlRegisterType(Class<? extends QObject> type, String uri, int versionMajor, int versionMinor, String qmlName);
    
    public static native int qmlRegisterType(Class<? extends QObject> type, int metaObjectRevision, String uri, int versionMajor, int versionMinor, String qmlName);
    
    public static native int qmlRegisterRevision(Class<? extends QObject> type, int metaObjectRevision, String uri, int versionMajor, int versionMinor);
    
    public static native int qmlRegisterExtendedType(Class<? extends QObject> type, Class<? extends QObject> extendedType, String uri, int versionMajor, int versionMinor, String qmlName);
    
    public static QObject qmlAttachedPropertiesObject(Class<? extends QObject> clazz, QObject obj){
        return qmlAttachedPropertiesObject(clazz, obj, true);
    }
    
    public static native QObject qmlAttachedPropertiesObject(Class<? extends QObject> clazz, QObject obj, boolean create);
    
    public static native int qmlRegisterAnonymousType(Class<? extends QObject> type, String uri, int versionMajor);
    
    public static native int qmlRegisterType(QUrl url, String uri, int versionMajor, int versionMinor, String qmlName);
    
    public static native boolean qmlProtectModule(String uri, int majVersion);
    
    public static native void qmlClearTypeRegistrations();
    
    public static native int qmlRegisterExtendedUncreatableType(Class<? extends QObject> type, Class<? extends QObject> extendedType, String uri, int versionMajor, int versionMinor, String qmlName, String reason);
    
    public static native int qmlRegisterExtendedUncreatableType(Class<? extends QObject> type, Class<? extends QObject> extendedType, int metaObjectRevision, String uri, int versionMajor, int versionMinor, String qmlName, String reason);
    
    public static native void qmlRegisterModule(String uri, int versionMajor, int versionMinor);
    
    public static native int qmlRegisterSingletonType(String uri, int versionMajor, int versionMinor, String typeName, ValueCallback callback);
    
    public static native int qmlRegisterSingletonType(Class<? extends QObject> type, String uri, int versionMajor, int versionMinor, String typeName, ObjectCallback callback);
    
    public static native int qmlRegisterSingletonType(QUrl url, String uri, int versionMajor, int versionMinor, String qmlName);
    
    public static int qmlRegisterSingletonInstance(QObject instance, String uri, int versionMajor, int versionMinor, String qmlName){
        return qmlRegisterSingletonType(instance.getClass(), uri, versionMajor, versionMinor, qmlName, (e,v)->instance);
    }
    
    public static native int qmlRegisterUncreatableClass(Class<?> type, String uri, int versionMajor, int versionMinor, String qmlName, String reason);
    
    /**
     * @deprecated Use qmlRegisterAnonymousType instead
     */
    @Deprecated
    public static native int qmlRegisterType(Class<? extends QObject> type);
    
    /**
     * @deprecated Use qmlRegisterInterface(Class<? extends io.qt.QtObjectInterface> type, String uri, int versionMajor)
     */
    @Deprecated
    public static int qmlRegisterInterface(Class<? extends io.qt.QtObjectInterface> type, String typeName){
        return type.isInterface() ? qmlRegisterInterface1(type, typeName) : -1;
    }
    
    private static native int qmlRegisterInterface1(Class<? extends io.qt.QtObjectInterface> type, String typeName);
    
    public static int qmlRegisterInterface(Class<? extends io.qt.QtObjectInterface> type, String uri, int versionMajor){
        return type.isInterface() ? qmlRegisterInterface2(type, uri, versionMajor) : -1;
    }
    
    private static native int qmlRegisterInterface2(Class<? extends io.qt.QtObjectInterface> type, String uri, int versionMajor);
    
    /**
     * @deprecated Use qmlRegisterExtendedType(type, uri, versionMajor) instead
     */
    @Deprecated
    public static native int qmlRegisterExtendedType(Class<? extends QObject> type, Class<? extends QObject> extendedType);
    
    public static native int qmlRegisterExtendedType(Class<? extends QObject> type, Class<? extends QObject> extendedType, String uri, int versionMajor);
}
