/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qml.util;

import io.qt.QtObjectInterface;
import io.qt.QtResources;
import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QIODevice;
import io.qt.core.QObject;
import io.qt.core.QStringList;
import io.qt.core.QTextStream;
import io.qt.core.QUrl;
import io.qt.internal.QtJambiInternal;
import io.qt.qml.QtQml;
import io.qt.qml.util.QmlAddedInMinorVersion;
import io.qt.qml.util.QmlAnonymous;
import io.qt.qml.util.QmlElement;
import io.qt.qml.util.QmlImportMajorVersion;
import io.qt.qml.util.QmlInterface;
import io.qt.qml.util.QmlNamedElement;
import io.qt.qml.util.QmlNoMajorVersionException;
import io.qt.qml.util.QmlSingleton;
import io.qt.qml.util.QmlTypeRegistrationException;
import io.qt.qml.util.QmlUncreatable;
import io.qt.qml.util.QtJambi_LibraryInitializer;
import io.qt.qml.util.RetroHelper;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

public final class QmlTypes {
    private static final QmlClassLoader qmlClassLoader;

    private QmlTypes() throws InstantiationError {
        throw new InstantiationError("Cannot instantiate class QmlTypes.");
    }

    public static void registerPackage(Package pkg) {
        QmlTypes.registerPackage(pkg, null);
    }

    public static void registerPackage(Package pkg, int versionMajor) {
        QmlTypes.registerPackage(pkg, null, versionMajor);
    }

    public static void registerPackage(Package pkg, String uri) {
        QmlImportMajorVersion importMajorVersion = pkg.getAnnotation(QmlImportMajorVersion.class);
        if (importMajorVersion == null) {
            throw new QmlNoMajorVersionException("No QmlImportMajorVersion annotation in package " + pkg);
        }
        QmlTypes.registerPackage(pkg, uri, importMajorVersion.value());
    }

    public static void registerPackage(Package pkg, String uri, int versionMajor) {
        if (uri == null) {
            uri = pkg.getName();
        }
        QDir classPath = new QDir("classpath:" + pkg.getName().replace('.', '/'));
        for (Object className : classPath.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
            if (!((String)className).endsWith(".class") || ((String)className).endsWith("-info.class") || ((String)className).contains("$")) continue;
            className = pkg.getName() + "." + ((String)className).substring(0, ((String)className).length() - 6);
            try {
                Class<?> cls;
                try {
                    cls = qmlClassLoader.loadClass((String)className);
                }
                catch (Exception e) {
                    try {
                        cls = ClassLoader.getSystemClassLoader().loadClass((String)className);
                    }
                    catch (Exception e1) {
                        try {
                            cls = Thread.currentThread().getContextClassLoader().loadClass((String)className);
                        }
                        catch (Exception e2) {
                            cls = Class.forName((String)className);
                        }
                    }
                }
                QmlTypes.analyzeType(cls, uri, versionMajor);
            }
            catch (Exception exception) {}
        }
        for (String qmlFile : classPath.entryList(Collections.singletonList("*.qml"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
            QtQml.qmlRegisterType(QUrl.fromClassPath((String)(pkg.getName().replace('.', '/') + "/" + qmlFile)), uri, versionMajor, 0, qmlFile.substring(0, qmlFile.length() - 4));
        }
    }

    public static void registerPackage(String pkg) {
        QmlTypes.registerPackage(pkg, null);
    }

    public static void registerPackage(String pkg, String uri) {
        Package _package = RetroHelper.getDefinedPackage(qmlClassLoader, pkg);
        if (_package == null) {
            _package = RetroHelper.getDefinedPackage(ClassLoader.getSystemClassLoader(), pkg);
        }
        if (_package == null) {
            _package = RetroHelper.getDefinedPackage(Thread.currentThread().getContextClassLoader(), pkg);
        }
        if (_package == null) {
            QDir classPath = new QDir("classpath:" + pkg.replace('.', '/'));
            for (Object className : classPath.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                if (!((String)className).endsWith(".class") || ((String)className).endsWith("-info.class") || ((String)className).contains("$")) continue;
                className = pkg + "." + ((String)className).substring(0, ((String)className).length() - 6);
                try {
                    Class<?> cls;
                    try {
                        cls = qmlClassLoader.loadClass((String)className);
                    }
                    catch (Exception e) {
                        try {
                            cls = ClassLoader.getSystemClassLoader().loadClass((String)className);
                        }
                        catch (Exception e1) {
                            try {
                                cls = Thread.currentThread().getContextClassLoader().loadClass((String)className);
                            }
                            catch (Exception e2) {
                                cls = Class.forName((String)className);
                            }
                        }
                    }
                    _package = cls.getPackage();
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (_package == null) {
            throw new IllegalArgumentException("No such package " + pkg);
        }
        QmlTypes.registerPackage(_package, uri);
    }

    public static void registerPackage(String pkg, int versionMajor) {
        QmlTypes.registerPackage(pkg, null, versionMajor);
    }

    public static void registerPackage(String pkg, String uri, int versionMajor) {
        Package _package = RetroHelper.getDefinedPackage(qmlClassLoader, pkg);
        if (_package == null) {
            _package = RetroHelper.getDefinedPackage(ClassLoader.getSystemClassLoader(), pkg);
        }
        if (_package == null) {
            _package = RetroHelper.getDefinedPackage(Thread.currentThread().getContextClassLoader(), pkg);
        }
        if (_package == null) {
            throw new IllegalArgumentException("No such package " + pkg);
        }
        QmlTypes.registerPackage(_package, uri, versionMajor);
    }

    public static int registerType(Class<? extends QtObjectInterface> type) {
        if (type.getPackage() == null) {
            throw new QmlTypeRegistrationException("Cannot register classes from default package.");
        }
        QmlImportMajorVersion importMajorVersion = type.getPackage().getAnnotation(QmlImportMajorVersion.class);
        if (importMajorVersion == null) {
            throw new QmlNoMajorVersionException("No QmlImportMajorVersion annotation in package " + type.getPackage());
        }
        return QmlTypes.registerType(type, importMajorVersion.value());
    }

    public static int registerType(Class<? extends QtObjectInterface> type, int versionMajor) {
        return QmlTypes.registerType(type, type.getPackage().getName(), versionMajor);
    }

    public static int registerType(Class<? extends QtObjectInterface> type, String uri, int versionMajor) {
        try {
            return QmlTypes.analyzeType(type, uri, versionMajor);
        }
        catch (Exception e) {
            throw new QmlTypeRegistrationException("Cannot register class " + type.getName(), e);
        }
    }

    private static int analyzeType(Class<?> cls, String uri, int versionMajor) throws Exception {
        if (cls.isInterface()) {
            if (QtObjectInterface.class.isAssignableFrom(cls) && cls.isAnnotationPresent(QmlInterface.class)) {
                return QtQml.qmlRegisterInterface(cls, uri, versionMajor);
            }
        } else if (QObject.class.isAssignableFrom(cls)) {
            if (cls.isAnnotationPresent(QmlAnonymous.class)) {
                return QtQml.qmlRegisterAnonymousType(cls, uri, versionMajor);
            }
            if (cls.isAnnotationPresent(QmlElement.class) || cls.isAnnotationPresent(QmlNamedElement.class)) {
                String qmlName = cls.getSimpleName();
                QmlNamedElement namedElement = cls.getAnnotation(QmlNamedElement.class);
                if (namedElement != null) {
                    qmlName = namedElement.name();
                }
                if (cls.isAnnotationPresent(QmlUncreatable.class)) {
                    String reason = null;
                    QmlUncreatable unc = cls.getAnnotation(QmlUncreatable.class);
                    if (unc != null) {
                        reason = unc.reason();
                    }
                    return QtQml.qmlRegisterUncreatableType(cls, uri, versionMajor, QmlTypes.getMinorVersion(cls), qmlName, reason);
                }
                if (cls.isAnnotationPresent(QmlSingleton.class)) {
                    Constructor<?> constructor = cls.getConstructor(new Class[0]);
                    MethodHandle constructorHandle = QtJambiInternal.getConstructorHandle(constructor);
                    return QtQml.qmlRegisterSingletonType(cls, uri, versionMajor, QmlTypes.getMinorVersion(cls), qmlName, (qengine, jsengine) -> {
                        try {
                            return constructorHandle.invoke();
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                return QtQml.qmlRegisterType(cls, uri, versionMajor, QmlTypes.getMinorVersion(cls), qmlName);
            }
        }
        return -1;
    }

    private static int getMinorVersion(Class<?> cls) {
        int versionMinor = 0;
        QmlAddedInMinorVersion addedInMinorVersion = cls.getAnnotation(QmlAddedInMinorVersion.class);
        if (addedInMinorVersion != null) {
            versionMinor = addedInMinorVersion.value();
        }
        return versionMinor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerModule(QUrl baseUrl, String uri) {
        QDir directory;
        QFile qmldir;
        if (baseUrl.isLocalFile() && (qmldir = new QFile((directory = new QDir(baseUrl.toLocalFile())).filePath("qmldir"))).exists() && qmldir.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
            QStringList classPath = new QStringList();
            QStringList libraryPath = new QStringList();
            try {
                QTextStream s = new QTextStream((QIODevice)qmldir);
                while (!s.atEnd()) {
                    String line = s.readLine();
                    if (line.startsWith("classpath ")) {
                        classPath.clear();
                        classPath.append(Arrays.asList(line.substring(10).trim().split(",")));
                        continue;
                    }
                    if (!line.startsWith("librarypath ")) continue;
                    libraryPath.append(Arrays.asList(System.getProperty("java.library.path", "").split(File.pathSeparator)));
                    for (String lp : line.substring(12).trim().split(",")) {
                        if (libraryPath.contains(lp = QDir.toNativeSeparators((String)directory.absoluteFilePath(lp)))) continue;
                        libraryPath.append((Object)lp);
                    }
                }
            }
            finally {
                qmldir.close();
            }
            if (!libraryPath.isEmpty()) {
                System.setProperty("java.library.path", libraryPath.join(File.pathSeparatorChar));
            }
            if (classPath.isEmpty()) {
                classPath.append((Collection)directory.entryList(Arrays.asList("*.jar"), new QDir.Filter[]{QDir.Filter.Files}));
            }
            for (String cp : classPath) {
                File file = new File(QDir.toNativeSeparators((String)directory.absoluteFilePath(cp)));
                try {
                    URL url = file.toURI().toURL();
                    if (Arrays.asList(qmlClassLoader.getURLs()).contains(url)) continue;
                    qmlClassLoader.addURL(url);
                }
                catch (Throwable e) {
                    Logger.getLogger("internal").throwing(QmlTypes.class.getName(), "registerTypes()", e);
                }
            }
            Package _package = RetroHelper.getDefinedPackage(qmlClassLoader, uri);
            if (_package == null) {
                QDir classPathDir = new QDir("classpath:" + uri.replace('.', '/'));
                for (Object className : classPathDir.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                    if (!((String)className).endsWith(".class") || ((String)className).endsWith("-info.class") || ((String)className).contains("$")) continue;
                    className = uri + "." + ((String)className).substring(0, ((String)className).length() - 6);
                    try {
                        Class<?> cls = qmlClassLoader.loadClass((String)className);
                        _package = cls.getPackage();
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            int version = 1;
            if (_package != null) {
                QmlImportMajorVersion importMajorVersion = _package.getAnnotation(QmlImportMajorVersion.class);
                if (importMajorVersion == null) {
                    throw new QmlNoMajorVersionException("No QmlImportMajorVersion annotation in package " + _package.getName());
                }
                version = importMajorVersion.value();
                QmlTypes.registerPackage(_package, uri, version);
            }
            for (String qmlFile : directory.entryList(Collections.singletonList("*.qml"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                QtQml.qmlRegisterType(new QUrl(directory.absoluteFilePath(qmlFile)), uri, version, 0, qmlFile.substring(0, qmlFile.length() - 4));
            }
            QtQml.qmlRegisterModule(uri, version, 0);
        }
    }

    static {
        QtJambi_LibraryInitializer.init();
        qmlClassLoader = new QmlClassLoader();
    }

    private static class QmlClassLoader
    extends URLClassLoader {
        public QmlClassLoader() {
            super(new URL[0]);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
            QtResources.addSearchPath((String)url.toString());
        }
    }
}

