/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.cloudwatch.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;

@ApplicationScoped
public class CloudWatchClientProducer {
    private final CloudWatchClient syncClient;
    private final CloudWatchAsyncClient asyncClient;

    CloudWatchClientProducer(Instance<CloudWatchClientBuilder> syncClientBuilderInstance, Instance<CloudWatchAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (CloudWatchClient)((CloudWatchClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (CloudWatchAsyncClient)((CloudWatchAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public CloudWatchClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The CloudWatchClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public CloudWatchAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The CloudWatchAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

