/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.cognitouserpools.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClientBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClientBuilder;

@ApplicationScoped
public class CognitoUserPoolsClientProducer {
    private final CognitoIdentityProviderClient syncClient;
    private final CognitoIdentityProviderAsyncClient asyncClient;

    CognitoUserPoolsClientProducer(Instance<CognitoIdentityProviderClientBuilder> syncClientBuilderInstance, Instance<CognitoIdentityProviderAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (CognitoIdentityProviderClient)((CognitoIdentityProviderClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (CognitoIdentityProviderAsyncClient)((CognitoIdentityProviderAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @Produces
    @ApplicationScoped
    public CognitoIdentityProviderClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The CognitoIdentityProviderClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @Produces
    @ApplicationScoped
    public CognitoIdentityProviderAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The CognitoIdentityProviderAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

