/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment.spi;

import io.quarkiverse.amazon.common.deployment.spi.BorrowedLocalStackContainer;
import io.quarkiverse.amazon.common.deployment.spi.DevServicesAmazonProvider;
import io.quarkiverse.amazon.common.deployment.spi.DevServicesLocalStackProviderBuildItem;
import io.quarkiverse.amazon.common.deployment.spi.LocalStackDevServicesBaseConfig;
import io.quarkiverse.amazon.common.runtime.AwsCredentialsProviderType;
import io.quarkiverse.amazon.common.runtime.DevServicesBuildTimeConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.testcontainers.containers.localstack.LocalStackContainer;

public abstract class AbstractDevServicesLocalStackProcessor {
    private static final Logger log = Logger.getLogger(AbstractDevServicesLocalStackProcessor.class);
    private static final String ENDPOINT_OVERRIDE = "quarkus.%s.endpoint-override";
    private static final String AWS_REGION = "quarkus.%s.aws.region";
    private static final String AWS_CREDENTIALS_TYPE = "quarkus.%s.aws.credentials.type";
    private static final String AWS_CREDENTIALS_STATIC_PROVIDER_ACCESS_KEY_ID = "quarkus.%s.aws.credentials.static-provider.access-key-id";
    private static final String AWS_CREDENTIALS_STATIC_PROVIDER_SECRET_ACCESS_KEY = "quarkus.%s.aws.credentials.static-provider.secret-access-key";

    protected DevServicesLocalStackProviderBuildItem setup(final LocalStackContainer.EnabledService enabledService, final DevServicesBuildTimeConfig devServicesBuildTimeConfig) {
        final String propertyConfigurationName = this.getPropertyConfigurationName(enabledService);
        if (!devServicesBuildTimeConfig.enabled().orElse(true).booleanValue()) {
            log.debugf("Not starting Dev Services for Amazon Services - %s, as it has been disabled in the config.", (Object)enabledService.getName());
            return null;
        }
        final String endpointOverride = String.format(ENDPOINT_OVERRIDE, propertyConfigurationName);
        if (ConfigUtils.isPropertyPresent((String)endpointOverride)) {
            log.debugf("Not starting Dev Services for Amazon Services - %s, the %s is configured.", (Object)enabledService.getName(), (Object)endpointOverride);
            return null;
        }
        LocalStackDevServicesBaseConfig sharedConfig = this.getConfiguration(devServicesBuildTimeConfig);
        return new DevServicesLocalStackProviderBuildItem(enabledService, sharedConfig, new DevServicesAmazonProvider(){

            @Override
            public Map<String, String> prepareLocalStack(LocalStackContainer localstack) {
                AbstractDevServicesLocalStackProcessor.this.prepareLocalStack(devServicesBuildTimeConfig, localstack);
                HashMap<String, String> config = new HashMap<String, String>();
                config.put(endpointOverride, localstack.getEndpointOverride(enabledService).toString());
                config.put(String.format(AbstractDevServicesLocalStackProcessor.AWS_REGION, propertyConfigurationName), localstack.getRegion());
                config.put(String.format(AbstractDevServicesLocalStackProcessor.AWS_CREDENTIALS_TYPE, propertyConfigurationName), AwsCredentialsProviderType.STATIC.name());
                config.put(String.format(AbstractDevServicesLocalStackProcessor.AWS_CREDENTIALS_STATIC_PROVIDER_ACCESS_KEY_ID, propertyConfigurationName), localstack.getAccessKey());
                config.put(String.format(AbstractDevServicesLocalStackProcessor.AWS_CREDENTIALS_STATIC_PROVIDER_SECRET_ACCESS_KEY, propertyConfigurationName), localstack.getSecretKey());
                AbstractDevServicesLocalStackProcessor.this.overrideDefaultConfig(config);
                return config;
            }

            @Override
            public Map<String, String> reuseLocalStack(BorrowedLocalStackContainer localstack) {
                return Map.of(endpointOverride, localstack.getEndpointOverride(enabledService).toString(), String.format(AbstractDevServicesLocalStackProcessor.AWS_REGION, propertyConfigurationName), localstack.getRegion(), String.format(AbstractDevServicesLocalStackProcessor.AWS_CREDENTIALS_TYPE, propertyConfigurationName), AwsCredentialsProviderType.STATIC.name(), String.format(AbstractDevServicesLocalStackProcessor.AWS_CREDENTIALS_STATIC_PROVIDER_ACCESS_KEY_ID, propertyConfigurationName), localstack.getAccessKey(), String.format(AbstractDevServicesLocalStackProcessor.AWS_CREDENTIALS_STATIC_PROVIDER_SECRET_ACCESS_KEY, propertyConfigurationName), localstack.getSecretKey());
            }
        });
    }

    protected void overrideDefaultConfig(Map<String, String> defaultConfig) {
    }

    protected LocalStackDevServicesBaseConfig getConfiguration(DevServicesBuildTimeConfig devServicesBuildTimeConfig) {
        return new LocalStackDevServicesBaseConfig(devServicesBuildTimeConfig.shared(), devServicesBuildTimeConfig.isolated(), devServicesBuildTimeConfig.serviceName(), devServicesBuildTimeConfig.containerProperties());
    }

    protected void prepareLocalStack(DevServicesBuildTimeConfig devServicesBuildTimeConfig, LocalStackContainer localstack) {
    }

    private String getPropertyConfigurationName(LocalStackContainer.EnabledService enabledService) {
        if (enabledService == LocalStackContainer.Service.STEPFUNCTIONS) {
            return "sfn";
        }
        if (enabledService.getName().equals("events")) {
            return "eventbridge";
        }
        if (enabledService == LocalStackContainer.Service.CLOUDWATCHLOGS) {
            return "cloudwatchlogs";
        }
        return enabledService.getName();
    }
}

