/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.runtime.AsyncHttpClientBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpService;
import software.amazon.awssdk.http.async.SdkAsyncHttpService;

public class AmazonServicesClientsProcessor {
    public static final String AWS_SDK_APPLICATION_ARCHIVE_MARKERS = "software/amazon/awssdk";
    public static final String AWS_SDK_XRAY_ARCHIVE_MARKER = "com/amazonaws/xray";
    private static final DotName EXECUTION_INTERCEPTOR_NAME = DotName.createSimple((String)ExecutionInterceptor.class.getName());

    @BuildStep
    void globalInterceptors(BuildProducer<AmazonClientInterceptorsPathBuildItem> producer) {
        producer.produce((BuildItem)new AmazonClientInterceptorsPathBuildItem("software/amazon/awssdk/global/handlers/execution.interceptors"));
    }

    @BuildStep
    void awsAppArchiveMarkers(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> archiveMarker) {
        archiveMarker.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(AWS_SDK_APPLICATION_ARCHIVE_MARKERS));
        archiveMarker.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(AWS_SDK_XRAY_ARCHIVE_MARKER));
    }

    @BuildStep
    void runtimeInitialize(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("software.amazon.awssdk.utils.cache.CachedSupplier"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndexBuildItem, List<AmazonClientBuildItem> amazonClients, List<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        interceptors.stream().map(AmazonClientInterceptorsPathBuildItem::getInterceptorsPath).forEach(path -> resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path})));
        List<String> knownInterceptorImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(EXECUTION_INTERCEPTOR_NAME).stream().map(c -> c.name().toString()).collect(Collectors.toList());
        for (AmazonClientBuildItem client2 : amazonClients) {
            SdkBuildTimeConfig clientSdkConfig = client2.getBuildTimeSdkConfig();
            if (clientSdkConfig == null) continue;
            clientSdkConfig.interceptors().orElse(Collections.emptyList()).forEach(interceptorClassName -> {
                if (!knownInterceptorImpls.contains(interceptorClassName = interceptorClassName.trim())) {
                    throw new ConfigurationException(String.format("quarkus.%s.interceptors (%s) - must list only existing implementations of software.amazon.awssdk.core.interceptor.ExecutionInterceptor", client2.getAwsClientName(), clientSdkConfig.interceptors().toString()));
                }
            });
        }
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])knownInterceptorImpls.toArray(new String[knownInterceptorImpls.size()])).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.sun.xml.internal.stream.XMLInputFactoryImpl", "com.sun.xml.internal.stream.XMLOutputFactoryImpl"}).methods().build());
        boolean syncTransportNeeded = amazonClients.stream().anyMatch(item -> item.getSyncClassName().isPresent());
        boolean asyncTransportNeeded = amazonClients.stream().anyMatch(item -> item.getAsyncClassName().isPresent());
        Predicate<AmazonClientBuildItem> isSyncApache = client -> client.getBuildTimeSyncConfig().type() == SyncHttpClientBuildTimeConfig.SyncClientType.APACHE;
        Predicate<AmazonClientBuildItem> isSyncCrt = client -> client.getBuildTimeSyncConfig().type() == SyncHttpClientBuildTimeConfig.SyncClientType.AWS_CRT;
        Predicate<AmazonClientBuildItem> isAsyncNetty = client -> client.getBuildTimeAsyncConfig().type() == AsyncHttpClientBuildTimeConfig.AsyncClientType.NETTY;
        boolean isSyncApacheInClasspath = QuarkusClassLoader.isClassPresentAtRuntime((String)"software.amazon.awssdk.http.apache.ApacheSdkHttpService");
        boolean isSyncUrlConnectionInClasspath = QuarkusClassLoader.isClassPresentAtRuntime((String)"software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService");
        boolean isAsyncNettyInClasspath = QuarkusClassLoader.isClassPresentAtRuntime((String)"software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService");
        boolean isAwsCrtInClasspath = QuarkusClassLoader.isClassPresentAtRuntime((String)"software.amazon.awssdk.http.crt.AwsCrtSdkHttpService");
        if (syncTransportNeeded) {
            if (amazonClients.stream().filter(isSyncApache).findAny().isPresent()) {
                if (!isSyncApacheInClasspath) throw this.missingDependencyException("apache-client");
                AmazonServicesClientsProcessor.registerSyncApacheClient(proxyDefinition, serviceProvider);
            } else if (amazonClients.stream().filter(isSyncCrt).findAny().isPresent()) {
                if (!isAwsCrtInClasspath) throw this.missingDependencyException("aws-crt-client");
                AmazonServicesClientsProcessor.registerSyncAwsCrtClient(serviceProvider);
            } else {
                if (!isSyncUrlConnectionInClasspath) throw this.missingDependencyException("url-connection-client");
                AmazonServicesClientsProcessor.registerSyncUrlConnectionClient(serviceProvider);
            }
        } else if (isSyncApacheInClasspath) {
            AmazonServicesClientsProcessor.registerSyncApacheClient(proxyDefinition, serviceProvider);
        } else if (isSyncUrlConnectionInClasspath) {
            AmazonServicesClientsProcessor.registerSyncUrlConnectionClient(serviceProvider);
        }
        if (asyncTransportNeeded) {
            if (amazonClients.stream().filter(isAsyncNetty).findAny().isPresent()) {
                if (!isAsyncNettyInClasspath) throw this.missingDependencyException("netty-nio-client");
                AmazonServicesClientsProcessor.registerAsyncNettyClient(serviceProvider);
                return;
            } else {
                if (!isAwsCrtInClasspath) throw this.missingDependencyException("aws-crt-client");
                AmazonServicesClientsProcessor.registerAsyncAwsCrtClient(serviceProvider);
            }
            return;
        } else if (isAsyncNettyInClasspath) {
            AmazonServicesClientsProcessor.registerAsyncNettyClient(serviceProvider);
            return;
        } else {
            if (!isAwsCrtInClasspath) return;
            AmazonServicesClientsProcessor.registerAsyncAwsCrtClient(serviceProvider);
        }
    }

    private static void registerSyncApacheClient(BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.http.conn.HttpClientConnectionManager", "org.apache.http.pool.ConnPoolControl", "software.amazon.awssdk.http.apache.internal.conn.Wrapped"}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkHttpService.class.getName(), new String[]{"software.amazon.awssdk.http.apache.ApacheSdkHttpService"}));
    }

    private static void registerSyncAwsCrtClient(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkHttpService.class.getName(), new String[]{"software.amazon.awssdk.http.crt.AwsCrtSdkHttpService"}));
    }

    private static void registerSyncUrlConnectionClient(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkHttpService.class.getName(), new String[]{"software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService"}));
    }

    private static void registerAsyncNettyClient(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkAsyncHttpService.class.getName(), new String[]{"software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService"}));
    }

    private static void registerAsyncAwsCrtClient(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkAsyncHttpService.class.getName(), new String[]{"software.amazon.awssdk.http.crt.AwsCrtSdkHttpService"}));
    }

    private DeploymentException missingDependencyException(String dependencyName) {
        return new DeploymentException("Missing 'software.amazon.awssdk:" + dependencyName + "' dependency on the classpath");
    }
}

