/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import io.netty.channel.EventLoopGroup;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonTelemetryBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientBuildTimeConfig;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public abstract class AbstractAmazonServiceProcessor {
    protected abstract String amazonServiceClientName();

    protected abstract String configName();

    protected abstract DotName syncClientName();

    protected abstract DotName asyncClientName();

    protected abstract String builtinInterceptorsPath();

    protected void discoverClient(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        Optional<DotName> syncClassName = Optional.empty();
        Optional<DotName> asyncClassName = Optional.empty();
        for (InjectionPointInfo injectionPoint : beanRegistrationPhase.getInjectionPoints()) {
            Type injectedType = this.getInjectedType(injectionPoint);
            if (this.syncClientName().equals((Object)injectedType.name())) {
                syncClassName = Optional.of(this.syncClientName());
            }
            if (!this.asyncClientName().equals((Object)injectedType.name())) continue;
            asyncClassName = Optional.of(this.asyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            requireClientProducer.produce((BuildItem)new RequireAmazonClientBuildItem(syncClassName, asyncClassName));
        }
    }

    protected void discoverTelemetry(BuildProducer<RequireAmazonTelemetryBuildItem> telemetryProducer, SdkBuildTimeConfig buildTimeSdkConfig) {
        if (buildTimeSdkConfig.telemetry().orElse(false).booleanValue()) {
            telemetryProducer.produce((BuildItem)new RequireAmazonTelemetryBuildItem(this.configName()));
        }
    }

    protected void setupClient(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<AmazonClientBuildItem> clientProducer, SdkBuildTimeConfig buildTimeSdkConfig, SyncHttpClientBuildTimeConfig buildTimeSyncConfig, AsyncHttpClientBuildTimeConfig buildTimeAsyncConfig) {
        Optional<DotName> syncClassName = Optional.empty();
        Optional<DotName> asyncClassName = Optional.empty();
        for (RequireAmazonClientBuildItem clientRequirement : clientRequirements) {
            if (clientRequirement.getSyncClassName().filter(arg_0 -> ((DotName)this.syncClientName()).equals(arg_0)).isPresent()) {
                syncClassName = Optional.of(this.syncClientName());
            }
            if (!clientRequirement.getAsyncClassName().filter(arg_0 -> ((DotName)this.asyncClientName()).equals(arg_0)).isPresent()) continue;
            asyncClassName = Optional.of(this.asyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            clientProducer.produce((BuildItem)new AmazonClientBuildItem(syncClassName, asyncClassName, this.configName(), buildTimeSdkConfig, buildTimeSyncConfig, buildTimeAsyncConfig));
        }
    }

    protected void setupExtension(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        feature.produce((BuildItem)new FeatureBuildItem(this.amazonServiceClientName()));
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(this.amazonServiceClientName()));
        interceptors.produce((BuildItem)new AmazonClientInterceptorsPathBuildItem(this.builtinInterceptorsPath()));
    }

    protected void createApacheSyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientApacheTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.APACHE) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createAwsCrtSyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.AWS_CRT) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createUrlConnectionSyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientUrlConnectionTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.URL) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createNettyAsyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientNettyTransportRecorder recorder, AsyncHttpClientBuildTimeConfig buildAsyncConfig, RuntimeValue<AsyncHttpClientConfig> asyncConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> clientAsyncTransports, Supplier<EventLoopGroup> eventLoopSupplier) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getAsyncClassName().isPresent()) {
                return;
            }
            if (buildAsyncConfig.type() != AsyncHttpClientBuildTimeConfig.AsyncClientType.NETTY) {
                return;
            }
            clientAsyncTransports.produce((BuildItem)new AmazonClientAsyncTransportBuildItem(client.getAwsClientName(), client.getAsyncClassName().get(), (RuntimeValue<SdkAsyncHttpClient.Builder>)recorder.configureNettyAsync(recorder.configureAsync(this.configName(), asyncConfig), eventLoopSupplier, asyncConfig)));
        });
    }

    protected void createAwsCrtAsyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder recorder, AsyncHttpClientBuildTimeConfig buildAsyncConfig, RuntimeValue<AsyncHttpClientConfig> asyncConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> clientAsyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getAsyncClassName().isPresent()) {
                return;
            }
            if (buildAsyncConfig.type() != AsyncHttpClientBuildTimeConfig.AsyncClientType.AWS_CRT) {
                return;
            }
            clientAsyncTransports.produce((BuildItem)new AmazonClientAsyncTransportBuildItem(client.getAwsClientName(), client.getAsyncClassName().get(), (RuntimeValue<SdkAsyncHttpClient.Builder>)recorder.configureAsync(this.configName(), asyncConfig)));
        });
    }

    protected void createClientBuilders(AmazonClientRecorder recorder, AmazonClientCommonRecorder commonRecorder, AmazonClientOpenTelemetryRecorder otelRecorder, HasSdkBuildTimeConfig sdkBuildConfig, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, Class<?> syncClientBuilderClass, Class<?> asyncClientBuilderClass, Class<?> presignerBuilderClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        RuntimeValue presignerBuilder = null;
        if (presignerBuilderClass != null) {
            presignerBuilder = recorder.createPresignerBuilder();
        }
        this.createClientBuilders(commonRecorder, otelRecorder, (RuntimeValue<AwsConfig>)recorder.getAwsConfig(), (RuntimeValue<SdkConfig>)recorder.getSdkConfig(), sdkBuildConfig, amazonRequireTelemtryClients, syncTransports, asyncTransports, syncClientBuilderClass, syncTransport -> recorder.createSyncBuilder(syncTransport), asyncClientBuilderClass, asyncTransport -> recorder.createAsyncBuilder(asyncTransport, launchModeBuildItem.getLaunchMode(), (Executor)executorBuildItem.getExecutorProxy()), presignerBuilderClass, (RuntimeValue<SdkPresigner.Builder>)presignerBuilder, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem);
    }

    private void createClientBuilders(AmazonClientCommonRecorder recorder, AmazonClientOpenTelemetryRecorder otelRecorder, RuntimeValue<AwsConfig> awsConfigRuntime, RuntimeValue<SdkConfig> sdkConfigRuntime, HasSdkBuildTimeConfig sdkBuildConfig, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> amazonClientSyncTransports, List<AmazonClientAsyncTransportBuildItem> amazonClientAsyncTransports, Class<?> syncClientBuilderClass, Function<RuntimeValue<SdkHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> syncClientBuilderFunction, Class<?> asyncClientBuilderClass, Function<RuntimeValue<SdkAsyncHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> asyncClientBuilderFunction, Class<?> presignerBuilderClass, RuntimeValue<SdkPresigner.Builder> presignerBuilder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        String configName = this.configName();
        Optional<RuntimeValue> syncSdkHttpClientBuilder = amazonClientSyncTransports.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        Optional<RuntimeValue> asyncSdkAsyncHttpClientBuilder = amazonClientAsyncTransports.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        boolean addOpenTelemetry = amazonRequireTelemtryClients.stream().anyMatch(c -> configName.equals(c.getConfigName()));
        if (!syncSdkHttpClientBuilder.isPresent() && !asyncSdkAsyncHttpClientBuilder.isPresent() && presignerBuilder == null) {
            return;
        }
        RuntimeValue syncClientBuilder = syncSdkHttpClientBuilder.isPresent() ? syncClientBuilderFunction.apply((RuntimeValue<SdkHttpClient.Builder>)syncSdkHttpClientBuilder.get()) : null;
        RuntimeValue asyncClientBuilder = asyncSdkAsyncHttpClientBuilder.isPresent() ? asyncClientBuilderFunction.apply((RuntimeValue<SdkAsyncHttpClient.Builder>)asyncSdkAsyncHttpClientBuilder.get()) : null;
        ScheduledExecutorService sharedExecutorService = executorBuildItem.getExecutorProxy();
        if (syncClientBuilder != null) {
            syncClientBuilder = recorder.configure(syncClientBuilder, awsConfigRuntime, sdkConfigRuntime, sdkBuildConfig, sharedExecutorService, this.configName());
            if (addOpenTelemetry) {
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(syncClientBuilderClass).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configureSync(syncClientBuilder)).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
            } else {
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(syncClientBuilderClass).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(syncClientBuilder).done());
            }
            clientSync.produce((BuildItem)new AmazonClientSyncResultBuildItem(configName));
        }
        if (asyncClientBuilder != null) {
            asyncClientBuilder = recorder.configure(asyncClientBuilder, awsConfigRuntime, sdkConfigRuntime, sdkBuildConfig, sharedExecutorService, this.configName());
            if (addOpenTelemetry) {
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(asyncClientBuilderClass).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configureAsync(asyncClientBuilder)).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
            } else {
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(asyncClientBuilderClass).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(asyncClientBuilder).done());
            }
            clientAsync.produce((BuildItem)new AmazonClientAsyncResultBuildItem(configName));
        }
        if (presignerBuilder != null) {
            presignerBuilder = recorder.configurePresigner(presignerBuilder, awsConfigRuntime, sdkConfigRuntime, this.configName());
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(presignerBuilderClass).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(presignerBuilder).done());
        }
    }

    private Type getInjectedType(InjectionPointInfo injectionPoint) {
        Type requiredType;
        Type injectedType = requiredType = injectionPoint.getRequiredType();
        if (DotNames.INSTANCE.equals((Object)requiredType.name()) && requiredType instanceof ParameterizedType) {
            injectedType = (Type)requiredType.asParameterizedType().arguments().get(0);
        }
        return injectedType;
    }
}

