/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import io.netty.channel.EventLoopGroup;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.ClientDeploymentUtil;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientTransportBuilderBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonTelemetryBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientBuildTimeConfig;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkus.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkAutoCloseableDestroyer;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public abstract class AbstractAmazonServiceProcessor {
    protected abstract String amazonServiceClientName();

    protected abstract String configName();

    protected abstract DotName syncClientName();

    protected abstract DotName asyncClientName();

    protected DotName presignerClientName() {
        return null;
    }

    protected abstract String builtinInterceptorsPath();

    protected void discoverClientInjectionPointsInternal(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientInjectionBuildItem> requireClientInjectionProducer) {
        for (InjectionPointInfo injectionPoint : beanRegistrationPhase.getInjectionPoints()) {
            Type injectedType = this.getInjectedType(injectionPoint);
            if (this.syncClientName().equals((Object)injectedType.name())) {
                requireClientInjectionProducer.produce((BuildItem)new RequireAmazonClientInjectionBuildItem(this.syncClientName(), ClientDeploymentUtil.getNamedClientInjection(injectionPoint)));
            }
            if (this.asyncClientName().equals((Object)injectedType.name())) {
                requireClientInjectionProducer.produce((BuildItem)new RequireAmazonClientInjectionBuildItem(this.asyncClientName(), ClientDeploymentUtil.getNamedClientInjection(injectionPoint)));
            }
            if (this.presignerClientName() == null || !this.presignerClientName().equals((Object)injectedType.name())) continue;
            requireClientInjectionProducer.produce((BuildItem)new RequireAmazonClientInjectionBuildItem(this.presignerClientName(), ClientDeploymentUtil.getNamedClientInjection(injectionPoint)));
        }
    }

    @BuildStep
    protected void discoverClient(List<RequireAmazonClientInjectionBuildItem> amazonClientInjectionPoints, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        Optional<DotName> syncClassName = Optional.empty();
        Optional<DotName> asyncClassName = Optional.empty();
        for (RequireAmazonClientInjectionBuildItem requireInjectionPoint : amazonClientInjectionPoints) {
            if (this.syncClientName().equals((Object)requireInjectionPoint.getClassName())) {
                syncClassName = Optional.of(this.syncClientName());
            }
            if (!this.asyncClientName().equals((Object)requireInjectionPoint.getClassName())) continue;
            asyncClassName = Optional.of(this.asyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            requireClientProducer.produce((BuildItem)new RequireAmazonClientBuildItem(syncClassName, asyncClassName));
        }
    }

    protected void discoverTelemetry(BuildProducer<RequireAmazonTelemetryBuildItem> telemetryProducer, SdkBuildTimeConfig buildTimeSdkConfig) {
        if (buildTimeSdkConfig.telemetry().orElse(false).booleanValue()) {
            telemetryProducer.produce((BuildItem)new RequireAmazonTelemetryBuildItem(this.configName()));
        }
    }

    protected void setupClient(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<RequireAmazonClientTransportBuilderBuildItem> clientProducer, SdkBuildTimeConfig buildTimeSdkConfig, SyncHttpClientBuildTimeConfig buildTimeSyncConfig, AsyncHttpClientBuildTimeConfig buildTimeAsyncConfig) {
        Optional<DotName> syncClassName = Optional.empty();
        Optional<DotName> asyncClassName = Optional.empty();
        for (RequireAmazonClientBuildItem clientRequirement : clientRequirements) {
            if (clientRequirement.getSyncClassName().filter(arg_0 -> ((DotName)this.syncClientName()).equals(arg_0)).isPresent()) {
                syncClassName = Optional.of(this.syncClientName());
            }
            if (!clientRequirement.getAsyncClassName().filter(arg_0 -> ((DotName)this.asyncClientName()).equals(arg_0)).isPresent()) continue;
            asyncClassName = Optional.of(this.asyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            clientProducer.produce((BuildItem)new RequireAmazonClientTransportBuilderBuildItem(syncClassName, asyncClassName, this.configName(), buildTimeSdkConfig, buildTimeSyncConfig, buildTimeAsyncConfig));
        }
    }

    protected void setupExtension(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        feature.produce((BuildItem)new FeatureBuildItem(this.amazonServiceClientName()));
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(this.amazonServiceClientName()));
        interceptors.produce((BuildItem)new AmazonClientInterceptorsPathBuildItem(this.builtinInterceptorsPath()));
    }

    protected void createApacheSyncTransportBuilder(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientApacheTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.APACHE) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createAwsCrtSyncTransportBuilder(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.AWS_CRT) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createUrlConnectionSyncTransportBuilder(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientUrlConnectionTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.URL) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createNettyAsyncTransportBuilder(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientNettyTransportRecorder recorder, AsyncHttpClientBuildTimeConfig buildAsyncConfig, RuntimeValue<AsyncHttpClientConfig> asyncConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> clientAsyncTransports, Supplier<EventLoopGroup> eventLoopSupplier) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getAsyncClassName().isPresent()) {
                return;
            }
            if (buildAsyncConfig.type() != AsyncHttpClientBuildTimeConfig.AsyncClientType.NETTY) {
                return;
            }
            clientAsyncTransports.produce((BuildItem)new AmazonClientAsyncTransportBuildItem(client.getAwsClientName(), client.getAsyncClassName().get(), (RuntimeValue<SdkAsyncHttpClient.Builder>)recorder.configureNettyAsync(recorder.configureAsync(this.configName(), asyncConfig), eventLoopSupplier, asyncConfig)));
        });
    }

    protected void createAwsCrtAsyncTransportBuilder(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder recorder, AsyncHttpClientBuildTimeConfig buildAsyncConfig, RuntimeValue<AsyncHttpClientConfig> asyncConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> clientAsyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getAsyncClassName().isPresent()) {
                return;
            }
            if (buildAsyncConfig.type() != AsyncHttpClientBuildTimeConfig.AsyncClientType.AWS_CRT) {
                return;
            }
            clientAsyncTransports.produce((BuildItem)new AmazonClientAsyncTransportBuildItem(client.getAwsClientName(), client.getAsyncClassName().get(), (RuntimeValue<SdkAsyncHttpClient.Builder>)recorder.configureAsync(this.configName(), asyncConfig)));
        });
    }

    protected void createClientBuilders(AmazonClientRecorder recorder, AmazonClientCommonRecorder commonRecorder, AmazonClientOpenTelemetryRecorder otelRecorder, HasSdkBuildTimeConfig sdkBuildConfig, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, Class<?> syncClientBuilderClass, Class<?> asyncClientBuilderClass, Class<?> presignerBuilderClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        Supplier<RuntimeValue<SdkPresigner.Builder>> presignerBuilderSupplier = null;
        if (presignerBuilderClass != null) {
            presignerBuilderSupplier = () -> recorder.createPresignerBuilder();
        }
        this.createClientBuilders(commonRecorder, otelRecorder, (RuntimeValue<HasAmazonClientRuntimeConfig>)recorder.getAmazonClientsConfig(), sdkBuildConfig, amazonClientInjections, amazonRequireTelemtryClients, syncTransports, asyncTransports, syncClientBuilderClass, syncTransport -> recorder.createSyncBuilder(syncTransport), asyncClientBuilderClass, asyncTransport -> recorder.createAsyncBuilder(asyncTransport, launchModeBuildItem.getLaunchMode(), (Executor)executorBuildItem.getExecutorProxy()), presignerBuilderClass, presignerBuilderSupplier, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem);
    }

    private void createClientBuilders(AmazonClientCommonRecorder recorder, AmazonClientOpenTelemetryRecorder otelRecorder, RuntimeValue<HasAmazonClientRuntimeConfig> amazonClientConfigRuntime, HasSdkBuildTimeConfig sdkBuildConfig, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> amazonClientSyncTransports, List<AmazonClientAsyncTransportBuildItem> amazonClientAsyncTransports, Class<?> syncClientBuilderClass, Function<RuntimeValue<SdkHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> syncClientBuilderFunction, Class<?> asyncClientBuilderClass, Function<RuntimeValue<SdkAsyncHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> asyncClientBuilderFunction, Class<?> presignerBuilderClass, Supplier<RuntimeValue<SdkPresigner.Builder>> presignerBuilderSupplier, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        String configName = this.configName();
        Optional<RuntimeValue> syncSdkHttpClientBuilder = amazonClientSyncTransports.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        Optional<RuntimeValue> asyncSdkAsyncHttpClientBuilder = amazonClientAsyncTransports.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        boolean addOpenTelemetry = amazonRequireTelemtryClients.stream().anyMatch(c -> configName.equals(c.getConfigName()));
        if (!syncSdkHttpClientBuilder.isPresent() && !asyncSdkAsyncHttpClientBuilder.isPresent() && presignerBuilderSupplier == null) {
            return;
        }
        Collection syncClientNames = amazonClientInjections.stream().filter(c -> this.syncClientName().equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        Collection asyncClientNames = amazonClientInjections.stream().filter(c -> this.asyncClientName().equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        Collection presignerClientNames = amazonClientInjections.stream().filter(c -> this.presignerClientName() != null && this.presignerClientName().equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        ScheduledExecutorService sharedExecutorService = executorBuildItem.getExecutorProxy();
        if (syncSdkHttpClientBuilder.isPresent() && !syncClientNames.isEmpty()) {
            for (String clientName : syncClientNames) {
                RuntimeValue syncClientBuilder = syncClientBuilderFunction.apply((RuntimeValue<SdkHttpClient.Builder>)syncSdkHttpClientBuilder.get());
                syncClientBuilder = recorder.configure(syncClientBuilder, amazonClientConfigRuntime, sdkBuildConfig, sharedExecutorService, this.configName(), clientName);
                if (addOpenTelemetry) {
                    syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure(syncClientBuilderClass), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configureSync(syncClientBuilder)).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
                } else {
                    syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure(syncClientBuilderClass), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(syncClientBuilder).done());
                }
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedClient(SyntheticBeanBuildItem.configure((DotName)this.syncClientName()), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(recorder.build(syncClientBuilderClass, clientName)).addInjectionPoint((Type)ClassType.create(syncClientBuilderClass), ClientDeploymentUtil.injectionPointAnnotationsBuilder(clientName))).destroyer(SdkAutoCloseableDestroyer.class)).done());
                clientSync.produce((BuildItem)new AmazonClientSyncResultBuildItem(configName, clientName));
            }
        }
        if (asyncSdkAsyncHttpClientBuilder.isPresent() && !asyncClientNames.isEmpty()) {
            for (String clientName : asyncClientNames) {
                RuntimeValue asyncClientBuilder = asyncClientBuilderFunction.apply((RuntimeValue<SdkAsyncHttpClient.Builder>)asyncSdkAsyncHttpClientBuilder.get());
                asyncClientBuilder = recorder.configure(asyncClientBuilder, amazonClientConfigRuntime, sdkBuildConfig, sharedExecutorService, this.configName(), clientName);
                if (addOpenTelemetry) {
                    syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure(asyncClientBuilderClass), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configureAsync(asyncClientBuilder)).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
                } else {
                    syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure(asyncClientBuilderClass), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(asyncClientBuilder).done());
                }
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedClient(SyntheticBeanBuildItem.configure((DotName)this.asyncClientName()), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(recorder.build(asyncClientBuilderClass, clientName)).addInjectionPoint((Type)ClassType.create(asyncClientBuilderClass), ClientDeploymentUtil.injectionPointAnnotationsBuilder(clientName))).destroyer(SdkAutoCloseableDestroyer.class)).done());
                clientAsync.produce((BuildItem)new AmazonClientAsyncResultBuildItem(configName, clientName));
            }
        }
        if (presignerBuilderSupplier != null && !presignerClientNames.isEmpty()) {
            for (String clientName : presignerClientNames) {
                RuntimeValue presignerBuilder = presignerBuilderSupplier.get();
                presignerBuilder = recorder.configurePresigner(presignerBuilder, amazonClientConfigRuntime, this.configName(), clientName);
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure(presignerBuilderClass), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(presignerBuilder).done());
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedClient(SyntheticBeanBuildItem.configure((DotName)this.presignerClientName()), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(recorder.buildPresigner(presignerBuilderClass, clientName)).addInjectionPoint((Type)ClassType.create(presignerBuilderClass), ClientDeploymentUtil.injectionPointAnnotationsBuilder(clientName))).destroyer(SdkAutoCloseableDestroyer.class)).done());
            }
        }
    }

    private Type getInjectedType(InjectionPointInfo injectionPoint) {
        Type requiredType;
        Type injectedType = requiredType = injectionPoint.getRequiredType();
        if (DotNames.INSTANCE.equals((Object)requiredType.name()) && requiredType instanceof ParameterizedType) {
            injectedType = (Type)requiredType.asParameterizedType().arguments().get(0);
        }
        return injectedType;
    }
}

