/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import io.quarkus.amazon.common.AmazonClient;
import io.quarkus.amazon.common.AmazonClientBuilder;
import io.quarkus.amazon.common.runtime.ClientUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public final class ClientDeploymentUtil {
    private static final DotName AWS_CLIENT_NAME = DotName.createSimple((String)AmazonClient.class.getName());
    private static final DotName AWS_CLIENT_BUILDER_NAME = DotName.createSimple((String)AmazonClientBuilder.class.getName());
    private static final AnnotationInstance[] EMPTY_ANNOTATIONS = new AnnotationInstance[0];

    private ClientDeploymentUtil() {
    }

    public static String getNamedClientInjection(InjectionPointInfo injectionPoint) {
        AnnotationInstance named = injectionPoint.getRequiredQualifier(AWS_CLIENT_NAME);
        if (named != null) {
            return named.value("value").asString();
        }
        return "<default>";
    }

    public static SyntheticBeanBuildItem.ExtendedBeanConfigurator namedClient(SyntheticBeanBuildItem.ExtendedBeanConfigurator beanConfigurator, String clientName) {
        return ClientDeploymentUtil.named(beanConfigurator, AWS_CLIENT_NAME, clientName);
    }

    public static SyntheticBeanBuildItem.ExtendedBeanConfigurator namedBuilder(SyntheticBeanBuildItem.ExtendedBeanConfigurator beanConfigurator, String clientName) {
        return ClientDeploymentUtil.named(beanConfigurator, AWS_CLIENT_BUILDER_NAME, clientName);
    }

    public static AnnotationInstance[] injectionPointAnnotationsClient(String clientName) {
        return ClientDeploymentUtil.injectionPointAnnotations(AWS_CLIENT_NAME, clientName);
    }

    public static AnnotationInstance[] injectionPointAnnotationsBuilder(String clientName) {
        return ClientDeploymentUtil.injectionPointAnnotations(AWS_CLIENT_BUILDER_NAME, clientName);
    }

    private static SyntheticBeanBuildItem.ExtendedBeanConfigurator named(SyntheticBeanBuildItem.ExtendedBeanConfigurator beanConfigurator, DotName annotationName, String clientName) {
        if (ClientUtil.isDefaultClient((String)clientName)) {
            beanConfigurator.addQualifier(DotNames.DEFAULT);
        } else {
            beanConfigurator.addQualifier().annotation(annotationName).addValue("value", (Object)clientName).done();
        }
        return beanConfigurator;
    }

    private static AnnotationInstance[] injectionPointAnnotations(DotName annotationName, String clientName) {
        if (ClientUtil.isDefaultClient((String)clientName)) {
            return EMPTY_ANNOTATIONS;
        }
        return new AnnotationInstance[]{AnnotationInstance.builder((DotName)annotationName).add("value", clientName).build()};
    }
}

