/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import io.quarkus.amazon.common.deployment.spi.BorrowedLocalStackContainer;
import io.quarkus.amazon.common.deployment.spi.DevServicesLocalStackProviderBuildItem;
import io.quarkus.amazon.common.deployment.spi.LocalStackDevServicesBaseConfig;
import io.quarkus.amazon.common.runtime.LocalStackDevServicesBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DevServicesLocalStackProcessor {
    private static final Logger log = Logger.getLogger(DevServicesLocalStackProcessor.class);
    static volatile List<RunningDevServiceWithConfig> currentDevServices;
    static volatile LocalStackDevServicesConfig currentLocalStackDevServicesConfig;
    static volatile boolean first;
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-localstack";
    private static final int PORT;
    private static final ContainerLocator containerLocator;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void startLocalStackDevService(LaunchModeBuildItem launchMode, LocalStackDevServicesBuildTimeConfig localStackDevServicesBuildTimeConfig, List<DevServicesLocalStackProviderBuildItem> requestedServices, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, GlobalDevServicesConfig devServicesConfig, BuildProducer<DevServicesResultBuildItem> devServicesResultBuildItemBuildProducer, LoggingSetupBuildItem loggingSetupBuildItem) {
        Map<String, List<DevServicesLocalStackProviderBuildItem>> requestedServicesBySharedServiceName;
        if (launchMode.isTest()) {
            requestedServicesBySharedServiceName = requestedServices.stream().collect(Collectors.toMap(r -> r.getConfig().getServiceName(), Collections::singletonList, (requestedService1, requestedService2) -> {
                ArrayList ret = new ArrayList();
                ret.addAll(requestedService1);
                ret.addAll(requestedService2);
                return ret;
            }));
        } else {
            requestedServicesBySharedServiceName = requestedServices.stream().filter(rs -> rs.getConfig().isShared()).collect(Collectors.toMap(r -> String.format("%s-%s", r.getConfig().getServiceName(), r.getService().getName()), Collections::singletonList, (requestedService1, requestedService2) -> {
                ArrayList ret = new ArrayList();
                ret.addAll(requestedService1);
                ret.addAll(requestedService2);
                return ret;
            }));
            requestedServicesBySharedServiceName.putAll(requestedServices.stream().filter(rs -> !rs.getConfig().isShared()).collect(Collectors.toMap(r -> r.getConfig().getServiceName(), Collections::singletonList, (requestedService1, requestedService2) -> {
                ArrayList ret = new ArrayList();
                ret.addAll(requestedService1);
                ret.addAll(requestedService2);
                return ret;
            })));
        }
        if (!requestedServicesBySharedServiceName.isEmpty() && !dockerStatusBuildItem.isDockerAvailable()) {
            String message = "Docker isn't working, dev services for Amazon Services is not available.";
            if (launchMode.getLaunchMode() == LaunchMode.TEST) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return;
        }
        LocalStackDevServicesConfig newlocalStackDevServicesConfig = LocalStackDevServicesConfig.from(localStackDevServicesBuildTimeConfig);
        ArrayList<RunningDevServiceWithConfig> newRunningDevServices = new ArrayList<RunningDevServiceWithConfig>();
        if (currentDevServices != null) {
            this.stopOrRestartIfRequired(newlocalStackDevServicesConfig, requestedServicesBySharedServiceName);
            newRunningDevServices.addAll(currentDevServices);
        }
        requestedServicesBySharedServiceName.forEach((devServiceName, requestedServicesGroup) -> {
            DevServicesResultBuildItem.RunningDevService namedDevService = this.startLocalStack((String)devServiceName, launchMode.getLaunchMode(), localStackDevServicesBuildTimeConfig, (List<DevServicesLocalStackProviderBuildItem>)requestedServicesGroup, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout, consoleInstalledBuildItem, loggingSetupBuildItem);
            if (namedDevService != null) {
                newRunningDevServices.add(new RunningDevServiceWithConfig(namedDevService, (List<DevServicesLocalStackProviderBuildItem>)requestedServicesGroup));
            }
        });
        currentLocalStackDevServicesConfig = newlocalStackDevServicesConfig;
        currentDevServices = newRunningDevServices;
        currentDevServices.forEach(devService -> devServicesResultBuildItemBuildProducer.produce((BuildItem)devService.getRunningDevService().toBuildItem()));
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (currentDevServices != null) {
                        for (RunningDevServiceWithConfig i : currentDevServices) {
                            try {
                                i.getRunningDevService().close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop aws broker", t);
                            }
                        }
                    }
                    first = true;
                    currentDevServices = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
    }

    private void stopOrRestartIfRequired(LocalStackDevServicesConfig newlocalStackDevServicesConfig, Map<String, List<DevServicesLocalStackProviderBuildItem>> requestedServicesBySharedServiceName) {
        boolean preMatchCondition = newlocalStackDevServicesConfig.equals(currentLocalStackDevServicesConfig);
        ArrayList<RunningDevServiceWithConfig> keptRunningService = new ArrayList<RunningDevServiceWithConfig>();
        for (RunningDevServiceWithConfig i : currentDevServices) {
            DevServicesResultBuildItem.RunningDevService runningDevService = i.getRunningDevService();
            String oldContainerName = runningDevService.getName();
            Map<String, LocalStackDevServicesBaseConfig> oldDevServiceConfig = i.getConfig();
            List<DevServicesLocalStackProviderBuildItem> maybeNewDevService = requestedServicesBySharedServiceName.get(oldContainerName);
            if (maybeNewDevService == null || !preMatchCondition || !this.match(oldDevServiceConfig, maybeNewDevService)) {
                try {
                    runningDevService.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop aws services", e);
                }
                continue;
            }
            requestedServicesBySharedServiceName.remove(oldContainerName);
            keptRunningService.add(i);
        }
        currentDevServices = keptRunningService;
    }

    private boolean match(Map<String, LocalStackDevServicesBaseConfig> oldDevServiceConfig, List<DevServicesLocalStackProviderBuildItem> newDevService) {
        return newDevService.stream().collect(Collectors.toMap(r -> r.getService().getName(), r -> r.getConfig())).equals(oldDevServiceConfig);
    }

    private DevServicesResultBuildItem.RunningDevService startLocalStack(String devServiceName, LaunchMode launchMode, LocalStackDevServicesBuildTimeConfig localStackDevServicesBuildTimeConfig, List<DevServicesLocalStackProviderBuildItem> requestedServicesGroup, boolean useSharedNetwork, Optional<Duration> timeout, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        if (requestedServicesGroup.size() == 0) {
            return null;
        }
        String prettyRequestServicesName = String.join((CharSequence)", ", (CharSequence[])requestedServicesGroup.stream().map(ds -> ds.getService().getName()).toArray(String[]::new));
        String containerFriendlyName = devServiceName + " (" + prettyRequestServicesName + ")";
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode == LaunchMode.TEST ? "(test) " : "") + "Amazon Dev Services for " + containerFriendlyName + " starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        HashMap config = new HashMap();
        try {
            Optional maybeContainerAddress = containerLocator.locateContainer(devServiceName, requestedServicesGroup.get(0).getConfig().isShared(), launchMode);
            DevServicesResultBuildItem.RunningDevService devService = maybeContainerAddress.map(containerAddress -> {
                LocalStackContainer defaultValueContainerNotStarted = new LocalStackContainer(DockerImageName.parse((String)localStackDevServicesBuildTimeConfig.imageName()).asCompatibleSubstituteFor("localstack/localstack"));
                requestedServicesGroup.forEach(ds -> config.putAll(ds.getDevProvider().reuseLocalStack(new BorrowedLocalStackContainer((ContainerAddress)containerAddress, defaultValueContainerNotStarted){
                    final /* synthetic */ ContainerAddress val$containerAddress;
                    final /* synthetic */ LocalStackContainer val$defaultValueContainerNotStarted;
                    {
                        this.val$containerAddress = containerAddress;
                        this.val$defaultValueContainerNotStarted = localStackContainer;
                    }

                    public URI getEndpointOverride(LocalStackContainer.EnabledService enabledService) {
                        try {
                            return new URI("http://" + this.val$containerAddress.getHost() + ":" + this.val$containerAddress.getPort());
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException("Cannot obtain endpoint URL", e);
                        }
                    }

                    public String getRegion() {
                        return this.val$defaultValueContainerNotStarted.getRegion();
                    }

                    public String getAccessKey() {
                        return this.val$defaultValueContainerNotStarted.getAccessKey();
                    }

                    public String getSecretKey() {
                        return this.val$defaultValueContainerNotStarted.getSecretKey();
                    }
                })));
                return new DevServicesResultBuildItem.RunningDevService(devServiceName, containerAddress.getId(), null, config);
            }).orElseGet(() -> {
                LocalStackContainer container = (LocalStackContainer)((LocalStackContainer)new LocalStackContainer(DockerImageName.parse((String)localStackDevServicesBuildTimeConfig.imageName()).asCompatibleSubstituteFor("localstack/localstack")).withEnv(Stream.concat(requestedServicesGroup.stream().map(ds -> ds.getConfig().getContainerProperties()).flatMap(ds -> ds.entrySet().stream()), localStackDevServicesBuildTimeConfig.containerProperties().entrySet().stream()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())))).withServices((LocalStackContainer.EnabledService[])requestedServicesGroup.stream().map(ds -> ds.getService()).toArray(LocalStackContainer.EnabledService[]::new)).withLabel(DEV_SERVICE_LABEL, devServiceName);
                localStackDevServicesBuildTimeConfig.initScriptsFolder().ifPresent(initScriptsFolder -> {
                    container.withFileSystemBind(initScriptsFolder, "/etc/localstack/init/ready.d");
                    localStackDevServicesBuildTimeConfig.initCompletionMsg().ifPresent(initCompletionMsg -> container.waitingFor((WaitStrategy)Wait.forLogMessage((String)(".*" + initCompletionMsg + ".*\\n"), (int)1)));
                });
                ConfigureUtil.configureSharedNetwork((GenericContainer)container, (String)devServiceName);
                timeout.ifPresent(arg_0 -> ((LocalStackContainer)container).withStartupTimeout(arg_0));
                container.start();
                requestedServicesGroup.forEach(ds -> config.putAll(ds.getDevProvider().prepareLocalStack(container)));
                log.info((Object)("Amazon Dev Services for " + containerFriendlyName + " started. Other Quarkus applications in dev mode will find the LocalStack automatically."));
                return new DevServicesResultBuildItem.RunningDevService(devServiceName, container.getContainerId(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, containerFriendlyName), config);
            });
            compressor.close();
            return devService;
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
    }

    static {
        first = true;
        PORT = LocalStackContainer.EnabledService.named((String)"whatever").getPort();
        containerLocator = new ContainerLocator(DEV_SERVICE_LABEL, PORT);
    }

    private static final class RunningDevServiceWithConfig {
        private final DevServicesResultBuildItem.RunningDevService runningDevService;
        private final Map<String, LocalStackDevServicesBaseConfig> config;

        public RunningDevServiceWithConfig(DevServicesResultBuildItem.RunningDevService namedDevService, List<DevServicesLocalStackProviderBuildItem> requestedServicesGroup) {
            this.runningDevService = namedDevService;
            this.config = requestedServicesGroup.stream().collect(Collectors.toMap(r -> r.getService().getName(), r -> r.getConfig()));
        }

        public DevServicesResultBuildItem.RunningDevService getRunningDevService() {
            return this.runningDevService;
        }

        public Map<String, LocalStackDevServicesBaseConfig> getConfig() {
            return this.config;
        }
    }

    private static final class LocalStackDevServicesConfig {
        private final String imageName;
        private final Map<String, String> containerProperties;

        public static LocalStackDevServicesConfig from(LocalStackDevServicesBuildTimeConfig config) {
            return new LocalStackDevServicesConfig(config);
        }

        private LocalStackDevServicesConfig(LocalStackDevServicesBuildTimeConfig config) {
            this.imageName = config.imageName();
            this.containerProperties = config.containerProperties();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalStackDevServicesConfig that = (LocalStackDevServicesConfig)o;
            return Objects.equals(this.imageName, that.imageName) && Objects.equals(this.containerProperties, that.containerProperties);
        }

        public int hashCode() {
            return Objects.hash(this.imageName, this.containerProperties);
        }
    }
}

