/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment;

import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.quarkiverse.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientBuilderBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientBuilderOverrideBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.ClientDeploymentUtil;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientTransportBuilderBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonTelemetryBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientBuilderRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.SdkAutoCloseableDestroyer;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public class AmazonClientExtensionsProcessor {
    @BuildStep
    void setup(List<AmazonClientExtensionBuildItem> amazonExtensions, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        amazonExtensions.forEach(extension -> this.setupExtension((AmazonClientExtensionBuildItem)extension, extensionSslNativeSupport, feature, interceptors));
    }

    protected void setupExtension(AmazonClientExtensionBuildItem extension, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        feature.produce((BuildItem)new FeatureBuildItem(extension.getAmazonServiceClientName()));
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(extension.getAmazonServiceClientName()));
        interceptors.produce((BuildItem)new AmazonClientInterceptorsPathBuildItem(extension.getBuiltinInterceptorsPath()));
    }

    @BuildStep
    void discoverClientInjectionPoints(List<AmazonClientExtensionBuildItem> amazonExtensions, BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientInjectionBuildItem> requireClientInjectionProducer) {
        amazonExtensions.forEach(extension -> this.discoverClientInjectionPointsInternal((AmazonClientExtensionBuildItem)extension, beanRegistrationPhase, requireClientInjectionProducer));
    }

    protected void discoverClientInjectionPointsInternal(AmazonClientExtensionBuildItem extension, BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientInjectionBuildItem> requireClientInjectionProducer) {
        for (InjectionPointInfo injectionPoint : beanRegistrationPhase.getInjectionPoints()) {
            Type injectedType = this.getInjectedType(injectionPoint);
            if (extension.getSyncClientName().equals((Object)injectedType.name())) {
                requireClientInjectionProducer.produce((BuildItem)new RequireAmazonClientInjectionBuildItem(extension.getSyncClientName(), ClientDeploymentUtil.getNamedClientInjection(injectionPoint)));
            }
            if (extension.getAsyncClientName().equals((Object)injectedType.name())) {
                requireClientInjectionProducer.produce((BuildItem)new RequireAmazonClientInjectionBuildItem(extension.getAsyncClientName(), ClientDeploymentUtil.getNamedClientInjection(injectionPoint)));
            }
            if (extension.getPresignerClientName() == null || !extension.getPresignerClientName().equals((Object)injectedType.name())) continue;
            requireClientInjectionProducer.produce((BuildItem)new RequireAmazonClientInjectionBuildItem(extension.getPresignerClientName(), ClientDeploymentUtil.getNamedClientInjection(injectionPoint)));
        }
    }

    private Type getInjectedType(InjectionPointInfo injectionPoint) {
        Type requiredType;
        Type injectedType = requiredType = injectionPoint.getRequiredType();
        if (DotNames.INSTANCE.equals((Object)requiredType.name()) && requiredType instanceof ParameterizedType) {
            injectedType = (Type)requiredType.asParameterizedType().arguments().get(0);
        }
        return injectedType;
    }

    @BuildStep
    void discover(List<AmazonClientExtensionBuildItem> amazonExtensions, List<RequireAmazonClientInjectionBuildItem> amazonClientInjectionPoints, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        amazonExtensions.forEach(extension -> this.discoverClient((AmazonClientExtensionBuildItem)extension, amazonClientInjectionPoints, requireClientProducer));
    }

    protected void discoverClient(AmazonClientExtensionBuildItem extension, List<RequireAmazonClientInjectionBuildItem> amazonClientInjectionPoints, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        Optional<DotName> syncClassName = Optional.empty();
        Optional<DotName> asyncClassName = Optional.empty();
        for (RequireAmazonClientInjectionBuildItem requireInjectionPoint : amazonClientInjectionPoints) {
            if (extension.getSyncClientName().equals((Object)requireInjectionPoint.getClassName())) {
                syncClassName = Optional.of(extension.getSyncClientName());
            }
            if (!extension.getAsyncClientName().equals((Object)requireInjectionPoint.getClassName())) continue;
            asyncClassName = Optional.of(extension.getAsyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            requireClientProducer.produce((BuildItem)new RequireAmazonClientBuildItem(syncClassName, asyncClassName));
        }
    }

    @BuildStep
    void discoverTelemetry(List<AmazonClientExtensionBuildItem> amazonExtensions, BuildProducer<RequireAmazonTelemetryBuildItem> telemetryProducer) {
        amazonExtensions.forEach(extension -> this.discoverTelemetry((AmazonClientExtensionBuildItem)extension, telemetryProducer));
    }

    protected void discoverTelemetry(AmazonClientExtensionBuildItem extension, BuildProducer<RequireAmazonTelemetryBuildItem> telemetryProducer) {
        if (extension.getHasSdkBuildTimeConfig().sdk().telemetry().orElse(false).booleanValue()) {
            telemetryProducer.produce((BuildItem)new RequireAmazonTelemetryBuildItem(extension.getConfigName()));
        }
    }

    @BuildStep
    void setupClient(List<AmazonClientExtensionBuildItem> amazonExtensions, List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<RequireAmazonClientTransportBuilderBuildItem> clientProducer) {
        amazonExtensions.forEach(extension -> this.setupClient((AmazonClientExtensionBuildItem)extension, clientRequirements, clientProducer));
    }

    protected void setupClient(AmazonClientExtensionBuildItem extension, List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<RequireAmazonClientTransportBuilderBuildItem> clientProducer) {
        Optional<Object> syncClassName = Optional.empty();
        Optional<Object> asyncClassName = Optional.empty();
        for (RequireAmazonClientBuildItem clientRequirement : clientRequirements) {
            if (clientRequirement.getSyncClassName().filter(arg_0 -> ((DotName)extension.getSyncClientName()).equals(arg_0)).isPresent()) {
                syncClassName = Optional.of(extension.getSyncClientName());
            }
            if (!clientRequirement.getAsyncClassName().filter(arg_0 -> ((DotName)extension.getAsyncClientName()).equals(arg_0)).isPresent()) continue;
            asyncClassName = Optional.of(extension.getAsyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            clientProducer.produce((BuildItem)new RequireAmazonClientTransportBuilderBuildItem(syncClassName, asyncClassName, extension.getConfigName(), extension.getHasSdkBuildTimeConfig().sdk(), extension.getBuildSyncConfig(), extension.getBuildAsyncConfig()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(List<AmazonClientExtensionBuildItem> amazonExtensions, List<AmazonClientExtensionBuilderInstanceBuildItem> builderInstances, AmazonClientCommonRecorder commonRecorder, AmazonClientBuilderRecorder builderRecorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<AmazonClientBuilderBuildItem> clientBuilders, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        amazonExtensions.forEach(extension -> this.createClientBuilders((AmazonClientExtensionBuildItem)extension, builderInstances, commonRecorder, builderRecorder, amazonClientInjections, amazonRequireTelemtryClients, syncTransports, asyncTransports, clientBuilders, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem));
    }

    protected void createClientBuilders(AmazonClientExtensionBuildItem extension, List<AmazonClientExtensionBuilderInstanceBuildItem> builderInstances, AmazonClientCommonRecorder commonRecorder, AmazonClientBuilderRecorder builderRecorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<AmazonClientBuilderBuildItem> clientBuilders, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        Function<RuntimeValue<SdkPresigner.Builder>, RuntimeValue<SdkPresigner.Builder>> presignerBuilderSupplier = null;
        if (extension.getPresignerBuilderClass() != null) {
            presignerBuilderSupplier = presignerBuilder -> presignerBuilder;
        }
        this.createClientBuilders(extension.getConfigName(), builderInstances, commonRecorder, builderRecorder, (RuntimeValue<? extends HasAmazonClientRuntimeConfig>)extension.getAmazonClientsConfig(), extension.getHasSdkBuildTimeConfig(), amazonClientInjections, amazonRequireTelemtryClients, syncTransports, asyncTransports, extension.getSyncClientName(), extension.getSyncClientBuilderClass(), (syncBuilder, syncTransport) -> builderRecorder.createSyncBuilder(syncBuilder, syncTransport), extension.getAsyncClientName(), extension.getAsyncClientBuilderClass(), (asyncBuilder, asyncTransport) -> builderRecorder.createAsyncBuilder(asyncBuilder, asyncTransport, launchModeBuildItem.getLaunchMode(), (Executor)executorBuildItem.getExecutorProxy(), extension.getAsyncConfig()), extension.getPresignerClientName(), extension.getPresignerBuilderClass(), presignerBuilderSupplier, clientBuilders, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem);
    }

    private void createClientBuilders(String configName, List<AmazonClientExtensionBuilderInstanceBuildItem> builderInstances, AmazonClientCommonRecorder recorder, AmazonClientBuilderRecorder builderRecorder, RuntimeValue<? extends HasAmazonClientRuntimeConfig> amazonClientConfigRuntime, HasSdkBuildTimeConfig sdkBuildConfig, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> amazonClientSyncTransports, List<AmazonClientAsyncTransportBuildItem> amazonClientAsyncTransports, DotName syncClientName, Class<?> syncClientBuilderClass, BiFunction<RuntimeValue<AwsSyncClientBuilder<?, ?>>, RuntimeValue<SdkHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> syncClientBuilderFunction, DotName asyncClientName, Class<?> asyncClientBuilderClass, BiFunction<RuntimeValue<AwsAsyncClientBuilder<?, ?>>, RuntimeValue<SdkAsyncHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> asyncClientBuilderFunction, DotName presignerClientName, Class<?> presignerBuilderClass, Function<RuntimeValue<SdkPresigner.Builder>, RuntimeValue<SdkPresigner.Builder>> presignerBuilderSupplier, BuildProducer<AmazonClientBuilderBuildItem> clientBuilders, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        AmazonClientExtensionBuilderInstanceBuildItem builderInstance;
        Optional<RuntimeValue> syncSdkHttpClientBuilder = amazonClientSyncTransports.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        Optional<RuntimeValue> asyncSdkAsyncHttpClientBuilder = amazonClientAsyncTransports.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        boolean addOpenTelemetry = amazonRequireTelemtryClients.stream().anyMatch(c -> configName.equals(c.getConfigName()));
        if (!syncSdkHttpClientBuilder.isPresent() && !asyncSdkAsyncHttpClientBuilder.isPresent() && presignerBuilderSupplier == null) {
            return;
        }
        Collection syncClientNames = amazonClientInjections.stream().filter(c -> syncClientName.equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        Collection asyncClientNames = amazonClientInjections.stream().filter(c -> asyncClientName.equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        Collection presignerClientNames = amazonClientInjections.stream().filter(c -> presignerClientName != null && presignerClientName.equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        ScheduledExecutorService sharedExecutorService = executorBuildItem.getExecutorProxy();
        if (syncSdkHttpClientBuilder.isPresent() && !syncClientNames.isEmpty()) {
            for (String clientName : syncClientNames) {
                builderInstance = builderInstances.stream().filter(o -> o.getClientBuilderClass().equals(syncClientBuilderClass) && o.getClientName().equals(clientName)).findFirst().orElseThrow();
                RuntimeValue<AwsClientBuilder> syncClientBuilder = syncClientBuilderFunction.apply(builderInstance.getBuilder(), (RuntimeValue<SdkHttpClient.Builder>)syncSdkHttpClientBuilder.get());
                RuntimeValue configuredSyncClientBuilder = recorder.configure(syncClientBuilder, amazonClientConfigRuntime, sdkBuildConfig, sharedExecutorService, configName, clientName);
                clientBuilders.produce((BuildItem)new AmazonClientBuilderBuildItem(configuredSyncClientBuilder, syncClientBuilderClass, clientName, addOpenTelemetry));
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedClient(SyntheticBeanBuildItem.configure((DotName)syncClientName), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(recorder.build(syncClientBuilderClass, clientName)).addInjectionPoint((Type)ClassType.create(syncClientBuilderClass), ClientDeploymentUtil.injectionPointAnnotationsBuilder(clientName))).destroyer(SdkAutoCloseableDestroyer.class)).done());
                clientSync.produce((BuildItem)new AmazonClientSyncResultBuildItem(configName, clientName));
            }
        }
        if (asyncSdkAsyncHttpClientBuilder.isPresent() && !asyncClientNames.isEmpty()) {
            for (String clientName : asyncClientNames) {
                builderInstance = builderInstances.stream().filter(o -> o.getClientBuilderClass().equals(asyncClientBuilderClass) && o.getClientName().equals(clientName)).findFirst().orElseThrow();
                RuntimeValue<AwsClientBuilder> asyncClientBuilder = asyncClientBuilderFunction.apply(builderInstance.getBuilder(), (RuntimeValue<SdkAsyncHttpClient.Builder>)asyncSdkAsyncHttpClientBuilder.get());
                RuntimeValue configuredAsyncClientBuilder = recorder.configure(asyncClientBuilder, amazonClientConfigRuntime, sdkBuildConfig, sharedExecutorService, configName, clientName);
                clientBuilders.produce((BuildItem)new AmazonClientBuilderBuildItem(configuredAsyncClientBuilder, asyncClientBuilderClass, clientName, addOpenTelemetry));
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedClient(SyntheticBeanBuildItem.configure((DotName)asyncClientName), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(recorder.build(asyncClientBuilderClass, clientName)).addInjectionPoint((Type)ClassType.create(asyncClientBuilderClass), ClientDeploymentUtil.injectionPointAnnotationsBuilder(clientName))).destroyer(SdkAutoCloseableDestroyer.class)).done());
                clientAsync.produce((BuildItem)new AmazonClientAsyncResultBuildItem(configName, clientName));
            }
        }
        if (presignerBuilderSupplier != null && !presignerClientNames.isEmpty()) {
            for (String clientName : presignerClientNames) {
                builderInstance = builderInstances.stream().filter(o -> o.getClientBuilderClass().equals(presignerBuilderClass) && o.getClientName().equals(clientName)).findFirst().orElseThrow();
                RuntimeValue presignerBuilder = presignerBuilderSupplier.apply((RuntimeValue<SdkPresigner.Builder>)builderInstance.getBuilder());
                presignerBuilder = recorder.configurePresigner(presignerBuilder, amazonClientConfigRuntime, configName, clientName);
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure(presignerBuilderClass), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(presignerBuilder).done());
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedClient(SyntheticBeanBuildItem.configure((DotName)presignerClientName), clientName).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(recorder.buildPresigner(presignerBuilderClass, clientName)).addInjectionPoint((Type)ClassType.create(presignerBuilderClass), ClientDeploymentUtil.injectionPointAnnotationsBuilder(clientName))).destroyer(SdkAutoCloseableDestroyer.class)).done());
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void produceSyntheticBeans(AmazonClientOpenTelemetryRecorder otelRecorder, List<AmazonClientBuilderBuildItem> clientBuilders, List<AmazonClientBuilderOverrideBuildItem> clientBuilderOverride, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        for (AmazonClientBuilderBuildItem clientBuilder : clientBuilders) {
            Optional<AmazonClientBuilderOverrideBuildItem> override = clientBuilderOverride.stream().filter(o -> o.getBuilderClass().equals(clientBuilder.getBuilderClass()) && o.getClientName().equals(clientBuilder.getClientName())).findFirst();
            if (!override.isEmpty()) continue;
            if (clientBuilder.hasOpenTelemetry()) {
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure((Class)clientBuilder.getBuilderClass()), clientBuilder.getClientName()).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configure(clientBuilder.getClientBuilder())).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
                continue;
            }
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder(SyntheticBeanBuildItem.configure((Class)clientBuilder.getBuilderClass()), clientBuilder.getClientName()).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).runtimeValue(clientBuilder.getClientBuilder()).done());
        }
    }
}

