/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment;

import io.quarkiverse.amazon.common.deployment.spi.BorrowedLocalStackContainer;
import io.quarkiverse.amazon.common.deployment.spi.DevServicesLocalStackProviderBuildItem;
import io.quarkiverse.amazon.common.deployment.spi.LocalStackDevServicesBaseConfig;
import io.quarkiverse.amazon.common.runtime.LocalStackDevServicesBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DevServicesLocalStackProcessor {
    private static final Logger log = Logger.getLogger(DevServicesLocalStackProcessor.class);
    static volatile List<RunningDevServiceWithConfig> currentDevServices;
    static volatile LocalStackDevServicesConfig currentLocalStackDevServicesConfig;
    static volatile boolean first;
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-localstack";
    private static final int PORT;
    private static final ContainerLocator containerLocator;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
    public void startLocalStackDevService(LaunchModeBuildItem launchMode, LocalStackDevServicesBuildTimeConfig localStackDevServicesBuildTimeConfig, List<DevServicesLocalStackProviderBuildItem> requestedServices, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<DevServicesComposeProjectBuildItem> composeProjectBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, DevServicesConfig devServicesConfig, BuildProducer<DevServicesResultBuildItem> devServicesResultBuildItemBuildProducer, LoggingSetupBuildItem loggingSetupBuildItem) {
        Map<String, List<DevServicesLocalStackProviderBuildItem>> requestedServicesBySharedServiceName;
        if (launchMode.isTest()) {
            requestedServicesBySharedServiceName = requestedServices.stream().collect(Collectors.toMap(r -> r.getConfig().getServiceName(), Collections::singletonList, (requestedService1, requestedService2) -> {
                ArrayList ret = new ArrayList();
                ret.addAll(requestedService1);
                ret.addAll(requestedService2);
                return ret;
            }));
        } else {
            requestedServicesBySharedServiceName = requestedServices.stream().filter(rs -> rs.getConfig().isShared()).collect(Collectors.toMap(r -> r.getConfig().isIsolated() ? String.format("%s-%s", r.getConfig().getServiceName(), r.getService().getName()) : r.getConfig().getServiceName(), Collections::singletonList, (requestedService1, requestedService2) -> {
                ArrayList ret = new ArrayList();
                ret.addAll(requestedService1);
                ret.addAll(requestedService2);
                return ret;
            }));
            requestedServicesBySharedServiceName.putAll(requestedServices.stream().filter(rs -> !rs.getConfig().isShared()).collect(Collectors.toMap(r -> r.getConfig().getServiceName(), Collections::singletonList, (requestedService1, requestedService2) -> {
                ArrayList ret = new ArrayList();
                ret.addAll(requestedService1);
                ret.addAll(requestedService2);
                return ret;
            })));
        }
        if (!requestedServicesBySharedServiceName.isEmpty() && !dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            String message = "Docker isn't working, dev services for Amazon Services is not available.";
            if (launchMode.getLaunchMode() == LaunchMode.TEST) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return;
        }
        LocalStackDevServicesConfig newlocalStackDevServicesConfig = LocalStackDevServicesConfig.from(localStackDevServicesBuildTimeConfig);
        ArrayList<RunningDevServiceWithConfig> newRunningDevServices = new ArrayList<RunningDevServiceWithConfig>();
        if (currentDevServices != null) {
            this.stopOrRestartIfRequired(newlocalStackDevServicesConfig, requestedServicesBySharedServiceName);
            newRunningDevServices.addAll(currentDevServices);
        }
        boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
        requestedServicesBySharedServiceName.forEach((devServiceName, requestedServicesGroup) -> {
            DevServicesResultBuildItem.RunningDevService namedDevService = this.startLocalStack((String)devServiceName, launchMode.getLaunchMode(), localStackDevServicesBuildTimeConfig, (List<DevServicesLocalStackProviderBuildItem>)requestedServicesGroup, composeProjectBuildItem.map(DevServicesComposeProjectBuildItem::getDefaultNetworkId).orElse(null), useSharedNetwork, devServicesConfig.timeout(), consoleInstalledBuildItem, loggingSetupBuildItem);
            if (namedDevService != null) {
                newRunningDevServices.add(new RunningDevServiceWithConfig(namedDevService, (List<DevServicesLocalStackProviderBuildItem>)requestedServicesGroup));
            }
        });
        currentLocalStackDevServicesConfig = newlocalStackDevServicesConfig;
        currentDevServices = newRunningDevServices;
        currentDevServices.forEach(devService -> devServicesResultBuildItemBuildProducer.produce((BuildItem)devService.getRunningDevService().toBuildItem()));
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (currentDevServices != null) {
                        for (RunningDevServiceWithConfig i : currentDevServices) {
                            try {
                                i.getRunningDevService().close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop aws broker", t);
                            }
                        }
                    }
                    first = true;
                    currentDevServices = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
    }

    private void stopOrRestartIfRequired(LocalStackDevServicesConfig newlocalStackDevServicesConfig, Map<String, List<DevServicesLocalStackProviderBuildItem>> requestedServicesBySharedServiceName) {
        boolean preMatchCondition = newlocalStackDevServicesConfig.equals(currentLocalStackDevServicesConfig);
        ArrayList<RunningDevServiceWithConfig> keptRunningService = new ArrayList<RunningDevServiceWithConfig>();
        for (RunningDevServiceWithConfig i : currentDevServices) {
            DevServicesResultBuildItem.RunningDevService runningDevService = i.getRunningDevService();
            String oldContainerName = runningDevService.getName();
            List<DevServicesLocalStackProviderBuildItem> maybeNewDevService = requestedServicesBySharedServiceName.get(oldContainerName);
            if (maybeNewDevService == null || !preMatchCondition || i.matchesOtherConfig(maybeNewDevService)) {
                try {
                    runningDevService.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop aws services", e);
                }
                continue;
            }
            requestedServicesBySharedServiceName.remove(oldContainerName);
            keptRunningService.add(i);
        }
        currentDevServices = keptRunningService;
    }

    private DevServicesResultBuildItem.RunningDevService startLocalStack(String devServiceName, LaunchMode launchMode, LocalStackDevServicesBuildTimeConfig localStackDevServicesBuildTimeConfig, List<DevServicesLocalStackProviderBuildItem> requestedServicesGroup, String defaultNetworkId, boolean useSharedNetwork, Optional<Duration> timeout, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        if (requestedServicesGroup.isEmpty()) {
            return null;
        }
        String prettyRequestServicesName = String.join((CharSequence)", ", (CharSequence[])requestedServicesGroup.stream().map(ds -> ds.getService().getName()).toArray(String[]::new));
        String containerFriendlyName = devServiceName + " (" + prettyRequestServicesName + ")";
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode == LaunchMode.TEST ? "(test) " : "") + "Amazon Dev Services for " + containerFriendlyName + " starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        HashMap config = new HashMap();
        try {
            Optional maybeContainerAddress = containerLocator.locateContainer(devServiceName, requestedServicesGroup.get(0).getConfig().isShared(), launchMode);
            DevServicesResultBuildItem.RunningDevService devService = maybeContainerAddress.map(containerAddress -> {
                try (LocalStackContainer defaultValueContainerNotStarted = new LocalStackContainer(DockerImageName.parse((String)localStackDevServicesBuildTimeConfig.imageName()).asCompatibleSubstituteFor("localstack/localstack"));){
                    String defaultRegion = defaultValueContainerNotStarted.getRegion();
                    String defaultAccessKey = defaultValueContainerNotStarted.getAccessKey();
                    String defaultSecretKey = defaultValueContainerNotStarted.getSecretKey();
                    requestedServicesGroup.forEach(ds -> config.putAll(ds.getDevProvider().reuseLocalStack(new BorrowedLocalStackContainer(){
                        final /* synthetic */ ContainerAddress val$containerAddress;
                        final /* synthetic */ String val$defaultRegion;
                        final /* synthetic */ String val$defaultAccessKey;
                        final /* synthetic */ String val$defaultSecretKey;
                        {
                            this.val$containerAddress = containerAddress;
                            this.val$defaultRegion = string;
                            this.val$defaultAccessKey = string2;
                            this.val$defaultSecretKey = string3;
                        }

                        public URI getEndpointOverride(LocalStackContainer.EnabledService enabledService) {
                            try {
                                return new URI("http://" + this.val$containerAddress.getHost() + ":" + this.val$containerAddress.getPort());
                            }
                            catch (URISyntaxException e) {
                                throw new IllegalStateException("Cannot obtain endpoint URL", e);
                            }
                        }

                        public String getRegion() {
                            return this.val$defaultRegion;
                        }

                        public String getAccessKey() {
                            return this.val$defaultAccessKey;
                        }

                        public String getSecretKey() {
                            return this.val$defaultSecretKey;
                        }
                    })));
                }
                return new DevServicesResultBuildItem.RunningDevService(devServiceName, containerAddress.getId(), null, config);
            }).orElseGet(() -> {
                boolean hasInitScripts;
                Map<String, String> envVars = Stream.concat(requestedServicesGroup.stream().map(ds -> ds.getConfig().getContainerProperties()).flatMap(ds -> ds.entrySet().stream()), localStackDevServicesBuildTimeConfig.containerProperties().entrySet().stream()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
                boolean bl = hasInitScripts = localStackDevServicesBuildTimeConfig.initScriptsFolder().isPresent() || localStackDevServicesBuildTimeConfig.initScriptsClasspath().isPresent();
                if (hasInitScripts && !envVars.containsKey("LOCALSTACK_HOST")) {
                    envVars.put("LOCALSTACK_HOST", "127.0.0.1");
                    log.debug((Object)"LocalStack init scripts detected - automatically setting LOCALSTACK_HOST=127.0.0.1 to ensure scripts can connect to LocalStack from within the container");
                }
                LocalStackContainer container = (LocalStackContainer)((LocalStackContainer)new LocalStackContainer(DockerImageName.parse((String)localStackDevServicesBuildTimeConfig.imageName()).asCompatibleSubstituteFor("localstack/localstack")).withEnv(envVars)).withServices((LocalStackContainer.EnabledService[])requestedServicesGroup.stream().map(ds -> ds.getService()).toArray(LocalStackContainer.EnabledService[]::new)).withLabel(DEV_SERVICE_LABEL, devServiceName);
                localStackDevServicesBuildTimeConfig.port().ifPresent(port -> container.setPortBindings(Collections.singletonList("%s:%s".formatted(port, PORT))));
                localStackDevServicesBuildTimeConfig.initScriptsFolder().ifPresentOrElse(initScriptsFolder -> container.withFileSystemBind(initScriptsFolder, "/etc/localstack/init/ready.d", BindMode.READ_ONLY), () -> localStackDevServicesBuildTimeConfig.initScriptsClasspath().ifPresent(resourcePath -> {
                    MountableFile mountableFile = MountableFile.forClasspathResource((String)resourcePath, (Integer)555);
                    container.withCopyFileToContainer(mountableFile, "/etc/localstack/init/ready.d");
                }));
                localStackDevServicesBuildTimeConfig.initCompletionMsg().ifPresent(initCompletionMsg -> container.waitingFor((WaitStrategy)Wait.forLogMessage((String)(".*" + initCompletionMsg + ".*\\n"), (int)1)));
                String hostName = ConfigureUtil.configureNetwork((GenericContainer)container, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)devServiceName);
                timeout.ifPresent(arg_0 -> ((LocalStackContainer)container).withStartupTimeout(arg_0));
                container.start();
                String finalHostName = hostName;
                requestedServicesGroup.forEach(ds -> {
                    Map serviceConfig = ds.getDevProvider().prepareLocalStack(container);
                    if (finalHostName != null && useSharedNetwork) {
                        this.modifyEndpointUrlsForSharedNetwork(serviceConfig, finalHostName);
                    }
                    config.putAll(serviceConfig);
                });
                log.info((Object)("Amazon Dev Services for " + containerFriendlyName + " started. Other Quarkus applications in dev mode will find the LocalStack automatically."));
                return new DevServicesResultBuildItem.RunningDevService(devServiceName, container.getContainerId(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, containerFriendlyName), config);
            });
            compressor.close();
            return devService;
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
    }

    private void modifyEndpointUrlsForSharedNetwork(Map<String, String> config, String hostname) {
        for (Map.Entry<String, String> entry : new HashMap<String, String>(config).entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.endsWith("endpoint-override") || value == null) continue;
            try {
                URI uri = new URI(value);
                if (!"localhost".equals(uri.getHost()) && !"127.0.0.1".equals(uri.getHost())) continue;
                URI modifiedUri = new URI(uri.getScheme(), uri.getUserInfo(), hostname, PORT, uri.getPath(), uri.getQuery(), uri.getFragment());
                config.put(key, modifiedUri.toString());
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not modify endpoint URL for shared network: " + value), (Throwable)e);
            }
        }
    }

    static {
        first = true;
        PORT = LocalStackContainer.EnabledService.named((String)"whatever").getPort();
        containerLocator = new ContainerLocator(DEV_SERVICE_LABEL, PORT);
    }

    private static final class LocalStackDevServicesConfig {
        private final String imageName;
        private final Map<String, String> containerProperties;

        public static LocalStackDevServicesConfig from(LocalStackDevServicesBuildTimeConfig config) {
            return new LocalStackDevServicesConfig(config);
        }

        private LocalStackDevServicesConfig(LocalStackDevServicesBuildTimeConfig config) {
            this.imageName = config.imageName();
            this.containerProperties = config.containerProperties();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalStackDevServicesConfig that = (LocalStackDevServicesConfig)o;
            return Objects.equals(this.imageName, that.imageName) && Objects.equals(this.containerProperties, that.containerProperties);
        }

        public int hashCode() {
            return Objects.hash(this.imageName, this.containerProperties);
        }
    }

    private static final class RunningDevServiceWithConfig {
        private final DevServicesResultBuildItem.RunningDevService runningDevService;
        private final Map<String, Set<LocalStackDevServicesBaseConfig>> config;

        public RunningDevServiceWithConfig(DevServicesResultBuildItem.RunningDevService namedDevService, List<DevServicesLocalStackProviderBuildItem> requestedServicesGroup) {
            this.runningDevService = namedDevService;
            this.config = this.createComparableConfigGroup(requestedServicesGroup);
        }

        public DevServicesResultBuildItem.RunningDevService getRunningDevService() {
            return this.runningDevService;
        }

        private Map<String, Set<LocalStackDevServicesBaseConfig>> createComparableConfigGroup(List<DevServicesLocalStackProviderBuildItem> servicesGroup) {
            HashMap<String, Set<LocalStackDevServicesBaseConfig>> configMap = new HashMap<String, Set<LocalStackDevServicesBaseConfig>>();
            for (DevServicesLocalStackProviderBuildItem item : servicesGroup) {
                configMap.computeIfAbsent(item.getService().getName(), k -> new HashSet()).add(item.getConfig());
            }
            return configMap;
        }

        public boolean matchesOtherConfig(List<DevServicesLocalStackProviderBuildItem> otherServiceList) {
            return this.config.equals(this.createComparableConfigGroup(otherServiceList));
        }
    }
}

