/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import java.util.function.BooleanSupplier;

public class AmazonHttpClients {
    public static final String APACHE_HTTP_SERVICE = "software.amazon.awssdk.http.apache.ApacheSdkHttpService";
    public static final String NETTY_HTTP_SERVICE = "software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService";
    public static final String URL_CONNECTION_HTTP_SERVICE = "software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService";
    public static final String AWS_CRT_HTTP_SERVICE = "software.amazon.awssdk.http.crt.AwsCrtSdkHttpService";

    public static class IsAmazonAwsCrtHttpServicePresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)AmazonHttpClients.AWS_CRT_HTTP_SERVICE);
        }
    }

    public static class IsAmazonUrlConnectionHttpServicePresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)AmazonHttpClients.URL_CONNECTION_HTTP_SERVICE);
        }
    }

    public static class IsAmazonNettyHttpServicePresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)AmazonHttpClients.NETTY_HTTP_SERVICE);
        }
    }

    public static class IsAmazonApacheHttpServicePresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)AmazonHttpClients.APACHE_HTTP_SERVICE);
        }
    }
}

