/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment;

import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;

public abstract class AbstractAmazonServiceProcessor {
    protected abstract String amazonServiceClientName();

    protected abstract String configName();

    protected abstract DotName syncClientName();

    protected abstract Class<?> syncClientBuilderClass();

    protected abstract DotName asyncClientName();

    protected abstract Class<?> asyncClientBuilderClass();

    protected DotName presignerClientName() {
        return null;
    }

    protected Class<?> presignerBuilderClass() {
        return null;
    }

    protected abstract String builtinInterceptorsPath();

    protected abstract HasTransportBuildTimeConfig transportBuildTimeConfig();

    protected abstract HasSdkBuildTimeConfig sdkBuildTimeConfig();

    protected void createExtensionBuilders(AmazonClientRecorder recorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, BuildProducer<AmazonClientExtensionBuilderInstanceBuildItem> builderIstances) {
        Collection syncClientNames = amazonClientInjections.stream().filter(c -> this.syncClientName().equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        Collection asyncClientNames = amazonClientInjections.stream().filter(c -> this.asyncClientName().equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        Collection presignerClientNames = amazonClientInjections.stream().filter(c -> this.presignerClientName() != null && this.presignerClientName().equals((Object)c.getClassName())).map(c -> c.getName()).distinct().collect(Collectors.toSet());
        for (String clientName : syncClientNames) {
            builderIstances.produce((BuildItem)new AmazonClientExtensionBuilderInstanceBuildItem(clientName, this.syncClientBuilderClass(), recorder.getSyncBuilder()));
        }
        for (String clientName : asyncClientNames) {
            builderIstances.produce((BuildItem)new AmazonClientExtensionBuilderInstanceBuildItem(clientName, this.asyncClientBuilderClass(), recorder.getAsyncBuilder()));
        }
        for (String clientName : presignerClientNames) {
            builderIstances.produce((BuildItem)new AmazonClientExtensionBuilderInstanceBuildItem(clientName, this.presignerBuilderClass(), recorder.createPresignerBuilder()));
        }
    }

    protected void setupExtension(AmazonClientRecorder recorder, BuildProducer<AmazonClientExtensionBuildItem> amazonExtensions) {
        amazonExtensions.produce((BuildItem)new AmazonClientExtensionBuildItem(this.configName(), this.amazonServiceClientName(), this.builtinInterceptorsPath(), this.syncClientName(), this.syncClientBuilderClass(), this.asyncClientName(), this.asyncClientBuilderClass(), this.presignerClientName(), this.presignerBuilderClass(), recorder, this.transportBuildTimeConfig(), this.sdkBuildTimeConfig()));
    }
}

