/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.RuntimeValue;
import org.jboss.jandex.DotName;

public final class AmazonClientExtensionBuildItem
extends MultiBuildItem {
    private final String configName;
    private final HasTransportBuildTimeConfig transportBuildTimeConfig;
    private final String amazonServiceClientName;
    private final String builtinInterceptorsPath;
    private final DotName syncClientName;
    private final DotName asyncClientName;
    private final DotName presignerClientName;
    private final HasSdkBuildTimeConfig hasSdkBuildTimeConfig;
    private final Class<?> syncClientBuilderClass;
    private final Class<?> asyncClientBuilderClass;
    private final Class<?> presignerBuilderClass;
    private final RuntimeValue<SyncHttpClientConfig> syncConfig;
    private final RuntimeValue<AsyncHttpClientConfig> asyncConfig;
    private final RuntimeValue<HasAmazonClientRuntimeConfig> amazonClientsConfig;

    public AmazonClientExtensionBuildItem(String configName, String amazonServiceClientName, String builtinInterceptorsPath, DotName syncClientName, Class<?> syncClientBuilderClass, DotName asyncClientName, Class<?> asyncClientBuilderClass, DotName presignerClientName, Class<?> presignerBuilderClass, AmazonClientRecorder recorder, HasTransportBuildTimeConfig transportBuildTimeConfig, HasSdkBuildTimeConfig hasSdkBuildTimeConfig) {
        this.configName = configName;
        this.amazonServiceClientName = amazonServiceClientName;
        this.builtinInterceptorsPath = builtinInterceptorsPath;
        this.syncClientName = syncClientName;
        this.syncClientBuilderClass = syncClientBuilderClass;
        this.asyncClientName = asyncClientName;
        this.asyncClientBuilderClass = asyncClientBuilderClass;
        this.presignerClientName = presignerClientName;
        this.presignerBuilderClass = presignerBuilderClass;
        this.transportBuildTimeConfig = transportBuildTimeConfig;
        this.hasSdkBuildTimeConfig = hasSdkBuildTimeConfig;
        this.syncConfig = recorder.getSyncConfig();
        this.asyncConfig = recorder.getAsyncConfig();
        this.amazonClientsConfig = recorder.getAmazonClientsConfig();
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getAmazonServiceClientName() {
        return this.amazonServiceClientName;
    }

    public String getBuiltinInterceptorsPath() {
        return this.builtinInterceptorsPath;
    }

    public DotName getSyncClientName() {
        return this.syncClientName;
    }

    public DotName getAsyncClientName() {
        return this.asyncClientName;
    }

    public DotName getPresignerClientName() {
        return this.presignerClientName;
    }

    public AsyncHttpClientBuildTimeConfig getBuildAsyncConfig() {
        return this.transportBuildTimeConfig.asyncClient();
    }

    public RuntimeValue<AsyncHttpClientConfig> getAsyncConfig() {
        return this.asyncConfig;
    }

    public SyncHttpClientBuildTimeConfig getBuildSyncConfig() {
        return this.transportBuildTimeConfig.syncClient();
    }

    public RuntimeValue<SyncHttpClientConfig> getSyncConfig() {
        return this.syncConfig;
    }

    public HasSdkBuildTimeConfig getHasSdkBuildTimeConfig() {
        return this.hasSdkBuildTimeConfig;
    }

    public RuntimeValue<HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return this.amazonClientsConfig;
    }

    public Class<?> getSyncClientBuilderClass() {
        return this.syncClientBuilderClass;
    }

    public Class<?> getAsyncClientBuilderClass() {
        return this.asyncClientBuilderClass;
    }

    public Class<?> getPresignerBuilderClass() {
        return this.presignerBuilderClass;
    }
}

