/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.AbstractAmazonClientTransportRecorder;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;

@Recorder
public class AmazonClientUrlConnectionTransportRecorder
extends AbstractAmazonClientTransportRecorder {
    @Override
    public RuntimeValue<SdkHttpClient.Builder> configureSync(String clientName, RuntimeValue<SyncHttpClientConfig> syncConfigRuntime) {
        SyncHttpClientConfig syncConfig = (SyncHttpClientConfig)syncConfigRuntime.getValue();
        this.validateTlsKeyManagersProvider(clientName, syncConfig.tlsKeyManagersProvider, "sync");
        this.validateTlsTrustManagersProvider(clientName, syncConfig.tlsTrustManagersProvider, "sync");
        UrlConnectionHttpClient.Builder builder = UrlConnectionHttpClient.builder();
        builder.connectionTimeout(syncConfig.connectionTimeout);
        builder.socketTimeout(syncConfig.socketTimeout);
        builder.tlsKeyManagersProvider(this.getTlsKeyManagersProvider(syncConfig.tlsKeyManagersProvider));
        builder.tlsTrustManagersProvider(this.getTlsTrustManagersProvider(syncConfig.tlsTrustManagersProvider));
        return new RuntimeValue((Object)builder);
    }
}

