/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.FileStoreTlsManagersProviderConfig;
import io.quarkus.amazon.common.runtime.TlsKeyManagersProviderConfig;
import java.nio.file.Path;
import software.amazon.awssdk.http.FileStoreTlsKeyManagersProvider;
import software.amazon.awssdk.http.SystemPropertyTlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsKeyManagersProvider;

public enum TlsKeyManagersProviderType {
    NONE{

        @Override
        public TlsKeyManagersProvider create(TlsKeyManagersProviderConfig config) {
            return TlsKeyManagersProvider.noneProvider();
        }
    }
    ,
    SYSTEM_PROPERTY{

        @Override
        public TlsKeyManagersProvider create(TlsKeyManagersProviderConfig config) {
            return SystemPropertyTlsKeyManagersProvider.create();
        }
    }
    ,
    FILE_STORE{

        @Override
        public TlsKeyManagersProvider create(TlsKeyManagersProviderConfig config) {
            FileStoreTlsManagersProviderConfig fileStore = config.fileStore;
            return FileStoreTlsKeyManagersProvider.create((Path)fileStore.path.get(), (String)fileStore.type.get(), (String)fileStore.password.orElse(null));
        }
    };


    public abstract TlsKeyManagersProvider create(TlsKeyManagersProviderConfig var1);
}

