/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.FileStoreTlsTrustManagersProvider;
import io.quarkus.amazon.common.runtime.NoneTlsTrustManagersProvider;
import io.quarkus.amazon.common.runtime.TlsTrustManagersProviderConfig;
import software.amazon.awssdk.http.TlsTrustManagersProvider;

public enum TlsTrustManagersProviderType {
    TRUST_ALL{

        @Override
        public TlsTrustManagersProvider create(TlsTrustManagersProviderConfig config) {
            return new NoneTlsTrustManagersProvider();
        }
    }
    ,
    SYSTEM_PROPERTY{

        @Override
        public TlsTrustManagersProvider create(TlsTrustManagersProviderConfig config) {
            return null;
        }
    }
    ,
    FILE_STORE{

        @Override
        public TlsTrustManagersProvider create(TlsTrustManagersProviderConfig config) {
            return new FileStoreTlsTrustManagersProvider(config.fileStore);
        }
    };


    public abstract TlsTrustManagersProvider create(TlsTrustManagersProviderConfig var1);
}

