/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.AbstractAmazonClientTransportRecorder;
import io.quarkus.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.URI;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

@Recorder
public class AmazonClientApacheTransportRecorder
extends AbstractAmazonClientTransportRecorder {
    @Override
    public RuntimeValue<SdkHttpClient.Builder> configureSync(String clientName, RuntimeValue<SyncHttpClientConfig> syncConfigRuntime) {
        SyncHttpClientConfig syncConfig = (SyncHttpClientConfig)syncConfigRuntime.getValue();
        this.validateTlsKeyManagersProvider(clientName, syncConfig.tlsKeyManagersProvider, "sync");
        this.validateTlsTrustManagersProvider(clientName, syncConfig.tlsTrustManagersProvider, "sync");
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        this.validateApacheClientConfig(clientName, syncConfig);
        builder.connectionTimeout(syncConfig.connectionTimeout);
        builder.connectionAcquisitionTimeout(syncConfig.apache.connectionAcquisitionTimeout);
        builder.connectionMaxIdleTime(syncConfig.apache.connectionMaxIdleTime);
        syncConfig.apache.connectionTimeToLive.ifPresent(arg_0 -> ((ApacheHttpClient.Builder)builder).connectionTimeToLive(arg_0));
        builder.expectContinueEnabled(Boolean.valueOf(syncConfig.apache.expectContinueEnabled));
        builder.maxConnections(Integer.valueOf(syncConfig.apache.maxConnections));
        builder.socketTimeout(syncConfig.socketTimeout);
        builder.useIdleConnectionReaper(Boolean.valueOf(syncConfig.apache.useIdleConnectionReaper));
        builder.tcpKeepAlive(syncConfig.apache.tcpKeepAlive);
        if (syncConfig.apache.proxy.enabled && syncConfig.apache.proxy.endpoint.isPresent()) {
            ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder().endpoint(syncConfig.apache.proxy.endpoint.get());
            syncConfig.apache.proxy.username.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).username(arg_0));
            syncConfig.apache.proxy.password.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).password(arg_0));
            syncConfig.apache.proxy.nonProxyHosts.ifPresent(c -> c.forEach(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).addNonProxyHost(arg_0)));
            syncConfig.apache.proxy.ntlmDomain.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).ntlmDomain(arg_0));
            syncConfig.apache.proxy.ntlmWorkstation.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).ntlmWorkstation(arg_0));
            syncConfig.apache.proxy.preemptiveBasicAuthenticationEnabled.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).preemptiveBasicAuthenticationEnabled(arg_0));
            builder.proxyConfiguration((ProxyConfiguration)proxyBuilder.build());
        }
        builder.tlsKeyManagersProvider(this.getTlsKeyManagersProvider(syncConfig.tlsKeyManagersProvider));
        TlsTrustManagersProvider tlsTrustManagerProvider = this.getTlsTrustManagersProvider(syncConfig.tlsTrustManagersProvider);
        if (tlsTrustManagerProvider != null) {
            builder.tlsTrustManagersProvider(tlsTrustManagerProvider);
        }
        return new RuntimeValue((Object)builder);
    }

    private void validateApacheClientConfig(String extension, SyncHttpClientConfig config) {
        if (config.apache.maxConnections <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.sync-client.max-connections may not be negative or zero.", extension));
        }
        if (config.apache.proxy.enabled) {
            config.apache.proxy.endpoint.ifPresent(uri -> this.validateProxyEndpoint(extension, (URI)uri, "sync"));
        }
    }
}

