/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.AwsCredentialsProviderType;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

@ConfigGroup
public interface AwsCredentialsProviderConfig {
    @WithDefault(value="default")
    public AwsCredentialsProviderType type();

    @ConfigDocSection
    public DefaultCredentialsProviderConfig defaultProvider();

    @ConfigDocSection
    public StaticCredentialsProviderConfig staticProvider();

    @ConfigDocSection
    public ProfileCredentialsProviderConfig profileProvider();

    @ConfigDocSection
    public ProcessCredentialsProviderConfig processProvider();

    @ConfigDocSection
    public CustomCredentialsProviderConfig customProvider();

    @ConfigGroup
    public static interface CustomCredentialsProviderConfig {
        public Optional<String> name();
    }

    @ConfigGroup
    public static interface ProcessCredentialsProviderConfig {
        @WithDefault(value="false")
        public boolean asyncCredentialUpdateEnabled();

        @WithDefault(value="15S")
        @WithConverter(value=DurationConverter.class)
        public Duration credentialRefreshThreshold();

        @WithDefault(value="1024")
        @WithConverter(value=MemorySizeConverter.class)
        public MemorySize processOutputLimit();

        public Optional<List<String>> command();
    }

    @ConfigGroup
    public static interface ProfileCredentialsProviderConfig {
        public Optional<String> profileName();
    }

    @ConfigGroup
    public static interface StaticCredentialsProviderConfig {
        public Optional<String> accessKeyId();

        public Optional<String> secretAccessKey();

        public Optional<String> sessionToken();
    }

    @ConfigGroup
    public static interface DefaultCredentialsProviderConfig {
        @WithDefault(value="false")
        public boolean asyncCredentialUpdateEnabled();

        @WithDefault(value="true")
        public boolean reuseLastProviderEnabled();
    }
}

