/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.runtime.RuntimeValue;
import java.util.concurrent.Executor;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public abstract class AmazonClientRecorder {
    public abstract RuntimeValue<AwsConfig> getAwsConfig();

    public abstract RuntimeValue<SdkConfig> getSdkConfig();

    public abstract AsyncHttpClientConfig getAsyncClientConfig();

    public abstract SyncHttpClientConfig getSyncClientConfig();

    public abstract AwsSyncClientBuilder<?, ?> geSyncClientBuilder();

    public abstract AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder();

    public RuntimeValue<SyncHttpClientConfig> getSyncConfig() {
        return new RuntimeValue((Object)this.getSyncClientConfig());
    }

    public RuntimeValue<AsyncHttpClientConfig> getAsyncConfig() {
        return new RuntimeValue((Object)this.getAsyncClientConfig());
    }

    public RuntimeValue<AwsClientBuilder> createSyncBuilder(RuntimeValue<SdkHttpClient.Builder> transport) {
        AwsSyncClientBuilder<?, ?> builder = this.geSyncClientBuilder();
        if (transport != null) {
            builder.httpClientBuilder((SdkHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)((AwsClientBuilder)builder));
    }

    public RuntimeValue<AwsClientBuilder> createAsyncBuilder(RuntimeValue<SdkAsyncHttpClient.Builder> transport, Executor executor) {
        AwsAsyncClientBuilder<?, ?> builder = this.getAsyncClientBuilder();
        AsyncHttpClientConfig config = this.getAsyncClientConfig();
        if (transport != null) {
            builder.httpClientBuilder((SdkAsyncHttpClient.Builder)transport.getValue());
        }
        if (!config.advanced().useFutureCompletionThreadPool()) {
            builder.asyncConfiguration(asyncConfigBuilder -> asyncConfigBuilder.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, Runnable::run));
        } else {
            builder.asyncConfiguration(asyncConfigBuilder -> asyncConfigBuilder.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)executor));
        }
        return new RuntimeValue((Object)((AwsClientBuilder)builder));
    }

    public RuntimeValue<SdkPresigner.Builder> createPresignerBuilder() {
        throw new UnsupportedOperationException();
    }
}

