/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.netty.channel.EventLoopGroup;
import io.quarkiverse.amazon.common.runtime.AbstractAmazonClientTransportRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.Http2Configuration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@Recorder
public class AmazonClientNettyTransportRecorder
extends AbstractAmazonClientTransportRecorder {
    @Override
    public RuntimeValue<SdkAsyncHttpClient.Builder> configureAsync(String clientName, RuntimeValue<AsyncHttpClientConfig> asyncConfigRuntime) {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        AsyncHttpClientConfig asyncConfig = (AsyncHttpClientConfig)asyncConfigRuntime.getValue();
        this.validateNettyClientConfig(clientName, asyncConfig);
        builder.connectionAcquisitionTimeout(asyncConfig.connectionAcquisitionTimeout());
        builder.connectionMaxIdleTime(asyncConfig.connectionMaxIdleTime());
        builder.connectionTimeout(asyncConfig.connectionTimeout());
        asyncConfig.connectionTimeToLive().ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).connectionTimeToLive(arg_0));
        builder.maxConcurrency(Integer.valueOf(asyncConfig.maxConcurrency()));
        builder.maxPendingConnectionAcquires(Integer.valueOf(asyncConfig.maxPendingConnectionAcquires()));
        builder.protocol(asyncConfig.protocol());
        builder.readTimeout(asyncConfig.readTimeout());
        builder.writeTimeout(asyncConfig.writeTimeout());
        builder.tcpKeepAlive(asyncConfig.tcpKeepAlive());
        asyncConfig.sslProvider().map(AsyncHttpClientConfig.SslProviderType::create).ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).sslProvider(arg_0));
        builder.useIdleConnectionReaper(Boolean.valueOf(asyncConfig.useIdleConnectionReaper()));
        if (asyncConfig.http2().initialWindowSize().isPresent() || asyncConfig.http2().maxStreams().isPresent()) {
            Http2Configuration.Builder http2Builder = Http2Configuration.builder();
            asyncConfig.http2().initialWindowSize().ifPresent(arg_0 -> ((Http2Configuration.Builder)http2Builder).initialWindowSize(arg_0));
            asyncConfig.http2().maxStreams().ifPresent(arg_0 -> ((Http2Configuration.Builder)http2Builder).maxStreams(arg_0));
            asyncConfig.http2().healthCheckPingPeriod().ifPresent(arg_0 -> ((Http2Configuration.Builder)http2Builder).healthCheckPingPeriod(arg_0));
            builder.http2Configuration((Http2Configuration)http2Builder.build());
        }
        if (asyncConfig.proxy().enabled() && asyncConfig.proxy().endpoint().isPresent()) {
            ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder().scheme(asyncConfig.proxy().endpoint().get().getScheme()).host(asyncConfig.proxy().endpoint().get().getHost()).nonProxyHosts(new HashSet(asyncConfig.proxy().nonProxyHosts().orElse(Collections.emptyList())));
            if (asyncConfig.proxy().endpoint().get().getPort() != -1) {
                proxyBuilder.port(asyncConfig.proxy().endpoint().get().getPort());
            }
            builder.proxyConfiguration((ProxyConfiguration)proxyBuilder.build());
        }
        builder.tlsKeyManagersProvider(this.getTlsKeyManagersProvider(asyncConfig.tlsKeyManagersProvider()));
        TlsTrustManagersProvider tlsTrustManagerProvider = this.getTlsTrustManagersProvider(asyncConfig.tlsTrustManagersProvider());
        if (tlsTrustManagerProvider != null) {
            builder.tlsTrustManagersProvider(tlsTrustManagerProvider);
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<SdkAsyncHttpClient.Builder> configureNettyAsync(RuntimeValue<SdkAsyncHttpClient.Builder> builderRuntime, Supplier<EventLoopGroup> eventLoopSupplier, RuntimeValue<AsyncHttpClientConfig> asyncConfigRuntime) {
        AsyncHttpClientConfig asyncConfig = (AsyncHttpClientConfig)asyncConfigRuntime.getValue();
        NettyNioAsyncHttpClient.Builder builder = (NettyNioAsyncHttpClient.Builder)builderRuntime.getValue();
        if (asyncConfig.eventLoop().override()) {
            SdkEventLoopGroup.Builder eventLoopBuilder = SdkEventLoopGroup.builder();
            asyncConfig.eventLoop().numberOfThreads().ifPresent(arg_0 -> ((SdkEventLoopGroup.Builder)eventLoopBuilder).numberOfThreads(arg_0));
            if (asyncConfig.eventLoop().threadNamePrefix().isPresent()) {
                eventLoopBuilder.threadFactory(new ThreadFactoryBuilder().threadNamePrefix(asyncConfig.eventLoop().threadNamePrefix().get()).build());
            }
            builder.eventLoopGroupBuilder(eventLoopBuilder);
        } else {
            SdkEventLoopGroup eventLoopGroup = SdkEventLoopGroup.create((EventLoopGroup)eventLoopSupplier.get());
            builder.eventLoopGroup(eventLoopGroup);
        }
        return new RuntimeValue((Object)builder);
    }

    private void validateNettyClientConfig(String extension, AsyncHttpClientConfig config) {
        if (config.maxConcurrency() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.max-concurrency may not be negative or zero.", extension));
        }
        if (config.http2().maxStreams().isPresent() && config.http2().maxStreams().get() <= 0L) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.http2().max-streams may not be negative.", extension));
        }
        if (config.http2().initialWindowSize().isPresent() && config.http2().initialWindowSize().getAsInt() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.http2().initial-window-size may not be negative.", extension));
        }
        if (config.maxPendingConnectionAcquires() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.max-pending-connection-acquires may not be negative or zero.", extension));
        }
        if (config.eventLoop().override() && config.eventLoop().numberOfThreads().isPresent() && config.eventLoop().numberOfThreads().getAsInt() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.event-loop.number-of-threads may not be negative or zero.", extension));
        }
        if (config.proxy().enabled()) {
            config.proxy().endpoint().ifPresent(uri -> this.validateProxyEndpoint(extension, (URI)uri, "async"));
        }
        this.validateTlsKeyManagersProvider(extension, config.tlsKeyManagersProvider(), "async");
        this.validateTlsTrustManagersProvider(extension, config.tlsTrustManagersProvider(), "async");
    }
}

