/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.zip.Checksum;
import software.amazon.awssdk.core.internal.checksums.factory.SdkCrc32;
import software.amazon.awssdk.http.auth.aws.crt.internal.signer.DefaultAwsCrtV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.internal.scheme.DefaultAwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.aws.internal.signer.checksums.Crc32CChecksum;
import software.amazon.awssdk.http.auth.aws.internal.signer.checksums.Crc32Checksum;
import software.amazon.awssdk.http.auth.aws.internal.signer.checksums.SdkCrc32CChecksum;
import software.amazon.awssdk.http.auth.aws.internal.signer.checksums.SdkCrc32Checksum;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;

public class CrtSubstitutions {
    static final String SOFTWARE_AMAZON_AWSSDK_CRT_PACKAGE = "software.amazon.awssdk.crt";
    static final String SOFTWARE_AMAZON_AWSSDK_HTTP_AUTH_AWS_CRT_PACKAGE = "software.amazon.awssdk.http.auth.aws.crt";

    static class HttpAuthAwsCrtAbsentAwsV4aAuthScheme
    implements AwsV4aAuthScheme {
        private static final HttpAuthAwsCrtAbsentAwsV4aAuthScheme DEFAULT = new HttpAuthAwsCrtAbsentAwsV4aAuthScheme();

        HttpAuthAwsCrtAbsentAwsV4aAuthScheme() {
        }

        public static HttpAuthAwsCrtAbsentAwsV4aAuthScheme create() {
            return DEFAULT;
        }

        public String schemeId() {
            return "aws.auth#sigv4a";
        }

        public IdentityProvider<AwsCredentialsIdentity> identityProvider(IdentityProviders providers) {
            return providers.identityProvider(AwsCredentialsIdentity.class);
        }

        public AwsV4aHttpSigner signer() {
            return AwsV4aHttpSigner.create();
        }
    }

    @TargetClass(value=AwsV4aAuthScheme.class, onlyWith={IsHttpAuthAwsCrtAbsent.class})
    public static interface Target_AwsV4aAuthScheme {
        @Substitute
        public static AwsV4aAuthScheme create() {
            return HttpAuthAwsCrtAbsentAwsV4aAuthScheme.DEFAULT;
        }
    }

    @TargetClass(value=DefaultAwsV4aAuthScheme.class, onlyWith={IsCrtAbsent.class})
    @Delete
    final class Target_DefaultAwsV4aAuthScheme {
        Target_DefaultAwsV4aAuthScheme() {
        }
    }

    @TargetClass(value=AwsV4aHttpSigner.class, onlyWith={IsHttpAuthAwsCrtAbsent.class})
    public static interface Target_AwsV4aHttpSigner {
        @Substitute
        public static AwsV4aHttpSigner create() {
            throw new RuntimeException("You must add a dependency on the 'software.amazon.awssdk:http-auth-aws-crt' module to enable the CRT-V4a signing feature");
        }
    }

    @TargetClass(value=DefaultAwsCrtV4aHttpSigner.class, onlyWith={IsHttpAuthAwsCrtAbsent.class})
    @Delete
    final class Delete_DefaultAwsCrtV4aHttpSigner {
        Delete_DefaultAwsCrtV4aHttpSigner() {
        }
    }

    @TargetClass(value=software.amazon.awssdk.core.checksums.Crc32Checksum.class, onlyWith={IsCrtAbsent.class})
    static final class Target_Crc32Checksum {
        @Alias
        private Checksum crc32 = SdkCrc32.create();

        @Substitute
        public Target_Crc32Checksum() {
        }

        @Substitute
        private Checksum cloneChecksum(Checksum checksum) {
            return (Checksum)((SdkCrc32)checksum).clone();
        }
    }

    @TargetClass(value=Crc32Checksum.class, onlyWith={IsCrtAbsent.class})
    static final class Target_SignerCrc32Checksum {
        @Alias
        private Checksum crc32 = SdkCrc32Checksum.create();

        @Substitute
        public Target_SignerCrc32Checksum() {
        }

        @Substitute
        private Checksum cloneChecksum(Checksum checksum) {
            return ((SdkCrc32Checksum)checksum).clone();
        }
    }

    @TargetClass(value=Crc32CChecksum.class, onlyWith={IsCrtAbsent.class})
    static final class Target_SignerCrc32CChecksum {
        @Alias
        private Checksum crc32c = SdkCrc32CChecksum.create();

        @Substitute
        public Target_SignerCrc32CChecksum() {
        }

        @Substitute
        private Checksum cloneChecksum(Checksum checksum) {
            return ((SdkCrc32CChecksum)checksum).clone();
        }
    }

    static final class IsHttpAuthAwsCrtAbsent
    implements BooleanSupplier {
        IsHttpAuthAwsCrtAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(CrtSubstitutions.SOFTWARE_AMAZON_AWSSDK_HTTP_AUTH_AWS_CRT_PACKAGE));
        }
    }

    static final class IsCrtAbsent
    implements BooleanSupplier {
        IsCrtAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(CrtSubstitutions.SOFTWARE_AMAZON_AWSSDK_CRT_PACKAGE));
        }
    }
}

