/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkiverse.amazon.common.AmazonClientBuilder;
import io.quarkiverse.amazon.common.runtime.AmazonClientConfig;
import io.quarkiverse.amazon.common.runtime.AwsConfig;
import io.quarkiverse.amazon.common.runtime.ClientUtil;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkiverse.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.SdkConfig;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.builder.SdkBuilder;

@Recorder
public class AmazonClientCommonRecorder {
    private static final Log LOG = LogFactory.getLog(AmazonClientCommonRecorder.class);

    public RuntimeValue<AwsClientBuilder> configure(RuntimeValue<? extends AwsClientBuilder> clientBuilder, RuntimeValue<HasAmazonClientRuntimeConfig> amazonClientConfigRuntime, HasSdkBuildTimeConfig sdkBuildTimeConfig, ScheduledExecutorService scheduledExecutorService, String awsServiceName, String clientName) {
        AwsClientBuilder builder = (AwsClientBuilder)clientBuilder.getValue();
        AmazonClientConfig namedConfig = (AmazonClientConfig)((HasAmazonClientRuntimeConfig)amazonClientConfigRuntime.getValue()).clients().get(clientName);
        AmazonClientConfig defaultConfig = (AmazonClientConfig)((HasAmazonClientRuntimeConfig)amazonClientConfigRuntime.getValue()).clients().get("<default>");
        String namedExtension = ClientUtil.isDefaultClient((String)clientName) ? awsServiceName : awsServiceName + "." + clientName;
        this.initAwsClient(builder, awsServiceName, namedExtension, namedConfig.aws(), defaultConfig.aws());
        this.initSdkClient((SdkClientBuilder)builder, awsServiceName, namedExtension, namedConfig.sdk(), defaultConfig.sdk(), sdkBuildTimeConfig.sdk(), scheduledExecutorService);
        return new RuntimeValue((Object)builder);
    }

    public void initAwsClient(AwsClientBuilder builder, String extension, String namedExtension, AwsConfig namedConfig, AwsConfig defaultConfig) {
        namedConfig.region().or(() -> defaultConfig.region()).ifPresent(arg_0 -> ((AwsClientBuilder)builder).region(arg_0));
        AwsCredentialsProvider credential = namedConfig.credentials().map(c -> c.type().create(c, "quarkus." + namedExtension)).or(() -> defaultConfig.credentials().map(c -> c.type().create(c, "quarkus." + extension))).orElseGet(() -> DefaultCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(false)).reuseLastProviderEnabled(Boolean.valueOf(false)).build());
        builder.credentialsProvider(credential);
    }

    public void initSdkClient(SdkClientBuilder builder, String extension, String namedExtension, SdkConfig namedConfig, SdkConfig defaultConfig, SdkBuildTimeConfig buildConfig, ScheduledExecutorService scheduledExecutorService) {
        if (namedConfig.endpointOverride().isPresent()) {
            this.validEndpointOverride(namedExtension, (URI)namedConfig.endpointOverride().get());
        } else if (defaultConfig.endpointOverride().isPresent()) {
            this.validEndpointOverride(extension, (URI)defaultConfig.endpointOverride().get());
        }
        namedConfig.endpointOverride().filter(URI::isAbsolute).or(() -> defaultConfig.endpointOverride().filter(URI::isAbsolute)).ifPresent(arg_0 -> ((SdkClientBuilder)builder).endpointOverride(arg_0));
        ClientOverrideConfiguration.Builder overrides = ClientOverrideConfiguration.builder();
        if (namedConfig.advanced().useQuarkusScheduledExecutorService().or(() -> defaultConfig.advanced().useQuarkusScheduledExecutorService()).orElse(true).booleanValue()) {
            overrides.scheduledExecutorService(scheduledExecutorService);
        }
        namedConfig.apiCallTimeout().or(() -> defaultConfig.apiCallTimeout()).ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallTimeout(arg_0));
        namedConfig.apiCallAttemptTimeout().or(() -> defaultConfig.apiCallAttemptTimeout()).ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallAttemptTimeout(arg_0));
        buildConfig.interceptors().orElse(Collections.emptyList()).stream().map(String::trim).map(this::createInterceptor).filter(Objects::nonNull).forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).addExecutionInterceptor(arg_0));
        builder.overrideConfiguration((ClientOverrideConfiguration)overrides.build());
    }

    private void validEndpointOverride(String namedExtension, URI endpointOverride) {
        if (StringUtils.isBlank((CharSequence)endpointOverride.getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.endpoint-override (%s) - scheme must be specified", namedExtension, endpointOverride.toString()));
        }
    }

    public RuntimeValue<SdkPresigner.Builder> configurePresigner(RuntimeValue<? extends SdkPresigner.Builder> clientBuilder, RuntimeValue<HasAmazonClientRuntimeConfig> amazonClientConfigRuntime, String awsServiceName, String clientName) {
        SdkPresigner.Builder builder = (SdkPresigner.Builder)clientBuilder.getValue();
        AmazonClientConfig namedConfig = (AmazonClientConfig)((HasAmazonClientRuntimeConfig)amazonClientConfigRuntime.getValue()).clients().get(clientName);
        AmazonClientConfig defaultConfig = (AmazonClientConfig)((HasAmazonClientRuntimeConfig)amazonClientConfigRuntime.getValue()).clients().get("<default>");
        String namedExtension = ClientUtil.isDefaultClient((String)clientName) ? awsServiceName : awsServiceName + "." + clientName;
        this.initAwsPresigner(builder, awsServiceName, namedExtension, namedConfig.aws(), defaultConfig.aws());
        this.initSdkPresigner(builder, awsServiceName, namedExtension, namedConfig.sdk(), defaultConfig.sdk());
        return new RuntimeValue((Object)builder);
    }

    public void initAwsPresigner(SdkPresigner.Builder builder, String extension, String namedExtension, AwsConfig namedConfig, AwsConfig defaultConfig) {
        namedConfig.region().or(() -> defaultConfig.region()).ifPresent(arg_0 -> ((SdkPresigner.Builder)builder).region(arg_0));
        AwsCredentialsProvider credential = namedConfig.credentials().map(c -> c.type().create(c, "quarkus." + namedExtension)).or(() -> defaultConfig.credentials().map(c -> c.type().create(c, "quarkus." + extension))).orElseGet(() -> DefaultCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(false)).reuseLastProviderEnabled(Boolean.valueOf(false)).build());
        builder.credentialsProvider(credential);
    }

    public void initSdkPresigner(SdkPresigner.Builder builder, String extension, String namedExtension, SdkConfig namedConfig, SdkConfig defaultConfig) {
        if (namedConfig.endpointOverride().isPresent()) {
            this.validEndpointOverride(namedExtension, (URI)namedConfig.endpointOverride().get());
        } else if (defaultConfig.endpointOverride().isPresent()) {
            this.validEndpointOverride(extension, (URI)defaultConfig.endpointOverride().get());
        }
        namedConfig.endpointOverride().filter(URI::isAbsolute).or(() -> defaultConfig.endpointOverride().filter(URI::isAbsolute)).ifPresent(arg_0 -> ((SdkPresigner.Builder)builder).endpointOverride(arg_0));
    }

    private ExecutionInterceptor createInterceptor(String interceptorClassName) {
        try {
            Class<?> classObj = Thread.currentThread().getContextClassLoader().loadClass(interceptorClassName);
            try {
                return (ExecutionInterceptor)CDI.current().select(classObj, new Annotation[0]).get();
            }
            catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                return (ExecutionInterceptor)classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error((Object)("Unable to create interceptor " + interceptorClassName), (Throwable)e);
            return null;
        }
    }

    public Function<SyntheticCreationalContext<AwsClient>, AwsClient> build(final Class<?> clazz, final String clientName) {
        return new Function<SyntheticCreationalContext<AwsClient>, AwsClient>(){

            @Override
            public AwsClient apply(SyntheticCreationalContext<AwsClient> context) {
                SdkBuilder builder = ClientUtil.isDefaultClient((String)clientName) ? (SdkBuilder)context.getInjectedReference(clazz, new Annotation[0]) : (SdkBuilder)context.getInjectedReference(clazz, new Annotation[]{new AmazonClientBuilder.AmazonClientBuilderLiteral(clientName)});
                return (AwsClient)builder.build();
            }
        };
    }

    public Function<SyntheticCreationalContext<SdkPresigner>, SdkPresigner> buildPresigner(final Class<?> clazz, final String clientName) {
        return new Function<SyntheticCreationalContext<SdkPresigner>, SdkPresigner>(){

            @Override
            public SdkPresigner apply(SyntheticCreationalContext<SdkPresigner> context) {
                SdkPresigner.Builder builder = ClientUtil.isDefaultClient((String)clientName) ? (SdkPresigner.Builder)context.getInjectedReference(clazz, new Annotation[0]) : (SdkPresigner.Builder)context.getInjectedReference(clazz, new Annotation[]{new AmazonClientBuilder.AmazonClientBuilderLiteral(clientName)});
                return builder.build();
            }
        };
    }
}

