/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment.crt;

import io.quarkiverse.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientTransportBuilderBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;

public class AwsCrtTransportBuilderProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtSyncTransport(List<AmazonClientExtensionBuildItem> extensions, List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        extensions.forEach(extension -> this.createAwsCrtSyncTransportBuilder(extension.getConfigName(), amazonClients, transportRecorder, extension.getBuildSyncConfig(), (RuntimeValue<SyncHttpClientConfig>)extension.getSyncConfig(), syncTransports));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtAsyncTransport(List<AmazonClientExtensionBuildItem> extensions, List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        extensions.forEach(extension -> this.createAwsCrtAsyncTransportBuilder(extension.getConfigName(), amazonClients, transportRecorder, extension.getBuildAsyncConfig(), (RuntimeValue<AsyncHttpClientConfig>)extension.getAsyncConfig(), asyncTransports));
    }

    void createAwsCrtSyncTransportBuilder(String configName, List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(configName)).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.AWS_CRT) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), (DotName)client.getSyncClassName().get(), recorder.configureSync(configName, syncConfig)));
        });
    }

    void createAwsCrtAsyncTransportBuilder(String configName, List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientAwsCrtTransportRecorder recorder, AsyncHttpClientBuildTimeConfig buildAsyncConfig, RuntimeValue<AsyncHttpClientConfig> asyncConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> clientAsyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(configName)).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getAsyncClassName().isPresent()) {
                return;
            }
            if (buildAsyncConfig.type() != AsyncHttpClientBuildTimeConfig.AsyncClientType.AWS_CRT) {
                return;
            }
            clientAsyncTransports.produce((BuildItem)new AmazonClientAsyncTransportBuildItem(client.getAwsClientName(), (DotName)client.getAsyncClassName().get(), recorder.configureAsync(configName, asyncConfig)));
        });
    }
}

