/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkiverse.amazon.common.runtime.AbstractAmazonClientTransportRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.URI;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.crt.AwsCrtAsyncHttpClient;
import software.amazon.awssdk.http.crt.AwsCrtHttpClient;
import software.amazon.awssdk.http.crt.ProxyConfiguration;

@Recorder
public class AmazonClientAwsCrtTransportRecorder
extends AbstractAmazonClientTransportRecorder {
    public RuntimeValue<SdkAsyncHttpClient.Builder> configureAsync(String clientName, RuntimeValue<AsyncHttpClientConfig> asyncConfigRuntime) {
        AwsCrtAsyncHttpClient.Builder builder = AwsCrtAsyncHttpClient.builder();
        AsyncHttpClientConfig asyncConfig = (AsyncHttpClientConfig)asyncConfigRuntime.getValue();
        this.validateAwsCrtClientConfig(clientName, asyncConfig);
        builder.connectionMaxIdleTime(asyncConfig.connectionMaxIdleTime());
        builder.connectionTimeout(asyncConfig.connectionTimeout());
        builder.maxConcurrency(Integer.valueOf(asyncConfig.maxConcurrency()));
        if (asyncConfig.proxy().enabled() && asyncConfig.proxy().endpoint().isPresent()) {
            ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder().scheme(((URI)asyncConfig.proxy().endpoint().get()).getScheme()).host(((URI)asyncConfig.proxy().endpoint().get()).getHost());
            if (((URI)asyncConfig.proxy().endpoint().get()).getPort() != -1) {
                proxyBuilder.port(((URI)asyncConfig.proxy().endpoint().get()).getPort());
            }
            builder.proxyConfiguration(proxyBuilder.build());
        }
        return new RuntimeValue((Object)builder);
    }

    private void validateAwsCrtClientConfig(String extension, AsyncHttpClientConfig config) {
        if (config.maxConcurrency() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.max-concurrency may not be negative or zero.", extension));
        }
        if (config.proxy().enabled()) {
            config.proxy().endpoint().ifPresent(uri -> this.validateProxyEndpoint(extension, (URI)uri, "async"));
        }
    }

    public RuntimeValue<SdkHttpClient.Builder> configureSync(String clientName, RuntimeValue<SyncHttpClientConfig> syncConfigRuntime) {
        AwsCrtHttpClient.Builder builder = AwsCrtHttpClient.builder();
        SyncHttpClientConfig syncConfig = (SyncHttpClientConfig)syncConfigRuntime.getValue();
        this.validateAwsCrtClientConfig(clientName, syncConfig);
        builder.connectionTimeout(syncConfig.connectionTimeout());
        syncConfig.crt().connectionMaxIdleTime().ifPresent(arg_0 -> ((AwsCrtHttpClient.Builder)builder).connectionMaxIdleTime(arg_0));
        syncConfig.crt().maxConcurrency().ifPresent(arg_0 -> ((AwsCrtHttpClient.Builder)builder).maxConcurrency(arg_0));
        if (syncConfig.crt().proxy().enabled() && syncConfig.crt().proxy().endpoint().isPresent()) {
            ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder().scheme(((URI)syncConfig.crt().proxy().endpoint().get()).getScheme()).host(((URI)syncConfig.crt().proxy().endpoint().get()).getHost());
            if (((URI)syncConfig.crt().proxy().endpoint().get()).getPort() != -1) {
                proxyBuilder.port(((URI)syncConfig.crt().proxy().endpoint().get()).getPort());
            }
            syncConfig.crt().proxy().username().ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).username(arg_0));
            syncConfig.crt().proxy().password().ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).password(arg_0));
            builder.proxyConfiguration(proxyBuilder.build());
        }
        return new RuntimeValue((Object)builder);
    }

    private void validateAwsCrtClientConfig(String extension, SyncHttpClientConfig config) {
        config.crt().maxConcurrency().ifPresent(maxConcurrency -> {
            if (maxConcurrency <= 0) {
                throw new RuntimeConfigurationError(String.format("quarkus.%s.sync-client.crt.max-concurrency may not be negative or zero.", extension));
            }
        });
        if (config.crt().proxy().enabled()) {
            config.crt().proxy().endpoint().ifPresent(uri -> this.validateProxyEndpoint(extension, (URI)uri, "sync"));
        }
    }
}

