/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazonservices.aws.crt.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ExcludeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.CRT;

public class AwsCrtProcessor {
    private static final String CRT_LIB_NAME = "aws-crt-jni";
    static final String CRT_JAR_MATCH_REGEX = "aws-crt";
    static final String NATIVE_IMAGE_RESOURCE_CONFIG_MATCH_REGEX = "/META-INF/native-image/software\\.amazon\\.awssdk/crt/aws-crt/resource-config\\.json";

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        Stream.of("software.amazon.awssdk.crt.CRT", "software.amazon.awssdk.crt.CrtRuntimeException", "software.amazon.awssdk.crt.CrtResource", "software.amazon.awssdk.crt.Log", "software.amazon.awssdk.crt.io.Uri", "software.amazon.awssdk.crt.checksums.CRC32", "software.amazon.awssdk.crt.checksums.CRC32C").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void resources(BuildProducer<NativeImageResourceBuildItem> resource, NativeImageRunnerBuildItem nativeImageRunnerFactory, BuildProducer<ExcludeConfigBuildItem> nativeImageExclusions) {
        if (nativeImageRunnerFactory.isContainerBuild()) {
            String libraryName = "libaws-crt-jni.so";
            String dir = "linux/x86_64";
            String glibResourcePath = dir + "/glibc/" + libraryName;
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{glibResourcePath}));
        } else {
            String libraryName = System.mapLibraryName(CRT_LIB_NAME);
            String os = CRT.getOSIdentifier();
            String dir = os + "/" + CRT.getArchIdentifier() + "/" + CRT.getCRuntime((String)os);
            String libResourcePath = dir + "/" + libraryName;
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{libResourcePath}));
        }
        nativeImageExclusions.produce((BuildItem)new ExcludeConfigBuildItem(CRT_LIB_NAME, NATIVE_IMAGE_RESOURCE_CONFIG_MATCH_REGEX));
    }
}

