/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazonservices.aws.crt.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.CRT;

public class AwsCrtProcessor {
    private static final String CRT_LIB_NAME = "aws-crt-jni";

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        Stream.of("software.amazon.awssdk.crt.CRT", "software.amazon.awssdk.crt.CrtRuntimeException", "software.amazon.awssdk.crt.CrtResource", "software.amazon.awssdk.crt.Log").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void resources(BuildProducer<NativeImageResourceBuildItem> resource, NativeImageRunnerBuildItem nativeImageRunnerFactory) {
        if (nativeImageRunnerFactory.isContainerBuild()) {
            String libraryName = "libaws-crt-jni.so";
            String dir = "linux/x86_64";
            String glibResourcePath = dir + "/glibc/" + libraryName;
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{glibResourcePath}));
        } else {
            String libraryName = System.mapLibraryName(CRT_LIB_NAME);
            String os = CRT.getOSIdentifier();
            String dir = os + "/" + CRT.getArchIdentifier() + "/" + CRT.getCRuntime((String)os);
            String libResourcePath = dir + "/" + libraryName;
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{libResourcePath}));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerAwsCrtJniRuntimeAccessBuildItem(BuildProducer<JniRuntimeAccessBuildItem> jniRuntimeAccess, BuildProducer<JniRuntimeAccessMethodBuildItem> jniRuntimeAccessMethod, BuildProducer<JniRuntimeAccessFieldBuildItem> jniRuntimeAccessField) {
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Boolean", "<init>", new String[]{"boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Boolean", "booleanValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Boolean", "getBoolean", new String[]{"java.lang.String"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Integer", "<init>", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Integer", "intValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Long", "<init>", new String[]{"long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.Long", "longValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.String", "lastIndexOf", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.String", "substring", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.System", "getProperty", new String[]{"java.lang.String"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.lang.System", "setProperty", new String[]{"java.lang.String", "java.lang.String"}));
        jniRuntimeAccess.produce((BuildItem)new JniRuntimeAccessBuildItem(true, true, false, new String[]{"java.nio.Buffer"}));
        jniRuntimeAccess.produce((BuildItem)new JniRuntimeAccessBuildItem(true, true, false, new String[]{"java.nio.ByteBuffer"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.ArrayList", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.List", "add", new String[]{"java.lang.Object"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.List", "get", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.List", "size"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.concurrent.CompletableFuture", "complete", new String[]{"java.lang.Object"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.concurrent.CompletableFuture", "completeExceptionally", new String[]{"java.lang.Throwable"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("java.util.function.Predicate", "test", new String[]{"java.lang.Object"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.AsyncCallback", "onFailure", new String[]{"java.lang.Throwable"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.AsyncCallback", "onSuccess"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.AsyncCallback", "onSuccess", new String[]{"java.lang.Object"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.CRT", "testJniException", new String[]{"boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.CrtResource", "addRef"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.CrtResource", "close"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.CrtResource", "getNativeHandle"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.CrtResource", "releaseReferences"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.CrtRuntimeException", "<init>", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.CrtRuntimeException", "errorCode"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.SystemInfo$CpuInfo", "<init>", new String[]{"int", "boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.auth.credentials.Credentials", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.credentials.Credentials", "accessKeyId"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.credentials.Credentials", "secretAccessKey"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.credentials.Credentials", "sessionToken"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.auth.credentials.CredentialsProvider", "onGetCredentialsComplete", new String[]{"java.util.concurrent.CompletableFuture", "software.amazon.awssdk.crt.auth.credentials.Credentials"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.auth.credentials.CredentialsProvider", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.auth.credentials.DelegateCredentialsHandler", "getCredentials"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "algorithm"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "credentials"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "credentialsProvider"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "expirationInSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "omitSessionToken"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "region"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "service"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "shouldNormalizeUriPath"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "shouldSignHeader"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "signatureType"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "signedBodyHeader"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "signedBodyValue"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "time"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningConfig", "useDoubleUriEncode"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningResult", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningResult", "signature"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.auth.signing.AwsSigningResult", "signedRequest"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.cal.EccKeyPair", "<init>", new String[]{"long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ClientConnectionContinuationHandler", "onContinuationClosedShim"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ClientConnectionContinuationHandler", "onContinuationMessageShim", new String[]{"byte[]", "byte[]", "int", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ClientConnectionHandler", "onConnectionClosedShim", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ClientConnectionHandler", "onConnectionSetupShim", new String[]{"long", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ClientConnectionHandler", "onProtocolMessage", new String[]{"byte[]", "byte[]", "int", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.MessageFlushCallback", "onCallbackInvoked", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerConnection", "<init>", new String[]{"long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerConnectionContinuation", "<init>", new String[]{"long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerConnectionContinuationHandler", "onContinuationClosedShim"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerConnectionContinuationHandler", "onContinuationMessageShim", new String[]{"byte[]", "byte[]", "int", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerConnectionHandler", "onIncomingStream", new String[]{"software.amazon.awssdk.crt.eventstream.ServerConnectionContinuation", "byte[]"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerConnectionHandler", "onProtocolMessage", new String[]{"byte[]", "byte[]", "int", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerListener", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerListenerHandler", "onConnectionShutdownShim", new String[]{"software.amazon.awssdk.crt.eventstream.ServerConnection", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.eventstream.ServerListenerHandler", "onNewConnection", new String[]{"software.amazon.awssdk.crt.eventstream.ServerConnection", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.Http2Stream", "<init>", new String[]{"long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.Http2StreamManager", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpClientConnection", "onConnectionAcquired", new String[]{"java.util.concurrent.CompletableFuture", "long", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpClientConnectionManager", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpHeader", "<init>", new String[]{"byte[]", "byte[]"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpManagerMetrics", "<init>", new String[]{"long", "long", "long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getAuthorizationPassword"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getAuthorizationType"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getAuthorizationUsername"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getConnectionType"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getHost"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getPort"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions", "getTlsContext"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpProxyOptions$HttpProxyConnectionType", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpRequest", "<init>", new String[]{"java.nio.ByteBuffer", "software.amazon.awssdk.crt.http.HttpRequestBodyStream"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.http.HttpRequestBase", "bodyStream"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpRequestBodyStream", "getLength"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpRequestBodyStream", "resetPosition"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpRequestBodyStream", "sendRequestBody", new String[]{"java.nio.ByteBuffer"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpStream", "<init>", new String[]{"long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpStream$HttpStreamWriteChunkCompletionCallback", "onChunkCompleted", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter", "onResponseBody", new String[]{"software.amazon.awssdk.crt.http.HttpStreamBase", "java.nio.ByteBuffer"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter", "onResponseComplete", new String[]{"software.amazon.awssdk.crt.http.HttpStreamBase", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter", "onResponseHeaders", new String[]{"software.amazon.awssdk.crt.http.HttpStreamBase", "int", "int", "java.nio.ByteBuffer"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter", "onResponseHeadersDone", new String[]{"software.amazon.awssdk.crt.http.HttpStreamBase", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.ClientBootstrap", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "fileSize"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "isDirectory"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "isFile"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "isSymLink"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "path"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.DirectoryEntry", "relativePath"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.DirectoryTraversalHandler", "onDirectoryEntry", new String[]{"software.amazon.awssdk.crt.io.DirectoryEntry"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.EventLoopGroup", "onCleanupComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions", "backoffScaleFactorMS"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions", "eventLoopGroup"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions", "jitterMode"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions", "maxRetries"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions$JitterMode", "getValue"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions$JitterMode", "value"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.StandardRetryOptions", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.StandardRetryOptions", "backoffRetryOptions"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.StandardRetryOptions", "initialBucketCapacity"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextCustomKeyOperationOptions", "certificateFileContents"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextCustomKeyOperationOptions", "certificateFilePath"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextCustomKeyOperationOptions", "operationHandler"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "certificateFileContents"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "certificateFilePath"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "pkcs11Lib"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "privateKeyObjectLabel"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "slotId"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "tokenLabel"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.io.TlsContextPkcs11Options", "userPin"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.TlsKeyOperation", "<init>", new String[]{"long", "byte[]", "int", "int", "int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.TlsKeyOperation", "invokePerformOperation", new String[]{"software.amazon.awssdk.crt.io.TlsKeyOperationHandler", "software.amazon.awssdk.crt.io.TlsKeyOperation"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.io.TlsKeyOperationHandler", "performOperation", new String[]{"software.amazon.awssdk.crt.io.TlsKeyOperation"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onConnectionComplete", new String[]{"int", "boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onConnectionInterrupted", new String[]{"int", "software.amazon.awssdk.crt.AsyncCallback"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onConnectionResumed", new String[]{"boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onConnectionClosed"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onWebsocketHandshake", new String[]{"software.amazon.awssdk.crt.http.HttpRequest", "long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onConnectionSuccess", new String[]{"boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection", "onConnectionFailure", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnection$MessageHandler", "deliver", new String[]{"java.lang.String", "byte[]", "boolean", "int", "boolean"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnectionOperationStatistics", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnectionOperationStatistics", "incompleteOperationCount"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnectionOperationStatistics", "incompleteOperationSize"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnectionOperationStatistics", "unackedOperationCount"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt.MqttClientConnectionOperationStatistics", "unackedOperationSize"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt.MqttException", "<init>", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "onWebsocketHandshake", new String[]{"software.amazon.awssdk.crt.http.HttpRequest", "long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "setIsConnected", new String[]{"boolean"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "websocketHandshakeTransform"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOperationStatistics", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOperationStatistics", "incompleteOperationCount"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOperationStatistics", "incompleteOperationSize"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOperationStatistics", "unackedOperationCount"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOperationStatistics", "unackedOperationSize"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getBootstrap"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getExtendedValidationAndFlowControlOptions"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getOfflineQueueBehavior"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getRetryJitterMode"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getSessionBehavior"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getSocketOptions"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "getTlsContext"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "ackTimeoutSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "connackTimeoutMs"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "extendedValidationAndFlowControlOptions"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "hostName"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "httpProxyOptions"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "lifecycleEvents"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "maxReconnectDelayMs"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "minConnectedTimeToResetReconnectDelayMs"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "minReconnectDelayMs"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "offlineQueueBehavior"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "pingTimeoutMs"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "port"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "publishEvents"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "retryJitterMode"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "sessionBehavior"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions", "topicAliasingOptions"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$ClientOfflineQueueBehavior", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$ClientSessionBehavior", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$ExtendedValidationAndFlowControlOptions", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$LifecycleEvents", "onAttemptingConnect", new String[]{"software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "software.amazon.awssdk.crt.mqtt5.OnAttemptingConnectReturn"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$LifecycleEvents", "onConnectionFailure", new String[]{"software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "software.amazon.awssdk.crt.mqtt5.OnConnectionFailureReturn"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$LifecycleEvents", "onConnectionSuccess", new String[]{"software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "software.amazon.awssdk.crt.mqtt5.OnConnectionSuccessReturn"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$LifecycleEvents", "onDisconnection", new String[]{"software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "software.amazon.awssdk.crt.mqtt5.OnDisconnectionReturn"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$LifecycleEvents", "onStopped", new String[]{"software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "software.amazon.awssdk.crt.mqtt5.OnStoppedReturn"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.Mqtt5ClientOptions$PublishEvents", "onMessageReceived", new String[]{"software.amazon.awssdk.crt.mqtt5.Mqtt5Client", "software.amazon.awssdk.crt.mqtt5.PublishReturn"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "nativeSetQOS", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "assignedClientID"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "maximumPacketSizeToServer"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "maximumQOS"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "receiveMaximumFromServer"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "rejoinedSession"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "retainAvailable"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "serverKeepAlive"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "sessionExpiryInterval"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "sharedSubscriptionsAvailable"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "subscriptionIdentifiersAvailable"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "topicAliasMaximumToClient"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "topicAliasMaximumToServer"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.NegotiatedSettings", "wildcardSubscriptionsAvailable"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.OnAttemptingConnectReturn", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.OnConnectionFailureReturn", "<init>", new String[]{"int", "software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.OnConnectionSuccessReturn", "<init>", new String[]{"software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "software.amazon.awssdk.crt.mqtt5.NegotiatedSettings"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.OnDisconnectionReturn", "<init>", new String[]{"int", "software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.OnStoppedReturn", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.PublishResult", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.PublishResult", "<init>", new String[]{"software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.PublishReturn", "<init>", new String[]{"software.amazon.awssdk.crt.mqtt5.packets.PublishPacket"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.QOS", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.QOS", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "nativeAddMaximumQOS", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "nativeAddReasonCode", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "assignedClientIdentifier"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "maximumPacketSize"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "maximumQOS"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "reasonCode"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "reasonString"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "receiveMaximum"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "responseInformation"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "retainAvailable"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "serverKeepAlive"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "serverReference"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "sessionExpiryIntervalSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "sessionPresent"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "sharedSubscriptionsAvailable"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "subscriptionIdentifiersAvailable"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "topicAliasMaximum"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "userProperties"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket", "wildcardSubscriptionsAvailable"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket$ConnectReasonCode", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnAckPacket$ConnectReasonCode", "getValue"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "clientId"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "keepAliveIntervalSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "maximumPacketSizeBytes"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "password"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "receiveMaximum"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "requestProblemInformation"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "requestResponseInformation"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "sessionExpiryIntervalSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "userProperties"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "username"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "will"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket", "willDelayIntervalSeconds"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "getReasonCode"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "nativeAddDisconnectReasonCode", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "reasonCode"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "reasonString"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "serverReference"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "sessionExpiryIntervalSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket$DisconnectReasonCode", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.DisconnectPacket$DisconnectReasonCode", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket", "nativeAddReasonCode", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket", "reasonCode"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket", "reasonString"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket$PubAckReasonCode", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket$PubAckReasonCode", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "getPayloadFormat"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "getQOS"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "nativeSetPayloadFormatIndicator", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "nativeSetQOS", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "contentType"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "correlationData"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "messageExpiryIntervalSeconds"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "packetQOS"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "payload"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "payloadFormat"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "responseTopic"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "retain"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "topicAlias"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "subscriptionIdentifiers"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "topic"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket$PayloadFormatIndicator", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.PublishPacket$PayloadFormatIndicator", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket", "nativeAddSubackCode", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket", "reasonCodes"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket", "reasonString"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket$SubAckReasonCode", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubAckPacket$SubAckReasonCode", "getValue"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket", "subscriptionIdentifier"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket", "subscriptions"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$RetainHandlingType", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "getNoLocal"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "getQOS"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "getRetainAsPublished"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "getRetainHandlingType"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "getTopicFilter"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "noLocal"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.SubscribePacket$Subscription", "retainAsPublished"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket", "<init>"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket", "nativeAddUnsubackCode", new String[]{"int"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket", "reasonCodes"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket", "reasonString"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket$UnsubAckReasonCode", "getEnumValueFromInteger", new String[]{"int"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubAckPacket$UnsubAckReasonCode", "getValue"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubscribePacket", "subscriptions"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UnsubscribePacket", "userProperties"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UserProperty", "<init>", new String[]{"java.lang.String", "java.lang.String"}));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions", "outboundBehavior"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions", "outboundCacheMaxSize"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions", "inboundBehavior"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions", "inboundCacheMaxSize"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions$OutboundTopicAliasBehaviorType", "getValue"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions$InboundTopicAliasBehaviorType", "getValue"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UserProperty", "key"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.mqtt5.packets.UserProperty", "value"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.ResumeToken", "nativeType"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.ResumeToken", "numPartsCompleted"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.ResumeToken", "partSize"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.ResumeToken", "totalNumParts"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.ResumeToken", "uploadId"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3Client", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequest", "onShutdownComplete"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestProgress", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestProgress", "bytesTransferred"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestProgress", "contentLength"));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter", "onFinished", new String[]{"int", "int", "byte[]", "int", "boolean", "java.lang.Throwable"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter", "onProgress", new String[]{"software.amazon.awssdk.crt.s3.S3MetaRequestProgress"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter", "onResponseBody", new String[]{"byte[]", "long", "long"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter", "onResponseHeaders", new String[]{"int", "java.nio.ByteBuffer"}));
        jniRuntimeAccessMethod.produce((BuildItem)new JniRuntimeAccessMethodBuildItem("software.amazon.awssdk.crt.s3.S3TcpKeepAliveOptions", "<init>"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.S3TcpKeepAliveOptions", "keepAliveIntervalSec"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.S3TcpKeepAliveOptions", "keepAliveMaxFailedProbes"));
        jniRuntimeAccessField.produce((BuildItem)new JniRuntimeAccessFieldBuildItem("software.amazon.awssdk.crt.s3.S3TcpKeepAliveOptions", "keepAliveTimeoutSec"));
    }
}

