/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.devservices.cognitouserpools;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MotoContainer
extends GenericContainer<MotoContainer> {
    static final int PORT = 5000;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"motoserver/moto");

    public MotoContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"^ \\* Running on.*\\n", (int)1));
        this.withExposedPorts(new Integer[]{5000});
    }

    public URI getEndpointOverride() {
        try {
            String address;
            String ipAddress = address = this.getHost();
            ipAddress = InetAddress.getByName(address).getHostAddress();
            return new URI("http://" + ipAddress + ":" + this.getMappedPort(5000));
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new IllegalStateException("Cannot obtain endpoint URL", e);
        }
    }
}

