/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.devservices.cognitouserpools;

import io.quarkiverse.amazon.cognitouserpools.runtime.CognitoUserPoolsBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.AwsCredentialsProviderType;
import io.quarkiverse.amazon.common.runtime.MotoDevServicesBuildTimeConfig;
import io.quarkiverse.amazon.devservices.cognitouserpools.MotoContainer;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.testcontainers.utility.DockerImageName;

public class CognitoUserPoolsDevServicesProcessor {
    private static final Logger log = Logger.getLogger(CognitoUserPoolsDevServicesProcessor.class);
    static volatile DevServicesResultBuildItem.RunningDevService devServices;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    DevServicesResultBuildItem setupCognitoUserPools(CognitoUserPoolsBuildTimeConfig clientBuildTimeConfig, MotoDevServicesBuildTimeConfig motoDevServicesBuildTimeConfig, DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        if (devServices != null) {
            return devServices.toBuildItem();
        }
        if (!clientBuildTimeConfig.devservices().enabled().orElse(true).booleanValue()) {
            log.debugf("Not starting Dev Services for Amazon Services - cognito user pools, as it has been disabled in the config.", new Object[0]);
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)"quarkus.cognito-user-pools.endpoint-override")) {
            log.debugf("Not starting Dev Services for Amazon Services - cognito user pools, the quarkus.cognito-user-pools.endpoint-override is configured.", new Object[0]);
            return null;
        }
        devServices = this.startMoto(dockerStatusBuildItem, launchMode.getLaunchMode(), motoDevServicesBuildTimeConfig, consoleInstalledBuildItem, loggingSetupBuildItem);
        return devServices.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startMoto(DockerStatusBuildItem dockerStatusBuildItem, LaunchMode launchMode, MotoDevServicesBuildTimeConfig motoDevServicesBuildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        String containerFriendlyName = "cognito user pools";
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode == LaunchMode.TEST ? "(test) " : "") + "Amazon Dev Services for cognito" + containerFriendlyName + " starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            MotoContainer container = (MotoContainer)new MotoContainer(DockerImageName.parse((String)motoDevServicesBuildTimeConfig.imageName())).withEnv(motoDevServicesBuildTimeConfig.containerProperties());
            container.start();
            compressor.close();
            log.info((Object)("Amazon Dev Services for " + containerFriendlyName + " started."));
            return new DevServicesResultBuildItem.RunningDevService(containerFriendlyName, container.getContainerId(), () -> ((MotoContainer)container).close(), Map.of("quarkus.cognito-user-pools.endpoint-override", container.getEndpointOverride().toString(), "quarkus.cognito-user-pools.aws.region", "us-east-1", "quarkus.cognito-user-pools.aws.credentials.type", AwsCredentialsProviderType.STATIC.name(), "quarkus.cognito-user-pools.aws.credentials.static-provider.access-key-id", "testing", "quarkus.cognito-user-pools.aws.credentials.static-provider.secret-access-key", "testing"));
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
    }
}

