/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.devservices.s3;

import io.quarkus.amazon.common.deployment.spi.AbstractDevServicesLocalStackProcessor;
import io.quarkus.amazon.common.deployment.spi.DevServicesLocalStackProviderBuildItem;
import io.quarkus.amazon.common.deployment.spi.LocalStackDevServicesBaseConfig;
import io.quarkus.amazon.common.runtime.DevServicesBuildTimeConfig;
import io.quarkus.amazon.s3.runtime.S3BuildTimeConfig;
import io.quarkus.amazon.s3.runtime.S3DevServicesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.Objects;
import java.util.Set;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public class S3DevServicesProcessor
extends AbstractDevServicesLocalStackProcessor {
    @BuildStep
    DevServicesLocalStackProviderBuildItem setupS3(S3BuildTimeConfig clientBuildTimeConfig) {
        return this.setup((LocalStackContainer.EnabledService)LocalStackContainer.Service.S3, (DevServicesBuildTimeConfig)clientBuildTimeConfig.devservices);
    }

    protected void prepareLocalStack(DevServicesBuildTimeConfig clientBuildTimeConfig, LocalStackContainer localstack) {
        this.createBuckets(localstack, this.getConfiguration((S3DevServicesBuildTimeConfig)clientBuildTimeConfig));
    }

    public void createBuckets(LocalStackContainer localstack, S3DevServiceCfg configuration) {
        try (S3Client client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.S3))).region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey())))).build();){
            for (String i : configuration.buckets) {
                client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(i).build());
            }
        }
    }

    private S3DevServiceCfg getConfiguration(S3DevServicesBuildTimeConfig devServicesConfig) {
        return new S3DevServiceCfg(devServicesConfig);
    }

    private static final class S3DevServiceCfg
    extends LocalStackDevServicesBaseConfig {
        private final Set<String> buckets;

        public S3DevServiceCfg(S3DevServicesBuildTimeConfig config) {
            super(config.shared, config.serviceName, config.containerProperties);
            this.buckets = config.buckets;
        }

        public boolean equals(Object o) {
            return super.equals(o) && Objects.equals(this.buckets, ((S3DevServiceCfg)((Object)o)).buckets);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.buckets);
        }
    }
}

