/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.devservices.sqs;

import io.quarkus.amazon.common.deployment.spi.AbstractDevServicesLocalStackProcessor;
import io.quarkus.amazon.common.deployment.spi.DevServicesLocalStackProviderBuildItem;
import io.quarkus.amazon.common.deployment.spi.LocalStackDevServicesBaseConfig;
import io.quarkus.amazon.common.runtime.DevServicesBuildTimeConfig;
import io.quarkus.amazon.sqs.runtime.SqsBuildTimeConfig;
import io.quarkus.amazon.sqs.runtime.SqsDevServicesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class SqsDevServicesProcessor
extends AbstractDevServicesLocalStackProcessor {
    @BuildStep
    DevServicesLocalStackProviderBuildItem setupSqs(SqsBuildTimeConfig clientBuildTimeConfig) {
        return this.setup((LocalStackContainer.EnabledService)LocalStackContainer.Service.SQS, (DevServicesBuildTimeConfig)clientBuildTimeConfig.devservices());
    }

    protected void prepareLocalStack(DevServicesBuildTimeConfig clientBuildTimeConfig, LocalStackContainer localstack) {
        this.createQueues(localstack, this.getConfiguration((SqsDevServicesBuildTimeConfig)clientBuildTimeConfig));
    }

    public void createQueues(LocalStackContainer localstack, SqsDevServiceCfg configuration) {
        try (SqsClient client = (SqsClient)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.SQS))).region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey())))).httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).build();){
            for (String queueName : configuration.queues) {
                client.createQueue(b -> b.queueName(queueName));
            }
        }
    }

    private SqsDevServiceCfg getConfiguration(SqsDevServicesBuildTimeConfig devServicesConfig) {
        return new SqsDevServiceCfg(devServicesConfig);
    }

    private static final class SqsDevServiceCfg
    extends LocalStackDevServicesBaseConfig {
        private final Set<String> queues;

        public SqsDevServiceCfg(SqsDevServicesBuildTimeConfig config) {
            super(config.shared(), config.isolated(), config.serviceName(), config.containerProperties());
            this.queues = new HashSet<String>(config.queues().orElse(Collections.emptyList()));
        }

        public boolean equals(Object o) {
            return super.equals(o) && Objects.equals(this.queues, ((SqsDevServiceCfg)((Object)o)).queues);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.queues);
        }
    }
}

