/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.enhanced.deployment;

import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.dynamodb.enhanced.deployment.DotNames;
import io.quarkus.amazon.dynamodb.enhanced.deployment.DynamodbEnhancedBeanBuildItem;
import io.quarkus.amazon.dynamodb.enhanced.runtime.BeanTableSchemaSubstitutionImplementation;
import io.quarkus.amazon.dynamodb.enhanced.runtime.DynamoDbEnhancedBuildTimeConfig;
import io.quarkus.amazon.dynamodb.enhanced.runtime.DynamodbEnhancedClientRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import software.amazon.awssdk.enhanced.dynamodb.DefaultAttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.AutoGeneratedTimestampRecordAttributeTags;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.VersionRecordAttributeTags;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeGetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeSetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanTableSchemaAttributeTags;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ObjectConstructor;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ObjectGetterMethod;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticGetterMethod;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public class DynamodbEnhancedProcessor {
    private static final String FEATURE = "amazon-dynamodb-enhanced";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{DynamoDbEnhancedClient.class, DynamoDbEnhancedAsyncClient.class}).setUnremovable().setDefaultScope(io.quarkus.arc.processor.DotNames.APPLICATION_SCOPED).build();
    }

    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndexBuildItem, DynamoDbEnhancedBuildTimeConfig buildTimeConfig, BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        Optional<Object> syncClassName = Optional.empty();
        Optional<Object> asyncClassName = Optional.empty();
        List knownDynamodbEnhancedClientExtensionImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotNames.DYNAMODB_ENHANCED_CLIENT_EXTENSION_NAME).stream().map(c -> c.name().toString()).collect(Collectors.toList());
        Optional extensions = buildTimeConfig.clientExtensions();
        if (extensions != null && extensions.isPresent()) {
            for (String extension : (List)extensions.get()) {
                if (knownDynamodbEnhancedClientExtensionImpls.contains(extension)) continue;
                throw new ConfigurationException("quarkus.dynamodbenhanced.client-extensions - must list only existing implementations of software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension");
            }
        }
        for (InjectionPointInfo injectionPoint : beanRegistrationPhase.getInjectionPoints()) {
            org.jboss.jandex.Type injectedType = injectionPoint.getRequiredType();
            if (DotNames.DYNAMODB_ENHANCED_CLIENT.equals((Object)injectedType.name())) {
                syncClassName = Optional.of(DotNames.DYNAMODB_CLIENT);
            }
            if (!DotNames.DYNAMODB_ENHANCED_ASYNC_CLIENT.equals((Object)injectedType.name())) continue;
            asyncClassName = Optional.of(DotNames.DYNAMODB_ASYNC_CLIENT);
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            requireClientProducer.produce((BuildItem)new RequireAmazonClientBuildItem(syncClassName, asyncClassName));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createClientBuilders(DynamodbEnhancedClientRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBean, List<AmazonClientSyncResultBuildItem> syncBuilder, List<AmazonClientAsyncResultBuildItem> asyncBuilder) {
        String configName = "dynamodb";
        Optional<AmazonClientSyncResultBuildItem> syncClientRuntime = syncBuilder.stream().filter(c -> configName.equals(c.getAwsClientName())).findFirst();
        Optional<AmazonClientAsyncResultBuildItem> asyncClientRuntime = asyncBuilder.stream().filter(c -> configName.equals(c.getAwsClientName())).findFirst();
        if (syncClientRuntime != null || asyncClientRuntime != null) {
            RuntimeValue extensions = recorder.createExtensionList();
            if (syncClientRuntime != null) {
                syntheticBean.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DynamoDbEnhancedClient.class).defaultBean()).scope(ApplicationScoped.class)).setRuntimeInit().createWith(recorder.createDynamoDbEnhancedClient(extensions)).addInjectionPoint((org.jboss.jandex.Type)ClassType.create(DynamoDbClient.class), new AnnotationInstance[0])).done());
            }
            if (asyncClientRuntime != null) {
                syntheticBean.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DynamoDbEnhancedAsyncClient.class).defaultBean()).scope(ApplicationScoped.class)).setRuntimeInit().createWith(recorder.createDynamoDbEnhancedAsyncClient(extensions)).addInjectionPoint((org.jboss.jandex.Type)ClassType.create(DynamoDbAsyncClient.class), new AnnotationInstance[0])).done());
            }
        }
    }

    @BuildStep
    public void discoverDynamoDbBeans(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<DynamodbEnhancedBeanBuildItem> dynamodbEnhancedBeanBuildItems) {
        ClassInfo beanClassInfo;
        IndexView index = combinedIndexBuildItem.getIndex();
        for (AnnotationInstance annotationInstance : index.getAnnotations(DotNames.DYNAMODB_ENHANCED_BEAN)) {
            beanClassInfo = annotationInstance.target().asClass();
            dynamodbEnhancedBeanBuildItems.produce((BuildItem)new DynamodbEnhancedBeanBuildItem(beanClassInfo.name()));
        }
        for (AnnotationInstance annotationInstance : index.getAnnotations(DotNames.DYNAMODB_ENHANCED_IMMUTABLE)) {
            beanClassInfo = annotationInstance.target().asClass();
            dynamodbEnhancedBeanBuildItems.produce((BuildItem)new DynamodbEnhancedBeanBuildItem(beanClassInfo.name()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void recordTableSchema(DynamoDbEnhancedBuildTimeConfig config, DynamodbEnhancedClientRecorder recorder, List<DynamodbEnhancedBeanBuildItem> dynamodbEnhancedBeanBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (!config.createTableSchemas()) {
            return;
        }
        ArrayList tableSchemaClasses = new ArrayList();
        for (DynamodbEnhancedBeanBuildItem dynamodbEnhancedBeanBuildItem : dynamodbEnhancedBeanBuildItems) {
            try {
                tableSchemaClasses.add(Class.forName(dynamodbEnhancedBeanBuildItem.getClassName().toString(), false, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        recorder.createTableSchema(tableSchemaClasses);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    public void registerClassesForReflectiveAccess(List<DynamodbEnhancedBeanBuildItem> dynamodbEnhancedBeanBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (DynamodbEnhancedBeanBuildItem dynamodbEnhancedBeanBuildItem : dynamodbEnhancedBeanBuildItems) {
            this.registerInstance(reflectiveClass, dynamodbEnhancedBeanBuildItem.getClassName());
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DefaultAttributeConverterProvider.class, BeanTableSchemaAttributeTags.class, AutoGeneratedTimestampRecordAttributeTags.class, VersionRecordAttributeTags.class}).methods().build());
    }

    private void registerInstance(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, DotName className) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className.toString()}).methods().build());
    }

    @BuildStep
    private void applyClassTransformation(BuildProducer<BytecodeTransformerBuildItem> transformers) {
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(ObjectGetterMethod.class.getName(), (BiFunction)new LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor(ObjectGetterMethod.class.getSimpleName(), 2)));
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(BeanAttributeGetter.class.getName(), (BiFunction)new LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor(BeanAttributeGetter.class.getSimpleName(), 2)));
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(BeanAttributeSetter.class.getName(), (BiFunction)new LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor(BeanAttributeSetter.class.getSimpleName(), 2)));
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(ObjectConstructor.class.getName(), (BiFunction)new LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor(ObjectConstructor.class.getSimpleName(), 2)));
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(StaticGetterMethod.class.getName(), (BiFunction)new LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor(StaticGetterMethod.class.getSimpleName(), 1)));
    }

    private static class LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        public static final String TARGET_METHOD_OWNER = BeanTableSchemaSubstitutionImplementation.class.getName().replace('.', '/');
        private String creatorName;
        private int numArgs;

        public LambdaToMethodBridgeBuilderCreatorCreateMethodCallRedirectionVisitor(String creatorName, int numArgs) {
            this.creatorName = creatorName;
            this.numArgs = numArgs;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
            return new ClassVisitor(589824, outputClassVisitor){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor originalMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if (name.equals("create")) {
                        return new ReplaceMethodBody(originalMethodVisitor, this.getMaxLocals(descriptor), visitor -> {
                            visitor.visitCode();
                            for (int i = 0; i < numArgs; ++i) {
                                visitor.visitVarInsn(25, i);
                            }
                            Type type = Type.getType((String)descriptor);
                            visitor.visitMethodInsn(184, TARGET_METHOD_OWNER, creatorName + "_" + name, type.getDescriptor(), false);
                            visitor.visitInsn(176);
                        });
                    }
                    return originalMethodVisitor;
                }

                private int getMaxLocals(String descriptor) {
                    return (Type.getArgumentsAndReturnSizes((String)descriptor) >> 2) - 1;
                }
            };
        }
    }

    private static class ReplaceMethodBody
    extends MethodVisitor {
        private final MethodVisitor targetWriter;
        private final int newMaxLocals;
        private final Consumer<MethodVisitor> code;

        public ReplaceMethodBody(MethodVisitor writer, int newMaxL, Consumer<MethodVisitor> methodCode) {
            super(327680);
            this.targetWriter = writer;
            this.newMaxLocals = newMaxL;
            this.code = methodCode;
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.targetWriter.visitMaxs(0, this.newMaxLocals);
        }

        public void visitCode() {
            this.code.accept(this.targetWriter);
        }

        public void visitEnd() {
            this.targetWriter.visitEnd();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.targetWriter.visitAnnotation(desc, visible);
        }

        public void visitParameter(String name, int access) {
            this.targetWriter.visitParameter(name, access);
        }
    }
}

