/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.dynamodb.enhanced.deployment;

import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.dynamodb.enhanced.deployment.DotNames;
import io.quarkiverse.amazon.dynamodb.enhanced.deployment.DynamodbEnhancedTableBuildItem;
import io.quarkiverse.amazon.dynamodb.enhanced.runtime.NamedDynamoDbTable;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;

public class DynamodbEnhancedDbTableProcessor {
    public static final MethodDescriptor CREATION_CONTEXT_GET_INJECTED_REFERENCE_METHOD = MethodDescriptor.ofMethod(SyntheticCreationalContext.class, (String)"getInjectedReference", Object.class, (Class[])new Class[]{Class.class, Annotation[].class});
    public static final MethodDescriptor TABLE_SCHEMA_FROM_CLASS_METHOD = MethodDescriptor.ofMethod(TableSchema.class, (String)"fromClass", TableSchema.class, (Class[])new Class[]{Class.class});
    public static final MethodDescriptor DYNAMODB_ENHANCED_CLIENT_TABLE_METHOD = MethodDescriptor.ofMethod(DynamoDbEnhancedClient.class, (String)"table", DynamoDbTable.class, (Class[])new Class[]{String.class, TableSchema.class});
    public static final MethodDescriptor DYNAMODB_ENHANCED_ASYNC_CLIENT_TABLE_METHOD = MethodDescriptor.ofMethod(DynamoDbEnhancedAsyncClient.class, (String)"table", DynamoDbAsyncTable.class, (Class[])new Class[]{String.class, TableSchema.class});

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return new AdditionalBeanBuildItem(new Class[]{NamedDynamoDbTable.class});
    }

    @BuildStep
    void discoverDynamoDbTable(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<DynamodbEnhancedTableBuildItem> tables) {
        HashSet<Map.Entry<String, DotName>> asyncSeen = new HashSet<Map.Entry<String, DotName>>();
        HashSet<Map.Entry<String, DotName>> syncSeen = new HashSet<Map.Entry<String, DotName>>();
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection ais = index.getAnnotations(DotNames.DYNAMODB_NAMED_TABLE);
        for (AnnotationInstance ano : ais) {
            MethodParameterInfo mpi;
            String tableName = ano.value().asString();
            Type targetType = null;
            if (ano.target().kind().equals((Object)AnnotationTarget.Kind.FIELD)) {
                targetType = ano.target().asField().type();
            } else if (ano.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) && (mpi = ano.target().asMethodParameter()).method().isConstructor()) {
                targetType = mpi.type();
            }
            if (targetType == null) continue;
            DotName beanClassName = ((Type)targetType.asParameterizedType().arguments().get(0)).name();
            DotName dbTableClassName = targetType.name();
            ClassInfo beanClass = index.getClassByName(beanClassName);
            if (beanClass == null) {
                throw new DeploymentException(String.format("'%s' is not in the Jandex index", beanClassName));
            }
            if (beanClass.annotation(DotNames.DYNAMODB_ENHANCED_BEAN) == null && beanClass.annotation(DotNames.DYNAMODB_ENHANCED_IMMUTABLE) == null) {
                throw new DeploymentException(String.format("'%s' must be bean annotated with @DynamoDbBean or @DynamoDbImmutable", beanClassName));
            }
            if (DotNames.DYNAMODB_TABLE.equals((Object)dbTableClassName) && syncSeen.add(Map.entry(tableName, beanClassName))) {
                tables.produce((BuildItem)new DynamodbEnhancedTableBuildItem(tableName, beanClassName, DotNames.DYNAMODB_ENHANCED_CLIENT, DYNAMODB_ENHANCED_CLIENT_TABLE_METHOD, DotNames.DYNAMODB_TABLE));
            }
            if (!DotNames.DYNAMODB_ASYNC_TABLE.equals((Object)dbTableClassName) || !asyncSeen.add(Map.entry(tableName, beanClassName))) continue;
            tables.produce((BuildItem)new DynamodbEnhancedTableBuildItem(tableName, beanClassName, DotNames.DYNAMODB_ENHANCED_ASYNC_CLIENT, DYNAMODB_ENHANCED_ASYNC_CLIENT_TABLE_METHOD, DotNames.DYNAMODB_ASYNC_TABLE));
        }
    }

    @BuildStep
    public void produceNamedDbTableBean(List<DynamodbEnhancedTableBuildItem> tables, BuildProducer<RequireAmazonClientInjectionBuildItem> requireClientInjectionProducer, BuildProducer<SyntheticBeanBuildItem> syntheticBean) {
        tables.stream().map(DynamodbEnhancedDbTableProcessor::generateDynamoDbTableSyntheticBean).forEach(arg_0 -> syntheticBean.produce(arg_0));
        tables.stream().map(table -> new RequireAmazonClientInjectionBuildItem(table.getClientClassName(), "<default>")).forEach(arg_0 -> requireClientInjectionProducer.produce(arg_0));
        tables.stream().map(table -> new RequireAmazonClientInjectionBuildItem(this.getLowLevelClientClassName(table.getClientClassName()), "<default>")).forEach(arg_0 -> requireClientInjectionProducer.produce(arg_0));
    }

    public DotName getLowLevelClientClassName(DotName enhancedClientClassName) {
        if (DotNames.DYNAMODB_ENHANCED_CLIENT.equals((Object)enhancedClientClassName)) {
            return DotNames.DYNAMODB_CLIENT;
        }
        return DotNames.DYNAMODB_ASYNC_CLIENT;
    }

    private static SyntheticBeanBuildItem generateDynamoDbTableSyntheticBean(DynamodbEnhancedTableBuildItem table) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)table.getTableClassName()).addType((Type)ParameterizedType.builder((DotName)table.getTableClassName()).addArgument((Type)ClassType.create((DotName)table.getBeanClassName())).build())).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{AnnotationInstance.builder(NamedDynamoDbTable.class).value(table.getTableName()).build()})).unremovable()).creator(methodCreator -> DynamodbEnhancedDbTableProcessor.generateDynamoDbTableSyncTableProducerMethod(methodCreator, table))).addInjectionPoint((Type)ClassType.create((DotName)table.getClientClassName()), new AnnotationInstance[0])).done();
    }

    private static void generateDynamoDbTableSyncTableProducerMethod(MethodCreator methodCreator, DynamodbEnhancedTableBuildItem table) {
        ResultHandle dynamoEnhancedClientHandle = methodCreator.invokeInterfaceMethod(CREATION_CONTEXT_GET_INJECTED_REFERENCE_METHOD, methodCreator.getMethodParam(0), new ResultHandle[]{methodCreator.loadClass(table.getClientClassName().toString()), methodCreator.newArray(Annotation.class, 0)});
        ResultHandle tableNameHandler = methodCreator.load(table.getTableName());
        ResultHandle beanClassHandler = methodCreator.loadClassFromTCCL(table.getBeanClassName().toString());
        ResultHandle tableSchemaHandle = methodCreator.invokeStaticInterfaceMethod(TABLE_SCHEMA_FROM_CLASS_METHOD, new ResultHandle[]{beanClassHandler});
        ResultHandle mappedTableHandle = methodCreator.invokeInterfaceMethod(table.getTableMethodDescriptor(), dynamoEnhancedClientHandle, new ResultHandle[]{tableNameHandler, tableSchemaHandle});
        methodCreator.returnValue(mappedTableHandle);
    }
}

