/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.enhanced.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@ApplicationScoped
public class DynamodbEnhancedClientProducer {
    private DynamoDbEnhancedClient syncEnhancedClient;
    private DynamoDbEnhancedAsyncClient asyncEnhancedClient;

    public void setDynamoDbClient(DynamoDbClient client) {
        this.syncEnhancedClient = DynamoDbEnhancedClient.builder().dynamoDbClient(client).build();
    }

    public void setDynamoDbAsyncClient(DynamoDbAsyncClient client) {
        this.asyncEnhancedClient = DynamoDbEnhancedAsyncClient.builder().dynamoDbClient(client).build();
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public DynamoDbEnhancedClient client() {
        if (this.syncEnhancedClient == null) {
            throw new IllegalStateException("The DynamoDbEnhancedClient is required no DynamoDB client has been configured.");
        }
        return this.syncEnhancedClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public DynamoDbEnhancedAsyncClient asyncClient() {
        if (this.asyncEnhancedClient == null) {
            throw new IllegalStateException("The DynamoDbEnhancedAsyncClient is required but no DynamoDB async client has been configured.");
        }
        return this.asyncEnhancedClient;
    }
}

