/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.eventbridge.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonHttpClients;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.spi.EventLoopGroupBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkus.amazon.eventbridge.runtime.EventBridgeBuildTimeConfig;
import io.quarkus.amazon.eventbridge.runtime.EventBridgeClientProducer;
import io.quarkus.amazon.eventbridge.runtime.EventBridgeRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeClientBuilder;

public class EventBridgeProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_KINESIS = "amazon-eventbridge";
    EventBridgeBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_KINESIS;
    }

    protected String configName() {
        return "eventbridge";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)EventBridgeClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)EventBridgeAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/eventbridge/execution.interceptors";
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.unremovableOf(EventBridgeClientProducer.class);
    }

    @BuildStep
    void setup(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        this.setupExtension(extensionSslNativeSupport, feature, interceptors);
    }

    @BuildStep
    void discover(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        this.discoverClient(beanRegistrationPhase, requireClientProducer);
    }

    @BuildStep
    void setupClient(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<AmazonClientBuildItem> clientProducer) {
        this.setupClient(clientRequirements, clientProducer, this.buildTimeConfig.sdk(), this.buildTimeConfig.syncClient(), this.buildTimeConfig.asyncClient());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<AmazonClientBuildItem> amazonClients, EventBridgeRecorder recorder, AmazonClientApacheTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtSyncTransport(List<AmazonClientBuildItem> amazonClients, EventBridgeRecorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createAwsCrtSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<AmazonClientBuildItem> amazonClients, EventBridgeRecorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<AmazonClientBuildItem> amazonClients, EventBridgeRecorder recorder, AmazonClientNettyTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports, EventLoopGroupBuildItem eventLoopSupplier) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports, eventLoopSupplier.getMainEventLoopGroup());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtAsyncTransport(List<AmazonClientBuildItem> amazonClients, EventBridgeRecorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createAwsCrtAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(EventBridgeRecorder recorder, Capabilities capabilities, AmazonClientCommonRecorder commonRecorder, AmazonClientOpenTelemetryRecorder otelRecorder, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        this.createClientBuilders(capabilities, (AmazonClientRecorder)recorder, commonRecorder, otelRecorder, (HasSdkBuildTimeConfig)this.buildTimeConfig, syncTransports, asyncTransports, EventBridgeClientBuilder.class, EventBridgeAsyncClientBuilder.class, null, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem);
    }
}

