/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.eventbridge.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.eventbridge.runtime.EventBridgeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeAsyncClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeClientBuilder;

@Recorder
public class EventBridgeRecorder
extends AmazonClientRecorder {
    final RuntimeValue<EventBridgeConfig> config;

    public EventBridgeRecorder(RuntimeValue<EventBridgeConfig> config) {
        this.config = config;
    }

    public RuntimeValue<? extends HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return this.config;
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return ((EventBridgeConfig)this.config.getValue()).asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return ((EventBridgeConfig)this.config.getValue()).syncClient();
    }

    public AwsSyncClientBuilder<?, ?> getSyncClientBuilder() {
        EventBridgeClientBuilder builder = EventBridgeClient.builder();
        return builder;
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        EventBridgeAsyncClientBuilder builder = EventBridgeAsyncClient.builder();
        return builder;
    }
}

